/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthStateCacheable;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestScheme;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.HttpAuthenticator;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestHttpAuthenticator {
    private AuthExchange authExchange;
    private CacheableAuthState authScheme;
    private HttpClientContext context;
    private HttpHost defaultHost;
    private CredentialsProvider credentialsProvider;
    private Lookup<AuthSchemeFactory> authSchemeRegistry;
    private HttpAuthenticator httpAuthenticator;

    @BeforeEach
    public void setUp() throws Exception {
        this.authExchange = new AuthExchange();
        this.authScheme = (CacheableAuthState)Mockito.mock(CacheableAuthState.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.CALLS_REAL_METHODS));
        Mockito.when((Object)this.authScheme.isChallengeComplete()).thenReturn((Object)Boolean.TRUE);
        this.context = HttpClientContext.create();
        this.defaultHost = new HttpHost("localhost", 80);
        this.credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        this.context.setCredentialsProvider(this.credentialsProvider);
        this.authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).build();
        this.context.setAuthSchemeRegistry(this.authSchemeRegistry);
        this.httpAuthenticator = new HttpAuthenticator();
    }

    @Test
    public void testUpdateAuthExchange() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        Assertions.assertTrue((boolean)this.httpAuthenticator.isChallenged(this.defaultHost, ChallengeType.TARGET, (HttpResponse)response, this.authExchange, (HttpContext)this.context));
    }

    @Test
    public void testAuthenticationRequestedAfterSuccess() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        this.authExchange.select((AuthScheme)this.authScheme);
        this.authExchange.setState(AuthExchange.State.SUCCESS);
        Assertions.assertTrue((boolean)this.httpAuthenticator.isChallenged(this.defaultHost, ChallengeType.TARGET, (HttpResponse)response, this.authExchange, (HttpContext)this.context));
    }

    @Test
    public void testAuthenticationNotRequestedUnchallenged() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        Assertions.assertFalse((boolean)this.httpAuthenticator.isChallenged(this.defaultHost, ChallengeType.TARGET, (HttpResponse)response, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.UNCHALLENGED, (Object)this.authExchange.getState());
    }

    @Test
    public void testAuthenticationNotRequestedSuccess1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        this.authExchange.select((AuthScheme)this.authScheme);
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        Assertions.assertFalse((boolean)this.httpAuthenticator.isChallenged(this.defaultHost, ChallengeType.TARGET, (HttpResponse)response, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.SUCCESS, (Object)this.authExchange.getState());
    }

    @Test
    public void testAuthenticationNotRequestedSuccess2() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        this.authExchange.select((AuthScheme)this.authScheme);
        this.authExchange.setState(AuthExchange.State.HANDSHAKE);
        Assertions.assertFalse((boolean)this.httpAuthenticator.isChallenged(this.defaultHost, ChallengeType.TARGET, (HttpResponse)response, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.SUCCESS, (Object)this.authExchange.getState());
    }

    @Test
    public void testAuthentication() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"whatever realm=\"realm1\", stuff=\"1234\""));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("user", "pass".toCharArray());
        Mockito.when((Object)this.credentialsProvider.getCredentials((AuthScope)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)credentials);
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertTrue((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.CHALLENGED, (Object)this.authExchange.getState());
        Queue options = this.authExchange.getAuthOptions();
        Assertions.assertNotNull((Object)options);
        AuthScheme authScheme1 = (AuthScheme)options.poll();
        Assertions.assertNotNull((Object)authScheme1);
        Assertions.assertEquals((Object)"Digest", (Object)authScheme1.getName());
        AuthScheme authScheme2 = (AuthScheme)options.poll();
        Assertions.assertNotNull((Object)authScheme2);
        Assertions.assertEquals((Object)"Basic", (Object)authScheme2.getName());
        Assertions.assertNull(options.poll());
    }

    @Test
    public void testAuthenticationCredentialsForBasic() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", nonce=\"1234\""));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("user", "pass".toCharArray());
        Mockito.when((Object)this.credentialsProvider.getCredentials((AuthScope)Mockito.eq((Object)new AuthScope(host, "test", "Basic")), (HttpContext)Mockito.any())).thenReturn((Object)credentials);
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertTrue((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.CHALLENGED, (Object)this.authExchange.getState());
        Queue options = this.authExchange.getAuthOptions();
        Assertions.assertNotNull((Object)options);
        AuthScheme authScheme1 = (AuthScheme)options.poll();
        Assertions.assertNotNull((Object)authScheme1);
        Assertions.assertEquals((Object)"Basic", (Object)authScheme1.getName());
        Assertions.assertNull(options.poll());
    }

    @Test
    public void testAuthenticationNoChallenges() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertFalse((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
    }

    @Test
    public void testAuthenticationNoSupportedChallenges() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"This realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"That realm=\"realm1\", nonce=\"1234\""));
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertFalse((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
    }

    @Test
    public void testAuthenticationNoCredentials() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", nonce=\"1234\""));
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertFalse((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
    }

    @Test
    public void testAuthenticationFailed() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", nonce=\"1234\""));
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        this.authExchange.select((AuthScheme)this.authScheme);
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertFalse((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.FAILURE, (Object)this.authExchange.getState());
    }

    @Test
    public void testAuthenticationFailedPreviously() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", nonce=\"1234\""));
        this.authExchange.setState(AuthExchange.State.FAILURE);
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertFalse((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.FAILURE, (Object)this.authExchange.getState());
    }

    @Test
    public void testAuthenticationFailure() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"whatever realm=\"realm1\", stuff=\"1234\""));
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        this.authExchange.select((AuthScheme)new BasicScheme());
        Assertions.assertFalse((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.FAILURE, (Object)this.authExchange.getState());
    }

    @Test
    public void testAuthenticationHandshaking() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", stale=true, nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"whatever realm=\"realm1\", stuff=\"1234\""));
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        this.authExchange.select((AuthScheme)new DigestScheme());
        Assertions.assertTrue((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.HANDSHAKE, (Object)this.authExchange.getState());
    }

    @Test
    public void testAuthenticationNoMatchingChallenge() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"whatever realm=\"realm1\", stuff=\"1234\""));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("user", "pass".toCharArray());
        Mockito.when((Object)this.credentialsProvider.getCredentials((AuthScope)Mockito.eq((Object)new AuthScope(host, "realm1", "Digest")), (HttpContext)Mockito.any())).thenReturn((Object)credentials);
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        this.authExchange.select((AuthScheme)new BasicScheme());
        Assertions.assertTrue((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.CHALLENGED, (Object)this.authExchange.getState());
        Queue options = this.authExchange.getAuthOptions();
        Assertions.assertNotNull((Object)options);
        AuthScheme authScheme1 = (AuthScheme)options.poll();
        Assertions.assertNotNull((Object)authScheme1);
        Assertions.assertEquals((Object)"Digest", (Object)authScheme1.getName());
        Assertions.assertNull(options.poll());
    }

    @Test
    public void testAuthenticationException() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse(401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", (Object)"blah blah blah"));
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        Assertions.assertFalse((boolean)this.httpAuthenticator.updateAuthState(host, ChallengeType.TARGET, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authExchange, (HttpContext)this.context));
        Assertions.assertEquals((Object)AuthExchange.State.UNCHALLENGED, (Object)this.authExchange.getState());
        Assertions.assertNull((Object)this.authExchange.getAuthScheme());
    }

    @Test
    public void testAuthFailureState() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authExchange.setState(AuthExchange.State.FAILURE);
        this.authExchange.select((AuthScheme)this.authScheme);
        this.httpAuthenticator.addAuthResponse(this.defaultHost, ChallengeType.TARGET, (HttpRequest)request, this.authExchange, (HttpContext)this.context);
        Assertions.assertFalse((boolean)request.containsHeader("Authorization"));
        ((CacheableAuthState)Mockito.verify((Object)this.authScheme, (VerificationMode)Mockito.never())).generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
    }

    @Test
    public void testAuthChallengeStateNoOption() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        this.authExchange.select((AuthScheme)this.authScheme);
        Mockito.when((Object)this.authScheme.generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)"stuff");
        this.httpAuthenticator.addAuthResponse(this.defaultHost, ChallengeType.TARGET, (HttpRequest)request, this.authExchange, (HttpContext)this.context);
        Assertions.assertTrue((boolean)request.containsHeader("Authorization"));
    }

    @Test
    public void testAuthChallengeStateOneOptions() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        LinkedList<CacheableAuthState> authOptions = new LinkedList<CacheableAuthState>();
        authOptions.add(this.authScheme);
        this.authExchange.setOptions(authOptions);
        Mockito.when((Object)this.authScheme.generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)"stuff");
        this.httpAuthenticator.addAuthResponse(this.defaultHost, ChallengeType.TARGET, (HttpRequest)request, this.authExchange, (HttpContext)this.context);
        Assertions.assertSame((Object)this.authScheme, (Object)this.authExchange.getAuthScheme());
        Assertions.assertNull((Object)this.authExchange.getAuthOptions());
        Assertions.assertTrue((boolean)request.containsHeader("Authorization"));
    }

    @Test
    public void testAuthChallengeStateMultipleOption() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authExchange.setState(AuthExchange.State.CHALLENGED);
        LinkedList<AuthScheme> authOptions = new LinkedList<AuthScheme>();
        AuthScheme authScheme1 = (AuthScheme)Mockito.mock(AuthScheme.class);
        ((AuthScheme)Mockito.doThrow((Throwable[])new Throwable[]{new AuthenticationException()}).when((Object)authScheme1)).generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
        AuthScheme authScheme2 = (AuthScheme)Mockito.mock(AuthScheme.class);
        Mockito.when((Object)authScheme2.generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)"stuff");
        authOptions.add(authScheme1);
        authOptions.add(authScheme2);
        this.authExchange.setOptions(authOptions);
        this.httpAuthenticator.addAuthResponse(this.defaultHost, ChallengeType.TARGET, (HttpRequest)request, this.authExchange, (HttpContext)this.context);
        Assertions.assertSame((Object)authScheme2, (Object)this.authExchange.getAuthScheme());
        Assertions.assertNull((Object)this.authExchange.getAuthOptions());
        Assertions.assertTrue((boolean)request.containsHeader("Authorization"));
    }

    @Test
    public void testAuthSuccess() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authExchange.setState(AuthExchange.State.SUCCESS);
        this.authExchange.select((AuthScheme)this.authScheme);
        Mockito.when((Object)this.authScheme.isConnectionBased()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.authScheme.generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)"stuff");
        this.httpAuthenticator.addAuthResponse(this.defaultHost, ChallengeType.TARGET, (HttpRequest)request, this.authExchange, (HttpContext)this.context);
        Assertions.assertSame((Object)this.authScheme, (Object)this.authExchange.getAuthScheme());
        Assertions.assertNull((Object)this.authExchange.getAuthOptions());
        Assertions.assertTrue((boolean)request.containsHeader("Authorization"));
    }

    @Test
    public void testAuthSuccessConnectionBased() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authExchange.setState(AuthExchange.State.SUCCESS);
        this.authExchange.select((AuthScheme)this.authScheme);
        Mockito.when((Object)this.authScheme.isConnectionBased()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.authScheme.generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)"stuff");
        this.httpAuthenticator.addAuthResponse(this.defaultHost, ChallengeType.TARGET, (HttpRequest)request, this.authExchange, (HttpContext)this.context);
        Assertions.assertFalse((boolean)request.containsHeader("Authorization"));
        ((CacheableAuthState)Mockito.verify((Object)this.authScheme, (VerificationMode)Mockito.never())).generateAuthResponse((HttpHost)Mockito.eq((Object)this.defaultHost), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
    }

    @AuthStateCacheable
    abstract class CacheableAuthState
    implements AuthScheme {
        CacheableAuthState() {
        }

        public String getName() {
            return "Basic";
        }
    }
}

