/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.auth.DigestScheme;
import org.apache.hc.client5.http.impl.auth.HttpEntityDigester;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDigestScheme {
    private static AuthChallenge parse(String s) throws ParseException {
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List authChallenges = AuthChallengeParser.INSTANCE.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertEquals((int)1, (int)authChallenges.size());
        return (AuthChallenge)authChallenges.get(0);
    }

    @Test
    public void testDigestAuthenticationEmptyChallenge1() throws Exception {
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest");
        DigestScheme authscheme = new DigestScheme();
        Assertions.assertThrows(MalformedChallengeException.class, () -> TestDigestScheme.lambda$testDigestAuthenticationEmptyChallenge1$0((AuthScheme)authscheme, authChallenge));
    }

    @Test
    public void testDigestAuthenticationEmptyChallenge2() throws Exception {
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest ");
        DigestScheme authscheme = new DigestScheme();
        Assertions.assertThrows(MalformedChallengeException.class, () -> TestDigestScheme.lambda$testDigestAuthenticationEmptyChallenge2$1((AuthScheme)authscheme, authChallenge));
    }

    @Test
    public void testDigestAuthenticationWithDefaultCreds() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertTrue((boolean)authscheme.isChallengeComplete());
        Assertions.assertFalse((boolean)authscheme.isConnectionBased());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assertions.assertEquals((Object)"e95a7ddf37c2eab009568b1ed134f89a", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthentication() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assertions.assertEquals((Object)"e95a7ddf37c2eab009568b1ed134f89a", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationInvalidInput() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertThrows(NullPointerException.class, () -> authscheme.isResponseReady(null, credentialsProvider, null));
        Assertions.assertThrows(NullPointerException.class, () -> authscheme.isResponseReady(host, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> authscheme.generateAuthResponse(host, null, null));
    }

    @Test
    public void testDigestAuthenticationWithSHA() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", algorithm=SHA";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", algorithm=SHA");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assertions.assertEquals((Object)"8769e82e4e28ecc040b969562b9050580c6d186d", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationWithQueryStringInDigestURI() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/?param=value");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/?param=value", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assertions.assertEquals((Object)"a847f58f5fef0bc087bcb9c3eb30e042", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationNoRealm() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest no-realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest no-realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        Assertions.assertThrows(AuthenticationException.class, () -> TestDigestScheme.lambda$testDigestAuthenticationNoRealm$5(authscheme, host, (HttpRequest)request));
    }

    @Test
    public void testDigestAuthenticationNoNonce() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", no-nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", no-nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        Assertions.assertThrows(AuthenticationException.class, () -> TestDigestScheme.lambda$testDigestAuthenticationNoNonce$6(authscheme, host, (HttpRequest)request));
    }

    @Test
    public void testDigestAuthenticationNoAlgorithm() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertNull((Object)table.get("algorithm"));
    }

    @Test
    public void testDigestAuthenticationMD5Algorithm() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", algorithm=MD5";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", algorithm=MD5");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"MD5", (Object)table.get("algorithm"));
    }

    @Test
    public void testDigestAuthenticationMD5Sess() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"auth,auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"auth,auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertTrue((authResponse.indexOf("nc=00000001") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((authResponse.indexOf("qop=auth") > 0 ? 1 : 0) != 0);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"MD5-sess", (Object)table.get("algorithm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"e273f1776275974f1a120d8b92c5b3cb", (Object)table.get("nonce"));
        Assertions.assertEquals((int)1, (int)Integer.parseInt(table.get("nc"), 16));
        Assertions.assertNotNull((Object)table.get("cnonce"));
        Assertions.assertEquals((Object)"SomeString", (Object)table.get("opaque"));
        Assertions.assertEquals((Object)"auth", (Object)table.get("qop"));
        Assertions.assertNotNull((Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationMD5SessNoQop() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"MD5-sess", (Object)table.get("algorithm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"e273f1776275974f1a120d8b92c5b3cb", (Object)table.get("nonce"));
        Assertions.assertNull((Object)table.get("nc"));
        Assertions.assertEquals((Object)"SomeString", (Object)table.get("opaque"));
        Assertions.assertNull((Object)table.get("qop"));
        Assertions.assertNotNull((Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationMD5SessUnknownQop() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"stuff\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"stuff\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        Assertions.assertThrows(AuthenticationException.class, () -> TestDigestScheme.lambda$testDigestAuthenticationMD5SessUnknownQop$7(authscheme, host, (HttpRequest)request));
    }

    @Test
    public void testDigestAuthenticationUnknownAlgo() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=stuff, qop=\"auth\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=stuff, qop=\"auth\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        Assertions.assertThrows(AuthenticationException.class, () -> TestDigestScheme.lambda$testDigestAuthenticationUnknownAlgo$8(authscheme, host, (HttpRequest)request));
    }

    @Test
    public void testDigestAuthenticationWithStaleNonce() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", stale=\"true\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", stale=\"true\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertFalse((boolean)authscheme.isChallengeComplete());
    }

    private static Map<String, String> parseAuthResponse(String authResponse) {
        if (!authResponse.startsWith("Digest ")) {
            return null;
        }
        String s = authResponse.substring(7);
        ParserCursor cursor = new ParserCursor(0, s.length());
        HeaderElement[] elements = BasicHeaderValueParser.INSTANCE.parseElements((CharSequence)s, cursor);
        HashMap<String, String> map = new HashMap<String, String>(elements.length);
        for (HeaderElement element : elements) {
            map.put(element.getName(), element.getValue());
        }
        return map;
    }

    @Test
    public void testDigestNouceCount() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge1 = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth";
        AuthChallenge authChallenge1 = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge1, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse1 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table1 = TestDigestScheme.parseAuthResponse(authResponse1);
        Assertions.assertEquals((Object)"00000001", (Object)table1.get("nc"));
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse2 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table2 = TestDigestScheme.parseAuthResponse(authResponse2);
        Assertions.assertEquals((Object)"00000002", (Object)table2.get("nc"));
        String challenge2 = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth";
        AuthChallenge authChallenge2 = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth");
        authscheme.processChallenge(authChallenge2, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse3 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table3 = TestDigestScheme.parseAuthResponse(authResponse3);
        Assertions.assertEquals((Object)"00000003", (Object)table3.get("nc"));
        String challenge3 = "Digest realm=\"realm1\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", qop=auth";
        AuthChallenge authChallenge3 = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", qop=auth");
        authscheme.processChallenge(authChallenge3, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse4 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table4 = TestDigestScheme.parseAuthResponse(authResponse4);
        Assertions.assertEquals((Object)"00000001", (Object)table4.get("nc"));
    }

    @Test
    public void testDigestMD5SessA1AndCnonceConsistency() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "subnet.domain.com", null), "username", "password".toCharArray()).build();
        String challenge1 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"";
        AuthChallenge authChallenge1 = TestDigestScheme.parse("Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge1, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse1 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table1 = TestDigestScheme.parseAuthResponse(authResponse1);
        Assertions.assertEquals((Object)"00000001", (Object)table1.get("nc"));
        String cnonce1 = authscheme.getCnonce();
        String sessionKey1 = authscheme.getA1();
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse2 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table2 = TestDigestScheme.parseAuthResponse(authResponse2);
        Assertions.assertEquals((Object)"00000002", (Object)table2.get("nc"));
        String cnonce2 = authscheme.getCnonce();
        String sessionKey2 = authscheme.getA1();
        Assertions.assertEquals((Object)cnonce1, (Object)cnonce2);
        Assertions.assertEquals((Object)sessionKey1, (Object)sessionKey2);
        String challenge2 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"";
        AuthChallenge authChallenge2 = TestDigestScheme.parse("Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"");
        authscheme.processChallenge(authChallenge2, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse3 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table3 = TestDigestScheme.parseAuthResponse(authResponse3);
        Assertions.assertEquals((Object)"00000003", (Object)table3.get("nc"));
        String cnonce3 = authscheme.getCnonce();
        String sessionKey3 = authscheme.getA1();
        Assertions.assertEquals((Object)cnonce1, (Object)cnonce3);
        Assertions.assertEquals((Object)sessionKey1, (Object)sessionKey3);
        String challenge3 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"fedcba0987654321\", charset=utf-8, realm=\"subnet.domain.com\"";
        AuthChallenge authChallenge3 = TestDigestScheme.parse("Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"fedcba0987654321\", charset=utf-8, realm=\"subnet.domain.com\"");
        authscheme.processChallenge(authChallenge3, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse4 = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table4 = TestDigestScheme.parseAuthResponse(authResponse4);
        Assertions.assertEquals((Object)"00000001", (Object)table4.get("nc"));
        String cnonce4 = authscheme.getCnonce();
        String sessionKey4 = authscheme.getA1();
        Assertions.assertNotEquals((Object)cnonce1, (Object)cnonce4);
        Assertions.assertNotEquals((Object)sessionKey1, (Object)sessionKey4);
    }

    @Test
    public void testHttpEntityDigest() throws Exception {
        HttpEntityDigester digester = new HttpEntityDigester(MessageDigest.getInstance("MD5"));
        Assertions.assertNull((Object)digester.getDigest());
        digester.write(97);
        digester.write(98);
        digester.write(99);
        digester.write(228);
        digester.write(246);
        digester.write(252);
        digester.write(new byte[]{97, 98, 99});
        Assertions.assertNull((Object)digester.getDigest());
        digester.close();
        Assertions.assertEquals((Object)"acd2b59cd01c7737d8069015584c6cac", (Object)DigestScheme.formatHex((byte[])digester.getDigest()));
        Assertions.assertThrows(IOException.class, () -> digester.write(97));
        Assertions.assertThrows(IOException.class, () -> digester.write(new byte[]{97, 98, 99}));
    }

    @Test
    public void testDigestAuthenticationQopAuthInt() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("Post", "/");
        request.setEntity((HttpEntity)new StringEntity("abc\u00e4\u00f6\u00fcabc", StandardCharsets.ISO_8859_1));
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"Post:/:acd2b59cd01c7737d8069015584c6cac", (Object)authscheme.getA2());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"auth-int", (Object)table.get("qop"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
    }

    @Test
    public void testDigestAuthenticationQopAuthIntNullEntity() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Post", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"Post:/:d41d8cd98f00b204e9800998ecf8427e", (Object)authscheme.getA2());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"auth-int", (Object)table.get("qop"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
    }

    @Test
    public void testDigestAuthenticationQopAuthOrAuthIntNonRepeatableEntity() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("Post", "/");
        request.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{97}), -1L, ContentType.DEFAULT_TEXT));
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"Post:/", (Object)authscheme.getA2());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assertions.assertEquals((Object)"username", (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"auth", (Object)table.get("qop"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
    }

    @Test
    public void testParameterCaseSensitivity() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "-", null), "username", "password".toCharArray()).build();
        String challenge = "Digest Realm=\"-\", nonce=\"YjYuNGYyYmJhMzUuY2I5ZDhlZDE5M2ZlZDM 1Mjk3NGJkNTIyYjgyNTcwMjQ=\", opaque=\"98700A3D9CE17065E2246B41035C6609\", qop=\"auth\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest Realm=\"-\", nonce=\"YjYuNGYyYmJhMzUuY2I5ZDhlZDE5M2ZlZDM 1Mjk3NGJkNTIyYjgyNTcwMjQ=\", opaque=\"98700A3D9CE17065E2246B41035C6609\", qop=\"auth\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertEquals((Object)"-", (Object)authscheme.getRealm());
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        authscheme.generateAuthResponse(host, (HttpRequest)request, null);
    }

    @Test
    public void testDigestAuthenticationQopIntOnlyNonRepeatableEntity() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("Post", "/");
        request.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{97}), -1L, ContentType.DEFAULT_TEXT));
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        Assertions.assertThrows(AuthenticationException.class, () -> TestDigestScheme.lambda$testDigestAuthenticationQopIntOnlyNonRepeatableEntity$11(authscheme, host, (ClassicHttpRequest)request));
    }

    @Test
    public void testSerialization() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"");
        DigestScheme digestScheme = new DigestScheme();
        digestScheme.processChallenge(authChallenge, null);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(digestScheme);
        out.flush();
        byte[] raw = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
        DigestScheme authScheme = (DigestScheme)in.readObject();
        Assertions.assertEquals((Object)digestScheme.getName(), (Object)authScheme.getName());
        Assertions.assertEquals((Object)digestScheme.getRealm(), (Object)authScheme.getRealm());
        Assertions.assertEquals((Object)digestScheme.isChallengeComplete(), (Object)authScheme.isChallengeComplete());
        Assertions.assertEquals((Object)digestScheme.getA1(), (Object)authScheme.getA1());
        Assertions.assertEquals((Object)digestScheme.getA2(), (Object)authScheme.getA2());
        Assertions.assertEquals((Object)digestScheme.getCnonce(), (Object)authScheme.getCnonce());
    }

    @Test
    public void testDigestAuthenticationWithUserHash() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", userhash=true";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", userhash=true");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update("username:realm1".getBytes(StandardCharsets.UTF_8));
        String expectedUserhash = TestDigestScheme.bytesToHex(md.digest());
        Assertions.assertEquals((Object)expectedUserhash, (Object)table.get("username"));
        Assertions.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assertions.assertEquals((Object)"/", (Object)table.get("uri"));
        Assertions.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assertions.assertEquals((Object)"3b6561ceb73e5ffe9314a695179f23f9", (Object)table.get("response"));
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Test
    public void testDigestAuthenticationWithQuotedStringsAndWhitespace() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "\"myhost@example.com\"", null), "\"Mufasa\"", "\"Circle Of Life\"".toCharArray()).build();
        String challenge = "Digest realm=\"\\\"myhost@example.com\\\"\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", userhash=true";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"\\\"myhost@example.com\\\"\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", userhash=true");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        MessageDigest md = MessageDigest.getInstance("MD5");
        String a1 = "Mufasa:myhost@example.com:Circle Of Life";
        md.update("Mufasa:myhost@example.com:Circle Of Life".getBytes(StandardCharsets.UTF_8));
        String response = table.get("response");
        Assertions.assertNotNull((Object)response);
    }

    @Test
    public void testDigestAuthenticationWithInvalidUsernameAndValidUsernameStar() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "invalid\"username", "password".toCharArray()).build();
        String encodedUsername = "UTF-8''J%C3%A4s%C3%B8n%20Doe";
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\", username*=\"UTF-8''J%C3%A4s%C3%B8n%20Doe\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\", username*=\"UTF-8''J%C3%A4s%C3%B8n%20Doe\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertNotNull((Object)authResponse);
    }

    @Test
    public void testDigestAuthenticationWithHighAsciiCharInUsername() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "high\u007fchar", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertTrue((boolean)authResponse.contains("username*"));
    }

    @Test
    public void testDigestAuthenticationWithExtendedAsciiCharInUsername() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "username\u0080", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertTrue((boolean)authResponse.contains("username*"));
    }

    @Test
    public void testDigestAuthenticationWithNonAsciiUsername() throws Exception {
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "realm1", null), "J\u00e4s\u00f8n Doe", "password".toCharArray()).build();
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"";
        AuthChallenge authChallenge = TestDigestScheme.parse("Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        String authResponse = authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertTrue((boolean)authResponse.contains("username*"));
    }

    private static /* synthetic */ void lambda$testDigestAuthenticationQopIntOnlyNonRepeatableEntity$11(DigestScheme authscheme, HttpHost host, ClassicHttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, (HttpRequest)request, null);
    }

    private static /* synthetic */ void lambda$testDigestAuthenticationUnknownAlgo$8(DigestScheme authscheme, HttpHost host, HttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, request, null);
    }

    private static /* synthetic */ void lambda$testDigestAuthenticationMD5SessUnknownQop$7(DigestScheme authscheme, HttpHost host, HttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, request, null);
    }

    private static /* synthetic */ void lambda$testDigestAuthenticationNoNonce$6(DigestScheme authscheme, HttpHost host, HttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, request, null);
    }

    private static /* synthetic */ void lambda$testDigestAuthenticationNoRealm$5(DigestScheme authscheme, HttpHost host, HttpRequest request) throws Throwable {
        authscheme.generateAuthResponse(host, request, null);
    }

    private static /* synthetic */ void lambda$testDigestAuthenticationEmptyChallenge2$1(AuthScheme authscheme, AuthChallenge authChallenge) throws Throwable {
        authscheme.processChallenge(authChallenge, null);
    }

    private static /* synthetic */ void lambda$testDigestAuthenticationEmptyChallenge1$0(AuthScheme authscheme, AuthChallenge authChallenge) throws Throwable {
        authscheme.processChallenge(authChallenge, null);
    }
}

