/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;

public class AsyncClientFullDuplexExchange {
    public static void main(String[] args) throws Exception {
        MinimalHttpAsyncClient client = HttpAsyncClients.createMinimal((H2Config)H2Config.DEFAULT, (Http1Config)Http1Config.DEFAULT, (IOReactorConfig)IOReactorConfig.DEFAULT);
        client.start();
        final BasicHttpRequest request = BasicRequestBuilder.post((String)"http://httpbin.org/post").build();
        final BasicRequestProducer requestProducer = new BasicRequestProducer((HttpRequest)request, (AsyncEntityProducer)new BasicAsyncEntityProducer((CharSequence)"stuff", ContentType.TEXT_PLAIN));
        final BasicResponseConsumer responseConsumer = new BasicResponseConsumer((AsyncEntityConsumer)new StringAsyncEntityConsumer());
        System.out.println("Executing request " + request);
        final CountDownLatch latch = new CountDownLatch(1);
        client.execute(new AsyncClientExchangeHandler(){

            public void releaseResources() {
                requestProducer.releaseResources();
                responseConsumer.releaseResources();
                latch.countDown();
            }

            public void cancel() {
                System.out.println(request + " cancelled");
            }

            public void failed(Exception cause) {
                System.out.println(request + "->" + cause);
            }

            public void produceRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
                requestProducer.sendRequest(channel, context);
            }

            public int available() {
                return requestProducer.available();
            }

            public void produce(DataStreamChannel channel) throws IOException {
                requestProducer.produce(channel);
            }

            public void consumeInformation(HttpResponse response, HttpContext context) throws HttpException, IOException {
                System.out.println(request + "->" + new StatusLine(response));
            }

            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
                System.out.println(request + "->" + new StatusLine(response));
                responseConsumer.consumeResponse(response, entityDetails, context, null);
            }

            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                responseConsumer.updateCapacity(capacityChannel);
            }

            public void consume(ByteBuffer src) throws IOException {
                responseConsumer.consume(src);
            }

            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                responseConsumer.streamEnd(trailers);
            }
        });
        latch.await(1L, TimeUnit.MINUTES);
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

