/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientConnectionConfig {
    public static void main(String[] args) throws Exception {
        PoolingAsyncClientConnectionManager cm = PoolingAsyncClientConnectionManagerBuilder.create().setConnectionConfigResolver(route -> {
            HttpHost targetHost = route.getTargetHost();
            if (route.isSecure()) {
                return ConnectionConfig.custom().setConnectTimeout(Timeout.ofMinutes((long)2L)).setSocketTimeout(Timeout.ofMinutes((long)2L)).setValidateAfterInactivity(TimeValue.ofMinutes((long)1L)).setTimeToLive(TimeValue.ofHours((long)1L)).build();
            }
            return ConnectionConfig.custom().setConnectTimeout(Timeout.ofMinutes((long)1L)).setSocketTimeout(Timeout.ofMinutes((long)1L)).setValidateAfterInactivity(TimeValue.ofSeconds((long)15L)).setTimeToLive(TimeValue.ofMinutes((long)15L)).build();
        }).setTlsConfigResolver(host -> {
            if (host.getSchemeName().equalsIgnoreCase("httpbin.org")) {
                return TlsConfig.custom().setSupportedProtocols(new TLS[]{TLS.V_1_3}).setHandshakeTimeout(Timeout.ofSeconds((long)10L)).build();
            }
            return TlsConfig.DEFAULT;
        }).build();
        try (CloseableHttpAsyncClient client = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)cm).build();){
            client.start();
            for (URIScheme uriScheme : URIScheme.values()) {
                final SimpleHttpRequest request = SimpleRequestBuilder.get().setHttpHost(new HttpHost(uriScheme.id, "httpbin.org")).setPath("/headers").build();
                System.out.println("Executing request " + request);
                Future future = client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                    public void completed(SimpleHttpResponse response) {
                        System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                        System.out.println(response.getBody());
                    }

                    public void failed(Exception ex) {
                        System.out.println(request + "->" + ex);
                    }

                    public void cancelled() {
                        System.out.println(request + " cancelled");
                    }
                });
                future.get();
            }
            System.out.println("Shutting down");
            client.close(CloseMode.GRACEFUL);
        }
    }
}

