/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.Header;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.client5.http.entity.mime.MultipartPartBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultipartPartBuilder {
    @Test
    public void testBuildBodyPartBasics() throws Exception {
        StringBody stringBody = new StringBody("stuff", ContentType.TEXT_PLAIN);
        MultipartPart part = MultipartPartBuilder.create().setBody((ContentBody)stringBody).build();
        Assertions.assertNotNull((Object)part);
        Assertions.assertEquals((Object)stringBody, (Object)part.getBody());
        Header header = part.getHeader();
        Assertions.assertNotNull((Object)header);
        TestMultipartPartBuilder.assertFields(Collections.singletonList(new MimeField("Content-Type", "text/plain; charset=UTF-8")), header.getFields());
    }

    @Test
    public void testBuildBodyPartMultipleBuilds() throws Exception {
        StringBody stringBody = new StringBody("stuff", ContentType.TEXT_PLAIN);
        MultipartPartBuilder builder = MultipartPartBuilder.create();
        MultipartPart part1 = builder.setBody((ContentBody)stringBody).build();
        Assertions.assertNotNull((Object)part1);
        Assertions.assertEquals((Object)stringBody, (Object)part1.getBody());
        Header header1 = part1.getHeader();
        Assertions.assertNotNull((Object)header1);
        TestMultipartPartBuilder.assertFields(Collections.singletonList(new MimeField("Content-Type", "text/plain; charset=UTF-8")), header1.getFields());
        FileBody fileBody = new FileBody(new File("/path/stuff.bin"), ContentType.DEFAULT_BINARY);
        MultipartPart part2 = builder.setBody((ContentBody)fileBody).build();
        Assertions.assertNotNull((Object)part2);
        Assertions.assertEquals((Object)fileBody, (Object)part2.getBody());
        Header header2 = part2.getHeader();
        Assertions.assertNotNull((Object)header2);
        TestMultipartPartBuilder.assertFields(Collections.singletonList(new MimeField("Content-Type", "application/octet-stream")), header2.getFields());
    }

    @Test
    public void testBuildBodyPartCustomHeaders() throws Exception {
        StringBody stringBody = new StringBody("stuff", ContentType.TEXT_PLAIN);
        MultipartPartBuilder builder = MultipartPartBuilder.create((ContentBody)stringBody);
        MultipartPart part1 = builder.addHeader("header1", "blah").addHeader("header3", "blah").addHeader("header3", "blah").addHeader("header3", "blah").addHeader("header3", "blah").addHeader("header3", "blah").build();
        Assertions.assertNotNull((Object)part1);
        Header header1 = part1.getHeader();
        Assertions.assertNotNull((Object)header1);
        TestMultipartPartBuilder.assertFields(Arrays.asList(new MimeField("header1", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("Content-Type", "text/plain; charset=UTF-8")), header1.getFields());
        MultipartPart part2 = builder.addHeader("header2", "yada").removeHeaders("header3").build();
        Assertions.assertNotNull((Object)part2);
        Header header2 = part2.getHeader();
        Assertions.assertNotNull((Object)header2);
        TestMultipartPartBuilder.assertFields(Arrays.asList(new MimeField("header1", "blah"), new MimeField("header2", "yada"), new MimeField("Content-Type", "text/plain; charset=UTF-8")), header2.getFields());
        MultipartPart part3 = builder.addHeader("Content-Disposition", "disposition stuff").addHeader("Content-Type", "type stuff").addHeader("Content-Transfer-Encoding", "encoding stuff").build();
        Assertions.assertNotNull((Object)part3);
        Header header3 = part3.getHeader();
        Assertions.assertNotNull((Object)header3);
        TestMultipartPartBuilder.assertFields(Arrays.asList(new MimeField("header1", "blah"), new MimeField("header2", "yada"), new MimeField("Content-Disposition", "disposition stuff"), new MimeField("Content-Type", "type stuff"), new MimeField("Content-Transfer-Encoding", "encoding stuff")), header3.getFields());
    }

    private static void assertFields(List<MimeField> expected, List<MimeField> result) {
        Assertions.assertNotNull(result);
        Assertions.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            MimeField expectedField = expected.get(i);
            MimeField resultField = result.get(i);
            Assertions.assertNotNull((Object)resultField);
            Assertions.assertEquals((Object)expectedField.getName(), (Object)resultField.getName());
            Assertions.assertEquals((Object)expectedField.getBody(), (Object)resultField.getBody());
        }
    }
}

