/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultipartContentBody {
    @Test
    public void testStringBody() throws Exception {
        StringBody b1 = new StringBody("text", ContentType.DEFAULT_TEXT);
        Assertions.assertEquals((long)4L, (long)b1.getContentLength());
        Assertions.assertEquals((Object)"UTF-8", (Object)b1.getCharset());
        Assertions.assertNull((Object)b1.getFilename());
        Assertions.assertEquals((Object)"text/plain", (Object)b1.getMimeType());
        Assertions.assertEquals((Object)"text", (Object)b1.getMediaType());
        Assertions.assertEquals((Object)"plain", (Object)b1.getSubType());
        StringBody b2 = new StringBody("more text", ContentType.create((String)"text/other", (Charset)StandardCharsets.ISO_8859_1));
        Assertions.assertEquals((long)9L, (long)b2.getContentLength());
        Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1.name(), (Object)b2.getCharset());
        Assertions.assertNull((Object)b2.getFilename());
        Assertions.assertEquals((Object)"text/other", (Object)b2.getMimeType());
        Assertions.assertEquals((Object)"text", (Object)b2.getMediaType());
        Assertions.assertEquals((Object)"other", (Object)b2.getSubType());
    }

    @Test
    public void testInputStreamBody() throws Exception {
        byte[] stuff = "Stuff".getBytes(StandardCharsets.US_ASCII);
        InputStreamBody b1 = new InputStreamBody((InputStream)new ByteArrayInputStream(stuff), "stuff");
        Assertions.assertEquals((long)-1L, (long)b1.getContentLength());
        Assertions.assertNull((Object)b1.getCharset());
        Assertions.assertEquals((Object)"stuff", (Object)b1.getFilename());
        Assertions.assertEquals((Object)"application/octet-stream", (Object)b1.getMimeType());
        Assertions.assertEquals((Object)"application", (Object)b1.getMediaType());
        Assertions.assertEquals((Object)"octet-stream", (Object)b1.getSubType());
        InputStreamBody b2 = new InputStreamBody((InputStream)new ByteArrayInputStream(stuff), ContentType.create((String)"some/stuff"), "stuff");
        Assertions.assertEquals((long)-1L, (long)b2.getContentLength());
        Assertions.assertNull((Object)b2.getCharset());
        Assertions.assertEquals((Object)"stuff", (Object)b2.getFilename());
        Assertions.assertEquals((Object)"some/stuff", (Object)b2.getMimeType());
        Assertions.assertEquals((Object)"some", (Object)b2.getMediaType());
        Assertions.assertEquals((Object)"stuff", (Object)b2.getSubType());
    }
}

