/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hc.client5.http.auth.BasicUserPrincipal;
import org.apache.hc.client5.http.auth.BearerToken;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.NTUserPrincipal;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCredentials {
    @Test
    public void testUsernamePasswordCredentialsBasics() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        Assertions.assertEquals((Object)"name", (Object)creds1.getUserName());
        Assertions.assertEquals((Object)new BasicUserPrincipal("name"), (Object)creds1.getUserPrincipal());
        Assertions.assertArrayEquals((char[])"pwd".toCharArray(), (char[])creds1.getUserPassword());
        Assertions.assertEquals((Object)"[principal: name]", (Object)creds1.toString());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("name", null);
        Assertions.assertEquals((Object)"name", (Object)creds2.getUserName());
        Assertions.assertEquals((Object)new BasicUserPrincipal("name"), (Object)creds2.getUserPrincipal());
        Assertions.assertNull((Object)creds2.getUserPassword());
        Assertions.assertEquals((Object)"[principal: name]", (Object)creds2.toString());
    }

    @Test
    public void testNTCredentialsBasics() {
        NTCredentials creds1 = new NTCredentials("name", "pwd".toCharArray(), "localhost", "domain");
        Assertions.assertEquals((Object)"name", (Object)creds1.getUserName());
        Assertions.assertEquals((Object)new NTUserPrincipal("DOMAIN", "name"), (Object)creds1.getUserPrincipal());
        Assertions.assertArrayEquals((char[])"pwd".toCharArray(), (char[])creds1.getPassword());
        Assertions.assertEquals((Object)("[principal: DOMAIN\\name][workstation: " + creds1.getWorkstation() + "][netbiosDomain: DOMAIN]"), (Object)creds1.toString());
        NTCredentials creds2 = new NTCredentials("name", null, null, null);
        Assertions.assertEquals((Object)"name", (Object)creds2.getUserName());
        Assertions.assertEquals((Object)new NTUserPrincipal(null, "name"), (Object)creds2.getUserPrincipal());
        Assertions.assertNull((Object)creds2.getPassword());
        Assertions.assertEquals((Object)("[principal: name][workstation: " + creds1.getWorkstation() + "][netbiosDomain: null]"), (Object)creds2.toString());
    }

    @Test
    public void testUsernamePasswordCredentialsHashCode() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("othername", "pwd".toCharArray());
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name", "otherpwd".toCharArray());
        Assertions.assertTrue((creds1.hashCode() == creds1.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((creds1.hashCode() != creds2.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((creds1.hashCode() == creds3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUsernamePasswordCredentialsEquals() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("othername", "pwd".toCharArray());
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name", "otherpwd".toCharArray());
        Assertions.assertEquals((Object)creds1, (Object)creds1);
        Assertions.assertNotEquals((Object)creds1, (Object)creds2);
        Assertions.assertEquals((Object)creds1, (Object)creds3);
    }

    @Test
    public void tesBearerTokenBasics() {
        BearerToken creds1 = new BearerToken("token of some sort");
        Assertions.assertEquals((Object)"token of some sort", (Object)creds1.getToken());
    }

    @Test
    public void testBearerTokenHashCode() {
        BearerToken creds1 = new BearerToken("token of some sort");
        BearerToken creds2 = new BearerToken("another token of some sort");
        BearerToken creds3 = new BearerToken("token of some sort");
        Assertions.assertTrue((creds1.hashCode() == creds1.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((creds1.hashCode() != creds2.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((creds1.hashCode() == creds3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testBearerTokenEquals() {
        BearerToken creds1 = new BearerToken("token of some sort");
        BearerToken creds2 = new BearerToken("another token of some sort");
        BearerToken creds3 = new BearerToken("token of some sort");
        Assertions.assertEquals((Object)creds1, (Object)creds1);
        Assertions.assertNotEquals((Object)creds1, (Object)creds2);
        Assertions.assertEquals((Object)creds1, (Object)creds3);
    }

    @Test
    public void testNTCredentialsHashCode() {
        NTCredentials creds1 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds2 = new NTCredentials("othername", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds3 = new NTCredentials("name", "otherpwd".toCharArray(), "SomeHost", "Domain");
        NTCredentials creds4 = new NTCredentials("name", "pwd".toCharArray(), "otherhost", "domain");
        NTCredentials creds5 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds6 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "ms");
        NTCredentials creds7 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        NTCredentials creds8 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds9 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        Assertions.assertTrue((creds1.hashCode() == creds1.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((creds1.hashCode() != creds2.hashCode() ? 1 : 0) != 0);
        Assertions.assertEquals((int)creds1.hashCode(), (int)creds3.hashCode());
        Assertions.assertEquals((int)creds1.hashCode(), (int)creds4.hashCode());
        Assertions.assertEquals((int)creds1.hashCode(), (int)creds5.hashCode());
        Assertions.assertNotEquals((int)creds1.hashCode(), (int)creds6.hashCode());
        Assertions.assertNotEquals((int)creds1.hashCode(), (int)creds7.hashCode());
        Assertions.assertEquals((int)creds8.hashCode(), (int)creds5.hashCode());
        Assertions.assertEquals((int)creds9.hashCode(), (int)creds7.hashCode());
    }

    @Test
    public void testNTCredentialsEquals() {
        NTCredentials creds1 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds2 = new NTCredentials("othername", "pwd".toCharArray(), "somehost", "domain");
        NTCredentials creds3 = new NTCredentials("name", "otherpwd".toCharArray(), "SomeHost", "Domain");
        NTCredentials creds4 = new NTCredentials("name", "pwd".toCharArray(), "otherhost", "domain");
        NTCredentials creds5 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds6 = new NTCredentials("name", "pwd".toCharArray(), "somehost", "ms");
        NTCredentials creds7 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        NTCredentials creds8 = new NTCredentials("name", "pwd".toCharArray(), null, "domain");
        NTCredentials creds9 = new NTCredentials("name", "pwd".toCharArray(), "somehost", null);
        Assertions.assertEquals((Object)creds1, (Object)creds1);
        Assertions.assertNotEquals((Object)creds1, (Object)creds2);
        Assertions.assertEquals((Object)creds1, (Object)creds3);
        Assertions.assertEquals((Object)creds1, (Object)creds4);
        Assertions.assertEquals((Object)creds1, (Object)creds5);
        Assertions.assertNotEquals((Object)creds1, (Object)creds6);
        Assertions.assertNotEquals((Object)creds1, (Object)creds7);
        Assertions.assertEquals((Object)creds8, (Object)creds5);
        Assertions.assertEquals((Object)creds9, (Object)creds7);
    }

    @Test
    public void testUsernamePasswordCredentialsSerialization() throws Exception {
        UsernamePasswordCredentials orig = new UsernamePasswordCredentials("name", "pwd".toCharArray());
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        UsernamePasswordCredentials clone = (UsernamePasswordCredentials)inStream.readObject();
        Assertions.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    public void testNTCredentialsSerialization() throws Exception {
        NTCredentials orig = new NTCredentials("name", "pwd".toCharArray(), "somehost", "domain");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        NTCredentials clone = (NTCredentials)inStream.readObject();
        Assertions.assertEquals((Object)orig, (Object)clone);
    }
}

