/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.client5.http.ContentTypeMatcher;
import org.apache.hc.client5.http.HeaderMatcher;
import org.apache.hc.client5.http.HeadersMatcher;
import org.apache.hc.client5.http.NameValuePairsMatcher;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleResponseBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIAuthority;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimpleMessageBuilders {
    @Test
    public void testResponseBasics() throws Exception {
        SimpleResponseBuilder builder = SimpleResponseBuilder.create((int)200);
        Assertions.assertEquals((int)200, (int)builder.getStatus());
        Assertions.assertNull((Object)builder.getHeaders());
        Assertions.assertNull((Object)builder.getVersion());
        SimpleHttpResponse r1 = builder.build();
        Assertions.assertNotNull((Object)r1);
        Assertions.assertEquals((int)200, (int)r1.getCode());
        Assertions.assertNull((Object)r1.getVersion());
        builder.setStatus(500);
        builder.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        Assertions.assertEquals((int)500, (int)builder.getStatus());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)builder.getVersion());
        SimpleHttpResponse r2 = builder.build();
        Assertions.assertEquals((int)500, (int)r2.getCode());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)r2.getVersion());
        builder.addHeader("h1", "v1");
        builder.addHeader("h1", "v2");
        builder.addHeader("h2", "v2");
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)builder.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        SimpleHttpResponse r3 = builder.build();
        MatcherAssert.assertThat((Object)r3.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r3.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r3.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)r3.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        builder.removeHeader((Header)new BasicHeader("h1", (Object)"v2"));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        SimpleHttpResponse r4 = builder.build();
        MatcherAssert.assertThat((Object)r4.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)r4.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        builder.removeHeaders("h1");
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
        SimpleHttpResponse r5 = builder.build();
        MatcherAssert.assertThat((Object)r5.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)r5.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    public void testRequestBasics() throws Exception {
        SimpleRequestBuilder builder = SimpleRequestBuilder.get();
        Assertions.assertEquals((Object)URI.create("/"), (Object)builder.getUri());
        Assertions.assertEquals((Object)"GET", (Object)builder.getMethod());
        Assertions.assertNull((Object)builder.getScheme());
        Assertions.assertNull((Object)builder.getAuthority());
        Assertions.assertNull((Object)builder.getPath());
        Assertions.assertNull((Object)builder.getHeaders());
        Assertions.assertNull((Object)builder.getVersion());
        Assertions.assertNull((Object)builder.getCharset());
        Assertions.assertNull((Object)builder.getParameters());
        SimpleHttpRequest r1 = builder.build();
        Assertions.assertNotNull((Object)r1);
        Assertions.assertEquals((Object)"GET", (Object)r1.getMethod());
        Assertions.assertNull((Object)r1.getScheme());
        Assertions.assertNull((Object)r1.getAuthority());
        Assertions.assertNull((Object)r1.getPath());
        Assertions.assertEquals((Object)URI.create("/"), (Object)r1.getUri());
        Assertions.assertNull((Object)r1.getVersion());
        builder.setUri(URI.create("http://host:1234/blah?param=value"));
        builder.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        Assertions.assertEquals((Object)"http", (Object)builder.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 1234), (Object)builder.getAuthority());
        Assertions.assertEquals((Object)"/blah?param=value", (Object)builder.getPath());
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value"), (Object)builder.getUri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)builder.getVersion());
        SimpleHttpRequest r2 = builder.build();
        Assertions.assertEquals((Object)"GET", (Object)r2.getMethod());
        Assertions.assertEquals((Object)"http", (Object)r2.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 1234), (Object)r2.getAuthority());
        Assertions.assertEquals((Object)"/blah?param=value", (Object)r2.getPath());
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value"), (Object)r2.getUri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)builder.getVersion());
        builder.setCharset(StandardCharsets.US_ASCII);
        builder.addParameter("param1", "value1");
        builder.addParameter("param2", null);
        builder.addParameters(new NameValuePair[]{new BasicNameValuePair("param3", "value3"), new BasicNameValuePair("param4", null)});
        Assertions.assertEquals((Object)builder.getParameters(), Arrays.asList(new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", null), new BasicNameValuePair("param3", "value3"), new BasicNameValuePair("param4", null)));
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value"), (Object)builder.getUri());
        SimpleHttpRequest r3 = builder.build();
        Assertions.assertEquals((Object)"GET", (Object)r3.getMethod());
        Assertions.assertEquals((Object)"http", (Object)r3.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 1234), (Object)r3.getAuthority());
        Assertions.assertEquals((Object)"/blah?param=value&param1=value1&param2&param3=value3&param4", (Object)r3.getPath());
        Assertions.assertEquals((Object)URI.create("http://host:1234/blah?param=value&param1=value1&param2&param3=value3&param4"), (Object)r3.getUri());
        builder.addHeader("h1", "v1");
        builder.addHeader("h1", "v2");
        builder.addHeader("h2", "v2");
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)builder.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)builder.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        SimpleHttpRequest r4 = builder.build();
        MatcherAssert.assertThat((Object)r4.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r4.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2")}));
        MatcherAssert.assertThat((Object)r4.getFirstHeader("h1"), HeaderMatcher.same("h1", "v1"));
        MatcherAssert.assertThat((Object)r4.getLastHeader("h1"), HeaderMatcher.same("h1", "v2"));
        builder.removeHeader((Header)new BasicHeader("h1", (Object)"v2"));
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        SimpleHttpRequest r5 = builder.build();
        MatcherAssert.assertThat((Object)r5.getHeaders("h1"), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1")}));
        MatcherAssert.assertThat((Object)r5.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h2", (Object)"v2")}));
        builder.removeHeaders("h1");
        MatcherAssert.assertThat((Object)builder.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
        SimpleHttpRequest r6 = builder.build();
        MatcherAssert.assertThat((Object)r6.getHeaders("h1"), HeadersMatcher.same(new Header[0]));
        MatcherAssert.assertThat((Object)r6.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    public void testResponseCopy() throws Exception {
        SimpleHttpResponse response = SimpleHttpResponse.create((int)400);
        response.addHeader("h1", (Object)"v1");
        response.addHeader("h1", (Object)"v2");
        response.addHeader("h2", (Object)"v2");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_2);
        SimpleResponseBuilder builder = SimpleResponseBuilder.copy((SimpleHttpResponse)response);
        Assertions.assertEquals((int)400, (int)builder.getStatus());
        Assertions.assertEquals((Object)HttpVersion.HTTP_2, (Object)builder.getVersion());
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    public void testRequestCopy() throws Exception {
        SimpleHttpRequest request = SimpleHttpRequest.create((Method)Method.GET, (URI)URI.create("https://host:3456/stuff?blah"));
        request.addHeader("h1", (Object)"v1");
        request.addHeader("h1", (Object)"v2");
        request.addHeader("h2", (Object)"v2");
        request.setVersion((ProtocolVersion)HttpVersion.HTTP_2);
        SimpleRequestBuilder builder = SimpleRequestBuilder.copy((SimpleHttpRequest)request);
        Assertions.assertEquals((Object)"GET", (Object)builder.getMethod());
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 3456), (Object)builder.getAuthority());
        Assertions.assertEquals((Object)"/stuff?blah", (Object)builder.getPath());
        Assertions.assertEquals((Object)HttpVersion.HTTP_2, (Object)builder.getVersion());
        MatcherAssert.assertThat((Object)builder.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("h1", (Object)"v1"), new BasicHeader("h1", (Object)"v2"), new BasicHeader("h2", (Object)"v2")}));
    }

    @Test
    public void testGetParameters() throws Exception {
        SimpleRequestBuilder builder = SimpleRequestBuilder.get((URI)URI.create("https://host:3456/stuff?p0=p0"));
        builder.addParameter("p1", "v1");
        builder.addParameters(new NameValuePair[]{new BasicNameValuePair("p2", "v2"), new BasicNameValuePair("p3", "v3")});
        builder.addParameter((NameValuePair)new BasicNameValuePair("p3", "v3.1"));
        Assertions.assertEquals((Object)"GET", (Object)builder.getMethod());
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 3456), (Object)builder.getAuthority());
        Assertions.assertEquals((Object)"/stuff?p0=p0", (Object)builder.getPath());
        MatcherAssert.assertThat((Object)builder.getParameters(), NameValuePairsMatcher.same(new NameValuePair[]{new BasicNameValuePair("p1", "v1"), new BasicNameValuePair("p2", "v2"), new BasicNameValuePair("p3", "v3"), new BasicNameValuePair("p3", "v3.1")}));
        SimpleHttpRequest request = builder.build();
        MatcherAssert.assertThat((Object)request.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/stuff?p0=p0&p1=v1&p2=v2&p3=v3&p3=v3.1"));
        Assertions.assertNull((Object)request.getBody());
    }

    @Test
    public void testPostParameters() throws Exception {
        SimpleRequestBuilder builder = SimpleRequestBuilder.post((URI)URI.create("https://host:3456/stuff?p0=p0"));
        builder.addParameter("p1", "v1");
        builder.addParameters(new NameValuePair[]{new BasicNameValuePair("p2", "v2"), new BasicNameValuePair("p3", "v3")});
        builder.addParameter((NameValuePair)new BasicNameValuePair("p3", "v3.1"));
        Assertions.assertEquals((Object)"POST", (Object)builder.getMethod());
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)new URIAuthority("host", 3456), (Object)builder.getAuthority());
        Assertions.assertEquals((Object)"/stuff?p0=p0", (Object)builder.getPath());
        MatcherAssert.assertThat((Object)builder.getParameters(), NameValuePairsMatcher.same(new NameValuePair[]{new BasicNameValuePair("p1", "v1"), new BasicNameValuePair("p2", "v2"), new BasicNameValuePair("p3", "v3"), new BasicNameValuePair("p3", "v3.1")}));
        SimpleHttpRequest request = builder.build();
        MatcherAssert.assertThat((Object)request.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/stuff?p0=p0"));
        Assertions.assertNotNull((Object)request.getBody());
        MatcherAssert.assertThat((Object)request.getBody().getContentType(), ContentTypeMatcher.sameMimeType(ContentType.APPLICATION_FORM_URLENCODED));
        MatcherAssert.assertThat((Object)request.getBody().getBodyText(), (Matcher)CoreMatchers.equalTo((Object)"p1=v1&p2=v2&p3=v3&p3=v3.1"));
    }
}

