/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.htrace.Span;
import org.apache.htrace.TimelineAnnotation;
import org.apache.htrace.impl.MilliSpan;
import org.junit.Assert;
import org.junit.Test;

public class TestMilliSpan {
    private void compareSpans(Span expected, Span got) throws Exception {
        Assert.assertEquals((long)expected.getStartTimeMillis(), (long)got.getStartTimeMillis());
        Assert.assertEquals((long)expected.getStopTimeMillis(), (long)got.getStopTimeMillis());
        Assert.assertEquals((Object)expected.getDescription(), (Object)got.getDescription());
        Assert.assertEquals((long)expected.getTraceId(), (long)got.getTraceId());
        Assert.assertEquals((long)expected.getSpanId(), (long)got.getSpanId());
        Assert.assertEquals((Object)expected.getProcessId(), (Object)got.getProcessId());
        Assert.assertEquals((long)expected.getParentId(), (long)got.getParentId());
        Map expectedT = expected.getKVAnnotations();
        Map gotT = got.getKVAnnotations();
        if (expectedT == null) {
            Assert.assertEquals(null, (Object)gotT);
        } else {
            Assert.assertEquals((long)expectedT.size(), (long)gotT.size());
            HashMap<String, String> expectedTMap = new HashMap<String, String>();
            for (byte[] key : expectedT.keySet()) {
                expectedTMap.put(new String(key, "UTF-8"), new String((byte[])expectedT.get(key), "UTF-8"));
            }
            HashMap<String, String> gotTMap = new HashMap<String, String>();
            for (Object key : gotT.keySet()) {
                gotTMap.put(new String((byte[])key, "UTF-8"), new String((byte[])gotT.get(key), "UTF-8"));
            }
            Iterator i$ = expectedTMap.keySet().iterator();
            while (i$.hasNext()) {
                Object key;
                key = (String)i$.next();
                Assert.assertEquals(expectedTMap.get(key), gotTMap.get(key));
            }
        }
        List expectedTimeline = expected.getTimelineAnnotations();
        List gotTimeline = got.getTimelineAnnotations();
        if (expectedTimeline == null) {
            Assert.assertEquals(null, (Object)gotTimeline);
        } else {
            Assert.assertEquals((long)expectedTimeline.size(), (long)gotTimeline.size());
            Iterator iter = gotTimeline.iterator();
            for (TimelineAnnotation expectedAnn : expectedTimeline) {
                TimelineAnnotation gotAnn = (TimelineAnnotation)iter.next();
                Assert.assertEquals((Object)expectedAnn.getMessage(), (Object)gotAnn.getMessage());
                Assert.assertEquals((long)expectedAnn.getTime(), (long)gotAnn.getTime());
            }
        }
    }

    @Test
    public void testJsonSerialization() throws Exception {
        MilliSpan span = new MilliSpan.Builder().description("foospan").begin(123L).end(456L).parents(new long[]{7L}).processId("b2404.halxg.com:8080").spanId(989L).traceId(444L).build();
        String json = span.toJson();
        ObjectMapper mapper = new ObjectMapper();
        MilliSpan dspan = (MilliSpan)mapper.readValue(json, MilliSpan.class);
        this.compareSpans((Span)span, (Span)dspan);
    }

    @Test
    public void testJsonSerializationWithNegativeLongValue() throws Exception {
        MilliSpan span = new MilliSpan.Builder().description("foospan").begin(-1L).end(-1L).parents(new long[]{-1L}).processId("b2404.halxg.com:8080").spanId(-1L).traceId(-1L).build();
        String json = span.toJson();
        ObjectMapper mapper = new ObjectMapper();
        MilliSpan dspan = (MilliSpan)mapper.readValue(json, MilliSpan.class);
        this.compareSpans((Span)span, (Span)dspan);
    }

    @Test
    public void testJsonSerializationWithRandomLongValue() throws Exception {
        SecureRandom random = new SecureRandom();
        MilliSpan span = new MilliSpan.Builder().description("foospan").begin(random.nextLong()).end(random.nextLong()).parents(new long[]{random.nextLong()}).processId("b2404.halxg.com:8080").spanId(random.nextLong()).traceId(random.nextLong()).build();
        String json = span.toJson();
        ObjectMapper mapper = new ObjectMapper();
        MilliSpan dspan = (MilliSpan)mapper.readValue(json, MilliSpan.class);
        this.compareSpans((Span)span, (Span)dspan);
    }

    @Test
    public void testJsonSerializationWithOptionalFields() throws Exception {
        MilliSpan.Builder builder = new MilliSpan.Builder().description("foospan").begin(300L).end(400L).parents(new long[0]).processId("b2408.halxg.com:8080").spanId(111111111L).traceId(4443L);
        HashMap<byte[], byte[]> traceInfo = new HashMap<byte[], byte[]>();
        traceInfo.put("abc".getBytes("UTF-8"), "123".getBytes("UTF-8"));
        traceInfo.put("def".getBytes("UTF-8"), "456".getBytes("UTF-8"));
        builder.traceInfo(traceInfo);
        LinkedList<TimelineAnnotation> timeline = new LinkedList<TimelineAnnotation>();
        timeline.add(new TimelineAnnotation(310L, "something happened"));
        timeline.add(new TimelineAnnotation(380L, "something else happened"));
        timeline.add(new TimelineAnnotation(390L, "more things"));
        builder.timeline(timeline);
        MilliSpan span = builder.build();
        String json = span.toJson();
        ObjectMapper mapper = new ObjectMapper();
        MilliSpan dspan = (MilliSpan)mapper.readValue(json, MilliSpan.class);
        this.compareSpans((Span)span, (Span)dspan);
    }
}

