/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.util.Collection;
import java.util.Random;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;

public class TraceCreator {
    public static final String RPC_TRACE_ROOT = "createSampleRpcTrace";
    public static final String THREADED_TRACE_ROOT = "createThreadedTrace";
    public static final String SIMPLE_TRACE_ROOT = "createSimpleTrace";

    public TraceCreator(SpanReceiver receiver) {
        Trace.addReceiver((SpanReceiver)receiver);
    }

    public TraceCreator(Collection<SpanReceiver> receivers) {
        for (SpanReceiver receiver : receivers) {
            Trace.addReceiver((SpanReceiver)receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSampleRpcTrace() {
        TraceScope s = Trace.startSpan((String)RPC_TRACE_ROOT, (Sampler)Sampler.ALWAYS);
        try {
            this.pretendRpcSend();
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSimpleTrace() {
        TraceScope s = Trace.startSpan((String)SIMPLE_TRACE_ROOT, (Sampler)Sampler.ALWAYS);
        try {
            this.importantWork1();
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createThreadedTrace() {
        TraceScope s = Trace.startSpan((String)THREADED_TRACE_ROOT, (Sampler)Sampler.ALWAYS);
        try {
            int i;
            Random r = new Random();
            int numThreads = r.nextInt(4) + 1;
            Thread[] threads = new Thread[numThreads];
            for (i = 0; i < numThreads; ++i) {
                threads[i] = new Thread(Trace.wrap((Runnable)new MyRunnable()));
            }
            for (i = 0; i < numThreads; ++i) {
                threads[i].start();
            }
            for (i = 0; i < numThreads; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.importantWork1();
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importantWork1() {
        TraceScope cur = Trace.startSpan((String)"important work 1");
        try {
            Thread.sleep((long)(2000.0 * Math.random()));
            this.importantWork2();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            cur.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importantWork2() {
        TraceScope cur = Trace.startSpan((String)"important work 2");
        try {
            Thread.sleep((long)(2000.0 * Math.random()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            cur.close();
        }
    }

    public void pretendRpcSend() {
        this.pretendRpcReceiveWithTraceInfo(TraceInfo.fromSpan((Span)Trace.currentSpan()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pretendRpcReceiveWithTraceInfo(TraceInfo traceInfo) {
        TraceScope s = Trace.startSpan((String)"received RPC", (TraceInfo)traceInfo);
        try {
            this.importantWork1();
        }
        finally {
            s.close();
        }
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(750L);
                Random r = new Random();
                int importantNumber = 100 / r.nextInt(3);
                System.out.println("Important number: " + importantNumber);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (ArithmeticException ae) {
                TraceScope c = Trace.startSpan((String)"dealing with arithmetic exception.");
                try {
                    Thread.sleep((long)(3000.0 * Math.random()));
                }
                catch (InterruptedException ie1) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    c.close();
                }
            }
        }
    }
}

