/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.SpanReceiverBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestSpanReceiverBuilder {
    @Test
    public void testGetNullSpanReceiver() {
        SpanReceiverBuilder builder = new SpanReceiverBuilder(HTraceConfiguration.EMPTY).logErrors(false);
        SpanReceiver rcvr = builder.build();
        Assert.assertEquals(null, (Object)rcvr);
    }

    private static SpanReceiver createSpanReceiver(Map<String, String> m) {
        HTraceConfiguration hconf = HTraceConfiguration.fromMap(m);
        SpanReceiverBuilder builder = new SpanReceiverBuilder(hconf).logErrors(false);
        return builder.build();
    }

    @Test
    public void testGetSpanReceivers() throws Exception {
        HashMap<String, String> confMap = new HashMap<String, String>();
        confMap.put("local-file-span-receiver.path", "/tmp/foo");
        confMap.put("span.receiver", "org.apache.htrace.impl.LocalFileSpanReceiver");
        SpanReceiver rcvr = TestSpanReceiverBuilder.createSpanReceiver(confMap);
        Assert.assertEquals((Object)"org.apache.htrace.impl.LocalFileSpanReceiver", (Object)rcvr.getClass().getName());
        rcvr.close();
        confMap.remove("local-file-span-receiver.path");
        confMap.put("span.receiver", "POJOSpanReceiver");
        rcvr = TestSpanReceiverBuilder.createSpanReceiver(confMap);
        Assert.assertEquals((Object)"org.apache.htrace.impl.POJOSpanReceiver", (Object)rcvr.getClass().getName());
        rcvr.close();
        confMap.remove("local-file-span-receiver.path");
        confMap.put("span.receiver", "org.apache.htrace.impl.StandardOutSpanReceiver");
        rcvr = TestSpanReceiverBuilder.createSpanReceiver(confMap);
        Assert.assertEquals((Object)"org.apache.htrace.impl.StandardOutSpanReceiver", (Object)rcvr.getClass().getName());
        rcvr.close();
    }

    @Test
    public void testGetSpanReceiverWithConstructorError() throws Exception {
        HashMap<String, String> confMap = new HashMap<String, String>();
        confMap.put("span.receiver", TestSpanReceiver.class.getName());
        confMap.put("test.span.receiver.succeeds", "true");
        SpanReceiver rcvr = TestSpanReceiverBuilder.createSpanReceiver(confMap);
        Assert.assertEquals((Object)TestSpanReceiver.class.getName(), (Object)rcvr.getClass().getName());
        rcvr.close();
        confMap.remove("test.span.receiver.succeeds");
        rcvr = TestSpanReceiverBuilder.createSpanReceiver(confMap);
        Assert.assertEquals(null, (Object)rcvr);
    }

    public static class TestSpanReceiver
    implements SpanReceiver {
        static final String SUCCEEDS = "test.span.receiver.succeeds";

        public TestSpanReceiver(HTraceConfiguration conf) {
            if (conf.get(SUCCEEDS) == null) {
                throw new RuntimeException("Can't create TestSpanReceiver: invalid configuration.");
            }
        }

        public void receiveSpan(Span span) {
        }

        public void close() throws IOException {
        }
    }
}

