/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Sampler;
import org.apache.htrace.SamplerBuilder;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.AlwaysSampler;
import org.apache.htrace.impl.NeverSampler;
import org.junit.Assert;
import org.junit.Test;

public class TestSampler {
    @Test
    public void testSamplerBuilder() {
        Sampler alwaysSampler = new SamplerBuilder(HTraceConfiguration.fromKeyValuePairs((String[])new String[]{"sampler", "AlwaysSampler"})).build();
        Assert.assertEquals(AlwaysSampler.class, alwaysSampler.getClass());
        Sampler neverSampler = new SamplerBuilder(HTraceConfiguration.fromKeyValuePairs((String[])new String[]{"sampler", "NeverSampler"})).build();
        Assert.assertEquals(NeverSampler.class, neverSampler.getClass());
        Sampler neverSampler2 = new SamplerBuilder(HTraceConfiguration.fromKeyValuePairs((String[])new String[]{"sampler", "NonExistentSampler"})).build();
        Assert.assertEquals(NeverSampler.class, neverSampler2.getClass());
    }

    @Test
    public void testParamterizedSampler() {
        TestParamSampler sampler = new TestParamSampler();
        TraceScope s = Trace.startSpan((String)"test", (Sampler)sampler, (Object)1);
        Assert.assertNotNull((Object)s.getSpan());
        s.close();
        s = Trace.startSpan((String)"test", (Sampler)sampler, (Object)-1);
        Assert.assertNull((Object)s.getSpan());
        s.close();
    }

    @Test
    public void testAlwaysSampler() {
        TraceScope cur = Trace.startSpan((String)"test", (TraceInfo)new TraceInfo(0L, 0L));
        Assert.assertNotNull((Object)cur);
        cur.close();
    }

    private class TestParamSampler
    implements Sampler<Integer> {
        private TestParamSampler() {
        }

        public boolean next(Integer info) {
            return info > 0;
        }
    }
}

