/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.util.HashMap;
import org.apache.htrace.HTraceConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestHTraceConfiguration {
    @Test
    public void testGetBoolean() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("testTrue", " True");
        m.put("testFalse", "falsE ");
        HTraceConfiguration configuration = HTraceConfiguration.fromMap(m);
        Assert.assertTrue((boolean)configuration.getBoolean("testTrue", false));
        Assert.assertFalse((boolean)configuration.getBoolean("testFalse", true));
        Assert.assertTrue((boolean)configuration.getBoolean("absent", true));
        Assert.assertFalse((boolean)configuration.getBoolean("absent", false));
    }

    @Test
    public void testGetInt() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "100");
        m.put("b", "0");
        m.put("c", "-100");
        m.put("d", "5");
        HTraceConfiguration configuration = HTraceConfiguration.fromMap(m);
        Assert.assertEquals((long)100L, (long)configuration.getInt("a", -999));
        Assert.assertEquals((long)0L, (long)configuration.getInt("b", -999));
        Assert.assertEquals((long)-100L, (long)configuration.getInt("c", -999));
        Assert.assertEquals((long)5L, (long)configuration.getInt("d", -999));
        Assert.assertEquals((long)-999L, (long)configuration.getInt("absent", -999));
    }
}

