/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.TraceCreator;
import org.apache.htrace.TraceTree;
import org.apache.htrace.impl.LocalFileSpanReceiver;
import org.apache.htrace.impl.POJOSpanReceiver;
import org.apache.htrace.impl.StandardOutSpanReceiver;
import org.junit.Assert;
import org.junit.Test;

public class TestHTrace {
    public static final String SPAN_FILE_FLAG = "spanFile";

    @Test
    public void testHtrace() throws Exception {
        int numTraces = 3;
        String fileName = System.getProperty(SPAN_FILE_FLAG);
        HashSet<SpanReceiver> rcvrs = new HashSet<SpanReceiver>();
        if (fileName != null) {
            File f = new File(fileName);
            File parent = f.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IllegalArgumentException("Couldn't create file: " + fileName);
            }
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("local-file-span-receiver.path", fileName);
            LocalFileSpanReceiver receiver = new LocalFileSpanReceiver(HTraceConfiguration.fromMap(conf));
            rcvrs.add((SpanReceiver)receiver);
        } else {
            rcvrs.add((SpanReceiver)new StandardOutSpanReceiver(HTraceConfiguration.EMPTY));
        }
        POJOSpanReceiver psr = new POJOSpanReceiver(HTraceConfiguration.EMPTY);
        rcvrs.add((SpanReceiver)psr);
        this.runTraceCreatorTraces(new TraceCreator(rcvrs));
        for (SpanReceiver receiver : rcvrs) {
            receiver.close();
        }
        Collection spans = psr.getSpans();
        TraceTree traceTree = new TraceTree(spans);
        List roots = traceTree.getSpansByParent().find(477902L);
        Assert.assertTrue((String)"Trace tree must have roots", (!roots.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)roots.size());
        HashMap<String, Span> descriptionToRootSpan = new HashMap<String, Span>();
        for (Span root : roots) {
            descriptionToRootSpan.put(root.getDescription(), root);
        }
        Assert.assertTrue((boolean)descriptionToRootSpan.keySet().contains("createSampleRpcTrace"));
        Assert.assertTrue((boolean)descriptionToRootSpan.keySet().contains("createSimpleTrace"));
        Assert.assertTrue((boolean)descriptionToRootSpan.keySet().contains("createThreadedTrace"));
        TraceTree.SpansByParent spansByParentId = traceTree.getSpansByParent();
        Span rpcTraceRoot = (Span)descriptionToRootSpan.get("createSampleRpcTrace");
        Assert.assertEquals((long)1L, (long)spansByParentId.find(rpcTraceRoot.getSpanId()).size());
        Span rpcTraceChild1 = (Span)spansByParentId.find(rpcTraceRoot.getSpanId()).iterator().next();
        Assert.assertEquals((long)1L, (long)spansByParentId.find(rpcTraceChild1.getSpanId()).size());
        Span rpcTraceChild2 = (Span)spansByParentId.find(rpcTraceChild1.getSpanId()).iterator().next();
        Assert.assertEquals((long)1L, (long)spansByParentId.find(rpcTraceChild2.getSpanId()).size());
        Span rpcTraceChild3 = (Span)spansByParentId.find(rpcTraceChild2.getSpanId()).iterator().next();
        Assert.assertEquals((long)0L, (long)spansByParentId.find(rpcTraceChild3.getSpanId()).size());
    }

    private void runTraceCreatorTraces(TraceCreator tc) {
        tc.createThreadedTrace();
        tc.createSimpleTrace();
        tc.createSampleRpcTrace();
    }
}

