/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.spitter;

import java.io.IOException;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.storage.jdbc.spitter.DateIntervalSplitter;
import org.apache.hive.storage.jdbc.spitter.DecimalIntervalSplitter;
import org.apache.hive.storage.jdbc.spitter.DoubleIntervalSplitter;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitter;
import org.apache.hive.storage.jdbc.spitter.LongIntervalSpitter;
import org.apache.hive.storage.jdbc.spitter.TimestampIntervalSplitter;

public class IntervalSplitterFactory {
    public static IntervalSplitter newIntervalSpitter(TypeInfo typeInfo) throws IOException {
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongIntervalSpitter();
            }
            case FLOAT: 
            case DOUBLE: {
                return new DoubleIntervalSplitter();
            }
            case DECIMAL: {
                return new DecimalIntervalSplitter();
            }
            case TIMESTAMP: {
                return new TimestampIntervalSplitter();
            }
            case DATE: {
                return new DateIntervalSplitter();
            }
        }
        throw new IOException("partitionColumn is " + primitiveTypeInfo.getPrimitiveCategory() + ", only numeric/date/timestamp type can be a partition column");
    }
}

