/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyHBaseCellMap {
    public static final byte[] TEST_ROW = Bytes.toBytes((String)"test-row");
    public static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"a");
    public static final String QUAL_PREFIX = "col_";

    @Test
    public void testInitColumnPrefix() throws Exception {
        Text nullSequence = new Text("\\N");
        ObjectInspector oi = LazyFactory.createLazyObjectInspector((TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"map<string,string>").get(0)), (byte[])new byte[]{1, 2}, (int)0, (Text)nullSequence, (boolean)false, (byte)0);
        LazyHBaseCellMap b = new LazyHBaseCellMap((LazyMapObjectInspector)oi);
        KeyValue[] cells = new KeyValue[2];
        String col1 = "1";
        String col2 = "2";
        cells[0] = new KeyValue(TEST_ROW, COLUMN_FAMILY, Bytes.toBytes((String)"col_1"), Bytes.toBytes((String)"cfacol1"));
        cells[1] = new KeyValue(TEST_ROW, COLUMN_FAMILY, Bytes.toBytes((String)"col_2"), Bytes.toBytes((String)"cfacol2"));
        Result r = Result.create((Cell[])cells);
        ArrayList<Boolean> mapBinaryStorage = new ArrayList<Boolean>();
        mapBinaryStorage.add(false);
        mapBinaryStorage.add(false);
        b.init(r, COLUMN_FAMILY, mapBinaryStorage, Bytes.toBytes((String)QUAL_PREFIX), true);
        Assert.assertNotNull((Object)b.getMapValueElement((Object)new Text("1")));
        Assert.assertNotNull((Object)b.getMapValueElement((Object)new Text("2")));
    }
}

