/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.struct.HBaseStructValue;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;

public class HBaseTestStructSerializer
extends HBaseStructValue {
    protected byte[] bytes;
    protected String bytesAsString;
    protected Properties tbl;
    protected Configuration conf;
    protected ColumnMappings.ColumnMapping colMapping;
    protected String testValue;

    public HBaseTestStructSerializer(LazySimpleStructObjectInspector oi, Properties tbl, Configuration conf, ColumnMappings.ColumnMapping colMapping) {
        super(oi);
        this.tbl = tbl;
        this.conf = conf;
        this.colMapping = colMapping;
    }

    public void init(ByteArrayRef bytes, int start, int length) {
        this.bytes = bytes.getData();
    }

    public Object getField(int fieldID) {
        if (this.bytesAsString == null) {
            this.bytesAsString = Bytes.toString((byte[])this.bytes).trim();
        }
        byte[] fieldBytes = new byte[]{(byte)this.bytesAsString.charAt(fieldID)};
        return this.toLazyObject(fieldID, fieldBytes);
    }

    public LazyObject<? extends ObjectInspector> toLazyObject(int fieldID, byte[] bytes) {
        ObjectInspector fieldOI = ((StructField)((LazySimpleStructObjectInspector)this.oi).getAllStructFieldRefs().get(fieldID)).getFieldObjectInspector();
        LazyObject lazyObject = LazyFactory.createLazyObject((ObjectInspector)fieldOI);
        ByteArrayRef ref = new ByteArrayRef();
        ref.setData(bytes);
        lazyObject.init(ref, 0, ref.getData().length);
        return lazyObject;
    }
}

