/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.util.Arrays;
import org.apache.hive.common.util.HiveStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveStringUtils {
    @Test
    public void testSplitAndUnEscape() throws Exception {
        this.splitAndUnEscapeTestCase(null, null);
        this.splitAndUnEscapeTestCase("'single element'", new String[]{"'single element'"});
        this.splitAndUnEscapeTestCase("yyyy-MM-dd'T'HH:mm:ss,yyyy-MM-dd'T'HH:mm:ss.S", new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S"});
        this.splitAndUnEscapeTestCase("single\\,element", new String[]{"single,element"});
        this.splitAndUnEscapeTestCase("element\\,one\\\\,element\\\\two\\\\\\,", new String[]{"element,one\\", "element\\two\\,"});
    }

    public void splitAndUnEscapeTestCase(String testValue, String[] expectedResults) throws Exception {
        Object[] testResults = HiveStringUtils.splitAndUnEscape((String)testValue);
        Assert.assertTrue((String)(Arrays.toString(expectedResults) + " == " + Arrays.toString(testResults)), (boolean)Arrays.equals(expectedResults, testResults));
    }

    @Test
    public void testStripComments() throws Exception {
        Assert.assertNull((Object)HiveStringUtils.removeComments(null));
        this.assertUnchanged("foo");
        this.assertUnchanged("select 1");
        this.assertUnchanged("insert into foo (values('-----')");
        this.assertUnchanged("insert into foo (values('abc\n'xyz')");
        this.assertUnchanged("create database if not exists testDB; set hive.cli.print.current.db=true;use\ntestDB;\nuse default;drop if exists testDB;");
        Assert.assertEquals((Object)"foo", (Object)HiveStringUtils.removeComments((String)"foo\n"));
        Assert.assertEquals((Object)"foo", (Object)HiveStringUtils.removeComments((String)"\nfoo"));
        Assert.assertEquals((Object)"foo", (Object)HiveStringUtils.removeComments((String)"\n\nfoo\n\n"));
        Assert.assertEquals((Object)"insert into foo (values('-----')", (Object)HiveStringUtils.removeComments((String)"--comment\ninsert into foo (values('-----')"));
        Assert.assertEquals((Object)"insert into foo (values('----''-')", (Object)HiveStringUtils.removeComments((String)"--comment\ninsert into foo (values('----''-')"));
        Assert.assertEquals((Object)"insert into foo (values(\"----''-\")", (Object)HiveStringUtils.removeComments((String)"--comment\ninsert into foo (values(\"----''-\")"));
        Assert.assertEquals((Object)"insert into foo (values(\"----\"\"-\")", (Object)HiveStringUtils.removeComments((String)"--comment\ninsert into foo (values(\"----\"\"-\")"));
        Assert.assertEquals((Object)"insert into foo (values('-\n--\n--')", (Object)HiveStringUtils.removeComments((String)"--comment\ninsert into foo (values('-\n--\n--')"));
        Assert.assertEquals((Object)"insert into foo (values('-\n--\n--')", (Object)HiveStringUtils.removeComments((String)"--comment\n\ninsert into foo (values('-\n--\n--')"));
        Assert.assertEquals((Object)"insert into foo (values(\"-\n--\n--\")", (Object)HiveStringUtils.removeComments((String)"--comment\n\ninsert into foo (values(\"-\n--\n--\")"));
        Assert.assertEquals((Object)"insert into foo (values(\"-\n--\n--\")", (Object)HiveStringUtils.removeComments((String)"\n\n--comment\n\ninsert into foo (values(\"-\n--\n--\")\n\n"));
        Assert.assertEquals((Object)"insert into foo (values('abc');\ninsert into foo (values('def');", (Object)HiveStringUtils.removeComments((String)"insert into foo (values('abc');\n--comment\ninsert into foo (values('def');"));
    }

    @Test
    public void testLinesEndingWithComments() {
        int[] escape = new int[]{-1};
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables;", (int[])escape));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; --comments", (int[])escape));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"show tables;", (Object)HiveStringUtils.removeComments((String)"show tables; -------comments;one;two;three;;;;", (int[])escape));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"show-- tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"show", (Object)HiveStringUtils.removeComments((String)"show --tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"s", (Object)HiveStringUtils.removeComments((String)"s--how --tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"", (Object)HiveStringUtils.removeComments((String)"-- show tables; -------comments", (int[])escape));
        Assert.assertEquals((Object)"\"show tables\"", (Object)HiveStringUtils.removeComments((String)"\"show tables\" --comments", (int[])escape));
        Assert.assertEquals((Object)"\"show --comments tables\"", (Object)HiveStringUtils.removeComments((String)"\"show --comments tables\" --comments", (int[])escape));
        Assert.assertEquals((Object)"\"'show --comments' tables\"", (Object)HiveStringUtils.removeComments((String)"\"'show --comments' tables\" --comments", (int[])escape));
        Assert.assertEquals((Object)"'show --comments tables'", (Object)HiveStringUtils.removeComments((String)"'show --comments tables' --comments", (int[])escape));
        Assert.assertEquals((Object)"'\"show --comments tables\"'", (Object)HiveStringUtils.removeComments((String)"'\"show --comments tables\"' --comments", (int[])escape));
    }

    private void assertUnchanged(String statement) {
        Assert.assertEquals((String)"statement should not have been affected by stripping commnents", (Object)statement, (Object)HiveStringUtils.removeComments((String)statement));
    }
}

