/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hive.common.util.DateParser;
import org.junit.Assert;
import org.junit.Test;

public class TestDateParser {
    DateParser parser = new DateParser();
    Date date = new Date();

    void checkValidCase(String strValue, Date expected) {
        Date dateValue = this.parser.parseDate(strValue);
        Assert.assertEquals((Object)expected, (Object)dateValue);
        Assert.assertTrue((boolean)this.parser.parseDate(strValue, this.date));
        Assert.assertEquals((Object)expected, (Object)this.date);
    }

    void checkInvalidCase(String strValue) {
        Date dateValue = this.parser.parseDate(strValue);
        Assert.assertNull((Object)dateValue);
        Assert.assertFalse((boolean)this.parser.parseDate(strValue, this.date));
    }

    @Test
    public void testValidCases() throws Exception {
        this.checkValidCase("1945-12-31", Date.valueOf((String)"1945-12-31"));
        this.checkValidCase("1946-01-01", Date.valueOf((String)"1946-01-01"));
        this.checkValidCase("2001-11-12", Date.valueOf((String)"2001-11-12"));
        this.checkValidCase("0004-05-06", Date.valueOf((String)"0004-05-06"));
        this.checkValidCase("1678-09-10", Date.valueOf((String)"1678-09-10"));
        this.checkValidCase("9999-10-11", Date.valueOf((String)"9999-10-11"));
        this.checkValidCase("2001-11-12 01:02:03", Date.valueOf((String)"2001-11-12"));
        this.checkValidCase(" 1946-01-01", Date.valueOf((String)"1946-01-01"));
        this.checkValidCase(" 2001-11-12 01:02:03", Date.valueOf((String)"2001-11-12"));
        this.checkValidCase("2001-13-12", Date.valueOf((String)"2002-01-12"));
        this.checkValidCase("2001-11-31", Date.valueOf((String)"2001-12-01"));
    }

    @Test
    public void testInvalidCases() throws Exception {
        this.checkInvalidCase("2001");
        this.checkInvalidCase("2001-01");
        this.checkInvalidCase("abc");
        this.checkInvalidCase(" 2001 ");
        this.checkInvalidCase("a2001-01-01");
    }
}

