/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public class MockFileSystem
extends FileSystem {
    final List<MockFile> files = new ArrayList<MockFile>();
    final Map<MockFile, FileStatus> fileStatusMap = new HashMap<MockFile, FileStatus>();
    Path workingDir = new Path("/");
    private static String blockedUgi = null;
    private static final List<MockFile> globalFiles = new ArrayList<MockFile>();
    protected FileSystem.Statistics statistics;
    public boolean allowDelete = false;

    public MockFileSystem() {
    }

    public void initialize(URI uri, Configuration conf) {
        this.setConf(conf);
        this.statistics = MockFileSystem.getStatistics((String)"mock", ((Object)((Object)this)).getClass());
    }

    public MockFileSystem(Configuration conf, MockFile ... files) {
        this.setConf(conf);
        this.files.addAll(Arrays.asList(files));
        this.statistics = MockFileSystem.getStatistics((String)"mock", ((Object)((Object)this)).getClass());
    }

    public static void setBlockedUgi(String s) {
        blockedUgi = s;
    }

    public void clear() {
        this.files.clear();
    }

    public URI getUri() {
        try {
            return new URI("mock:///");
        }
        catch (URISyntaxException err) {
            throw new IllegalArgumentException("huh?", err);
        }
    }

    public void touch(MockFile file) {
        if (this.fileStatusMap.containsKey(file)) {
            FileStatus fileStatus = this.fileStatusMap.get(file);
            FileStatus fileStatusNew = new FileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime() + 1L, fileStatus.getAccessTime(), fileStatus.getPermission(), fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.getPath());
            this.fileStatusMap.put(file, fileStatusNew);
        }
    }

    public FSDataInputStream open(Path path, int i) throws IOException {
        this.statistics.incrementReadOps(1);
        this.checkAccess();
        MockFile file = this.findFile(path);
        if (file != null) {
            return new FSDataInputStream((InputStream)((Object)new MockInputStream(file)));
        }
        throw new IOException("File not found: " + path);
    }

    public MockFile findFile(Path path) {
        for (MockFile file : this.files) {
            if (!file.path.equals((Object)path)) continue;
            return file;
        }
        for (MockFile file : globalFiles) {
            if (!file.path.equals((Object)path)) continue;
            return file;
        }
        return null;
    }

    private void checkAccess() throws IOException {
        if (blockedUgi == null) {
            return;
        }
        if (!blockedUgi.equals(UserGroupInformation.getCurrentUser().getShortUserName())) {
            return;
        }
        throw new MockAccessDenied();
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.checkAccess();
        MockFile file = this.findFile(path);
        if (file == null) {
            file = new MockFile(path.toString(), (int)blockSize, new byte[0], new MockBlock[0]);
            this.files.add(file);
        }
        return new MockOutputStream(file);
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progressable) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.checkAccess();
        return this.create(path, FsPermission.getDefault(), true, bufferSize, (short)3, 262144L, progressable);
    }

    public boolean rename(Path path, Path path2) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.checkAccess();
        return false;
    }

    public boolean delete(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.checkAccess();
        return false;
    }

    public boolean delete(Path path, boolean isRecursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.checkAccess();
        return this.allowDelete && isRecursive && this.deleteMatchingFiles(this.files, path.toString());
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private Iterator<LocatedFileStatus> iterator;
            {
                this.iterator = MockFileSystem.this.listLocatedFileStatuses(f).iterator();
            }

            public boolean hasNext() throws IOException {
                return this.iterator.hasNext();
            }

            public LocatedFileStatus next() throws IOException {
                return this.iterator.next();
            }
        };
    }

    private List<LocatedFileStatus> listLocatedFileStatuses(Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        this.checkAccess();
        path = path.makeQualified((FileSystem)this);
        ArrayList<LocatedFileStatus> result = new ArrayList<LocatedFileStatus>();
        String pathname = path.toString();
        String pathnameAsDir = pathname + "/";
        TreeSet<String> dirs = new TreeSet<String>();
        MockFile file = this.findFile(path);
        if (file != null) {
            result.add(this.createLocatedStatus(file));
            return result;
        }
        this.findMatchingLocatedFiles(this.files, pathnameAsDir, dirs, result);
        this.findMatchingLocatedFiles(globalFiles, pathnameAsDir, dirs, result);
        for (String dir : dirs) {
            result.add(this.createLocatedDirectory(new MockPath(this, pathnameAsDir + dir)));
        }
        return result;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        this.checkAccess();
        path = path.makeQualified((FileSystem)this);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        String pathname = path.toString();
        String pathnameAsDir = pathname + "/";
        TreeSet<String> dirs = new TreeSet<String>();
        MockFile file = this.findFile(path);
        if (file != null) {
            return new FileStatus[]{this.createStatus(file)};
        }
        this.findMatchingFiles(this.files, pathnameAsDir, dirs, result);
        this.findMatchingFiles(globalFiles, pathnameAsDir, dirs, result);
        for (String dir : dirs) {
            result.add(this.createDirectory(new MockPath(this, pathnameAsDir + dir)));
        }
        return result.toArray(new FileStatus[result.size()]);
    }

    private void findMatchingFiles(List<MockFile> files, String pathnameAsDir, Set<String> dirs, List<FileStatus> result) {
        for (MockFile file : files) {
            String filename = file.path.toString();
            if (!filename.startsWith(pathnameAsDir)) continue;
            String tail = filename.substring(pathnameAsDir.length());
            int nextSlash = tail.indexOf(47);
            if (nextSlash > 0) {
                dirs.add(tail.substring(0, nextSlash));
                continue;
            }
            result.add(this.createStatus(file));
        }
    }

    private boolean deleteMatchingFiles(List<MockFile> files, String path) {
        Iterator<MockFile> fileIter = files.iterator();
        boolean result = true;
        while (fileIter.hasNext()) {
            MockFile file = fileIter.next();
            String filename = file.path.toString();
            if (!filename.startsWith(path) || filename.length() <= path.length() || filename.charAt(path.length()) != '/') continue;
            if (file.cannotDelete) {
                result = false;
                continue;
            }
            assert (!file.isDeleted);
            file.isDeleted = true;
            fileIter.remove();
        }
        return result;
    }

    private void findMatchingLocatedFiles(List<MockFile> files, String pathnameAsDir, Set<String> dirs, List<LocatedFileStatus> result) throws IOException {
        for (MockFile file : files) {
            String filename = file.path.toString();
            if (!filename.startsWith(pathnameAsDir)) continue;
            String tail = filename.substring(pathnameAsDir.length());
            int nextSlash = tail.indexOf(47);
            if (nextSlash > 0) {
                dirs.add(tail.substring(0, nextSlash));
                continue;
            }
            result.add(this.createLocatedStatus(file));
        }
    }

    public void setWorkingDirectory(Path path) {
        this.workingDir = path;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) {
        this.statistics.incrementWriteOps(1);
        return false;
    }

    private FileStatus createStatus(MockFile file) {
        if (this.fileStatusMap.containsKey(file)) {
            return this.fileStatusMap.get(file);
        }
        FileStatus fileStatus = new FileStatus((long)file.length, false, 1, (long)file.blockSize, 0L, 0L, FsPermission.createImmutable((short)644), "owen", "group", file.path);
        this.fileStatusMap.put(file, fileStatus);
        return fileStatus;
    }

    private FileStatus createDirectory(Path dir) {
        return new FileStatus(0L, true, 0, 0L, 0L, 0L, FsPermission.createImmutable((short)755), "owen", "group", dir);
    }

    private LocatedFileStatus createLocatedStatus(MockFile file) throws IOException {
        FileStatus fileStatus = this.createStatus(file);
        return new LocatedFileStatus(fileStatus, this.getFileBlockLocationsImpl(fileStatus, 0L, fileStatus.getLen(), false));
    }

    private LocatedFileStatus createLocatedDirectory(Path dir) throws IOException {
        FileStatus fileStatus = this.createDirectory(dir);
        return new LocatedFileStatus(fileStatus, this.getFileBlockLocationsImpl(fileStatus, 0L, fileStatus.getLen(), false));
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        this.checkAccess();
        path = path.makeQualified((FileSystem)this);
        String pathnameAsDir = path.toString() + "/";
        MockFile file = this.findFile(path);
        if (file != null) {
            return this.createStatus(file);
        }
        for (MockFile dir : this.files) {
            if (!dir.path.toString().startsWith(pathnameAsDir)) continue;
            return this.createDirectory(path);
        }
        for (MockFile dir : globalFiles) {
            if (!dir.path.toString().startsWith(pathnameAsDir)) continue;
            return this.createDirectory(path);
        }
        throw new FileNotFoundException("File " + path + " does not exist");
    }

    public BlockLocation[] getFileBlockLocations(FileStatus stat, long start, long len) throws IOException {
        return this.getFileBlockLocationsImpl(stat, start, len, true);
    }

    private BlockLocation[] getFileBlockLocationsImpl(FileStatus stat, long start, long len, boolean updateStats) throws IOException {
        if (updateStats) {
            this.statistics.incrementReadOps(1);
        }
        this.checkAccess();
        ArrayList<BlockLocation> result = new ArrayList<BlockLocation>();
        MockFile file = this.findFile(stat.getPath());
        if (file != null) {
            for (MockBlock block : file.blocks) {
                if (MockFileSystem.getOverlap(block.offset, block.length, start, len) <= 0L) continue;
                String[] topology = new String[block.hosts.length];
                for (int i = 0; i < topology.length; ++i) {
                    topology[i] = "/rack/ " + block.hosts[i];
                }
                result.add(new BlockLocation(block.hosts, block.hosts, topology, (long)block.offset, (long)block.length));
            }
            return result.toArray(new BlockLocation[result.size()]);
        }
        return new BlockLocation[0];
    }

    private static long getOverlap(long offset1, long length1, long offset2, long length2) {
        long end1 = offset1 + length1;
        long end2 = offset2 + length2;
        if (end2 <= offset1 || end1 <= offset2) {
            return 0L;
        }
        return Math.min(end1, end2) - Math.max(offset1, offset2);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("mockFs{files:[");
        for (int i = 0; i < this.files.size(); ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.files.get(i));
        }
        buffer.append("]}");
        return buffer.toString();
    }

    public static void addGlobalFile(MockFile mockFile) {
        globalFiles.add(mockFile);
    }

    public static void clearGlobalFiles() {
        globalFiles.clear();
    }

    public void addFile(MockFile file) {
        this.files.add(file);
    }

    public static class MockOutputStream
    extends FSDataOutputStream {
        public final MockFile file;

        public MockOutputStream(MockFile file) throws IOException {
            super((OutputStream)new DataOutputBuffer(), null);
            this.file = file;
        }

        public void setBlocks(MockBlock ... blocks) {
            this.file.blocks = blocks;
            int offset = 0;
            for (int i = 0; offset < this.file.length && i < blocks.length; offset += blocks[i].length, ++i) {
                blocks[i].offset = offset;
                blocks[i].length = Math.min(this.file.length - offset, this.file.blockSize);
            }
        }

        public void close() throws IOException {
            super.close();
            DataOutputBuffer buf = (DataOutputBuffer)this.getWrappedStream();
            this.file.length = buf.getLength();
            this.file.content = new byte[this.file.length];
            MockBlock block = new MockBlock("host1");
            block.setLength(this.file.length);
            this.setBlocks(block);
            System.arraycopy(buf.getData(), 0, this.file.content, 0, this.file.length);
        }

        public String toString() {
            return "Out stream to " + this.file.toString();
        }
    }

    public static class MockPath
    extends Path {
        private final FileSystem fs;

        public MockPath(FileSystem fs, String path) {
            super(path);
            this.fs = fs;
        }

        public FileSystem getFileSystem(Configuration conf) {
            return this.fs;
        }
    }

    static class MockInputStream
    extends FSInputStream {
        final MockFile file;
        int offset = 0;

        public MockInputStream(MockFile file) throws IOException {
            this.file = file;
        }

        public void seek(long offset) throws IOException {
            this.offset = (int)offset;
        }

        public long getPos() throws IOException {
            return this.offset;
        }

        public boolean seekToNewSource(long l) throws IOException {
            return false;
        }

        public int read() throws IOException {
            if (this.offset < this.file.length) {
                return this.file.content[this.offset++] & 0xFF;
            }
            return -1;
        }
    }

    public static class MockFile {
        public final Path path;
        public int blockSize;
        public int length;
        public MockBlock[] blocks;
        public byte[] content;
        public boolean cannotDelete = false;
        public boolean isDeleted = false;

        public MockFile(String path, int blockSize, byte[] content, MockBlock ... blocks) {
            this.path = new Path(path);
            this.blockSize = blockSize;
            this.blocks = blocks;
            this.content = content;
            this.length = content.length;
            int offset = 0;
            for (MockBlock block : blocks) {
                block.offset = offset;
                block.length = Math.min(this.length - offset, blockSize);
                offset += block.length;
            }
        }

        public int hashCode() {
            return this.path.hashCode() + 31 * this.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MockFile)) {
                return false;
            }
            return ((MockFile)obj).path.equals((Object)this.path) && ((MockFile)obj).length == this.length;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mockFile{path: ");
            buffer.append(this.path.toString());
            buffer.append(", blkSize: ");
            buffer.append(this.blockSize);
            buffer.append(", len: ");
            buffer.append(this.length);
            buffer.append(", blocks: [");
            for (int i = 0; i < this.blocks.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.blocks[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MockBlock {
        int offset;
        int length;
        final String[] hosts;

        public MockBlock(String ... hosts) {
            this.hosts = hosts;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("block{offset: ");
            buffer.append(this.offset);
            buffer.append(", length: ");
            buffer.append(this.length);
            buffer.append(", hosts: [");
            for (int i = 0; i < this.hosts.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.hosts[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MockAccessDenied
    extends IOException {
    }
}

