/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.Test;

public class TestHiveConfRestrictList
extends TestCase {
    private HiveConf conf = null;

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST.varname, HiveConf.ConfVars.HIVETESTMODEPREFIX.varname);
        this.conf = new HiveConf();
    }

    @Test
    public void testRestriction() throws Exception {
        this.verifyRestriction(HiveConf.ConfVars.HIVETESTMODEPREFIX.varname, "foo");
        this.conf.verifyAndSet(HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION.varname, "false");
    }

    @Test
    public void testMultipleRestrictions() throws Exception {
        this.verifyRestriction(HiveConf.ConfVars.HIVETESTMODEPREFIX.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.HIVE_IN_TEST.varname, "true");
    }

    @Test
    public void testRestrictList() throws Exception {
        this.verifyRestriction(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST.varname, "foo");
    }

    @Test
    public void testAppendRestriction() throws Exception {
        String appendListStr = HiveConf.ConfVars.SCRATCHDIR.varname + "," + HiveConf.ConfVars.LOCALSCRATCHDIR.varname + "," + HiveConf.ConfVars.METASTOREURIS.varname;
        this.conf.addToRestrictList(appendListStr);
        String newRestrictList = this.conf.getVar(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST);
        TestHiveConfRestrictList.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.SCRATCHDIR.varname));
        TestHiveConfRestrictList.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.LOCALSCRATCHDIR.varname));
        TestHiveConfRestrictList.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.METASTOREURIS.varname));
        TestHiveConfRestrictList.assertTrue((boolean)newRestrictList.contains(HiveConf.ConfVars.HIVETESTMODEPREFIX.varname));
        this.verifyRestriction(HiveConf.ConfVars.HIVETESTMODEPREFIX.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.HIVE_CONF_RESTRICTED_LIST.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.LOCALSCRATCHDIR.varname, "foo");
        this.verifyRestriction(HiveConf.ConfVars.METASTOREURIS.varname, "foo");
    }

    private void verifyRestriction(String varName, String newVal) {
        try {
            this.conf.verifyAndSet(varName, newVal);
            TestHiveConfRestrictList.fail((String)("Setting config property " + varName + " should fail"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

