/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCodahaleReportersConf {
    private static File workDir = new File(System.getProperty("test.tmp.dir"));
    private static File jsonReportFile;

    @After
    public void after() throws Exception {
        MetricsFactory.close();
    }

    @Test
    public void testFallbackToDeprecatedConfig() throws Exception {
        HiveConf conf = new HiveConf();
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.set("fs.defaultFS", "local");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_CLASS, CodahaleMetrics.class.getCanonicalName());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, "JMX, JSON");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION, jsonReportFile.toString());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "100ms");
        MetricsFactory.init((HiveConf)conf);
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().incrementCounter("count2");
        }
        byte[] jsonData = MetricsTestUtils.getFileData(jsonReportFile.getAbsolutePath(), 2000, 3);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(jsonData);
        JsonNode countersNode = rootNode.path("counters");
        JsonNode methodCounterNode = countersNode.path("count2");
        JsonNode countNode = methodCounterNode.path("count");
        Assert.assertEquals((long)countNode.asInt(), (long)5L);
    }

    @Test
    public void testNoFallback() throws Exception {
        HiveConf conf = new HiveConf();
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.set("fs.defaultFS", "local");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_CLASS, CodahaleMetrics.class.getCanonicalName());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, "JMX, JSON");
        conf.setVar(HiveConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES, "org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION, jsonReportFile.toString());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "100ms");
        MetricsFactory.init((HiveConf)conf);
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().incrementCounter("count2");
        }
        Assert.assertFalse((boolean)jsonReportFile.exists());
    }

    @Test
    public void testNoFallbackOnIncorrectConf() throws Exception {
        HiveConf conf = new HiveConf();
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.set("fs.defaultFS", "local");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_CLASS, CodahaleMetrics.class.getCanonicalName());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, "JMX, JSON");
        conf.setVar(HiveConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES, "org.apache.hadoop.hive.common.metrics.NonExistentReporter");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION, jsonReportFile.toString());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "100ms");
        try {
            MetricsFactory.init((HiveConf)conf);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)jsonReportFile.exists());
    }
}

