/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.sql.Timestamp;
import org.apache.hive.common.util.TimestampParser;
import org.junit.Assert;
import org.junit.Test;

public class TestTimestampParser {
    static void testValidCases(TimestampParser tp, ValidTimestampCase[] validCases) {
        for (ValidTimestampCase validCase : validCases) {
            Timestamp ts = tp.parseTimestamp(validCase.strValue);
            Assert.assertEquals((String)("Parsing " + validCase.strValue), (Object)validCase.expectedValue, (Object)ts);
        }
    }

    static void testInvalidCases(TimestampParser tp, String[] invalidCases) {
        for (String invalidString : invalidCases) {
            try {
                Timestamp ts = tp.parseTimestamp(invalidString);
                Assert.fail((String)("Expected exception parsing " + invalidString + ", but parsed value to " + ts));
            }
            catch (IllegalArgumentException err) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDefault() {
        TimestampParser tp = new TimestampParser();
        ValidTimestampCase[] validCases = new ValidTimestampCase[]{new ValidTimestampCase("1945-12-31 23:59:59.0", Timestamp.valueOf("1945-12-31 23:59:59.0")), new ValidTimestampCase("1945-12-31 23:59:59.1234", Timestamp.valueOf("1945-12-31 23:59:59.1234")), new ValidTimestampCase("1970-01-01 00:00:00", Timestamp.valueOf("1970-01-01 00:00:00"))};
        String[] invalidCases = new String[]{"1945-12-31T23:59:59", "12345"};
        TestTimestampParser.testValidCases(tp, validCases);
        TestTimestampParser.testInvalidCases(tp, invalidCases);
    }

    @Test
    public void testPattern1() {
        String[] patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSS"};
        TimestampParser tp = new TimestampParser(patterns);
        ValidTimestampCase[] validCases = new ValidTimestampCase[]{new ValidTimestampCase("1945-12-31T23:59:59.0", Timestamp.valueOf("1945-12-31 23:59:59.0")), new ValidTimestampCase("2001-01-01 00:00:00.100", Timestamp.valueOf("2001-01-01 00:00:00.100")), new ValidTimestampCase("2001-01-01 00:00:00.001", Timestamp.valueOf("2001-01-01 00:00:00.001")), new ValidTimestampCase("1945-12-31T23:59:59.1234", Timestamp.valueOf("1945-12-31 23:59:59.123")), new ValidTimestampCase("1970-01-01T00:00:00", Timestamp.valueOf("1970-01-01 00:00:00")), new ValidTimestampCase("1970-4-5T6:7:8", Timestamp.valueOf("1970-04-05 06:07:08")), new ValidTimestampCase("2001-01-01 00:00:00", Timestamp.valueOf("2001-01-01 00:00:00")), new ValidTimestampCase("1945-12-31 23:59:59.1234", Timestamp.valueOf("1945-12-31 23:59:59.1234"))};
        String[] invalidCases = new String[]{"1945-12-31-23:59:59", "1945-12-31T23:59:59.12345", "12345"};
        TestTimestampParser.testValidCases(tp, validCases);
        TestTimestampParser.testInvalidCases(tp, invalidCases);
    }

    @Test
    public void testMillisParser() {
        String[] patterns = new String[]{"millis", "yyyy-MM-dd'T'HH:mm:ss"};
        TimestampParser tp = new TimestampParser(patterns);
        ValidTimestampCase[] validCases = new ValidTimestampCase[]{new ValidTimestampCase("0", new Timestamp(0L)), new ValidTimestampCase("-1000000", new Timestamp(-1000000L)), new ValidTimestampCase("1420509274123", new Timestamp(1420509274123L)), new ValidTimestampCase("1420509274123.456789", new Timestamp(1420509274123L)), new ValidTimestampCase("1945-12-31T23:59:59", Timestamp.valueOf("1945-12-31 23:59:59"))};
        String[] invalidCases = new String[]{"1945-12-31-23:59:59", "1945-12-31T23:59:59.12345", "1420509274123-"};
        TestTimestampParser.testValidCases(tp, validCases);
        TestTimestampParser.testInvalidCases(tp, invalidCases);
    }

    @Test
    public void testPattern2() {
        String[] patterns = new String[]{"HH:mm", "MM:dd:ss"};
        TimestampParser tp = new TimestampParser(patterns);
        ValidTimestampCase[] validCases = new ValidTimestampCase[]{new ValidTimestampCase("05:06", Timestamp.valueOf("1970-01-01 05:06:00")), new ValidTimestampCase("05:06:07", Timestamp.valueOf("1970-05-06 00:00:07"))};
        String[] invalidCases = new String[]{"1945-12-31T23:59:59", "1945:12:31-", "12345"};
        TestTimestampParser.testValidCases(tp, validCases);
        TestTimestampParser.testInvalidCases(tp, invalidCases);
    }

    public static class ValidTimestampCase {
        String strValue;
        Timestamp expectedValue;

        public ValidTimestampCase(String strValue, Timestamp expectedValue) {
            this.strValue = strValue;
            this.expectedValue = expectedValue;
        }
    }
}

