/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.UnsignedInt128;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUnsignedInt128 {
    private UnsignedInt128 zero;
    private UnsignedInt128 one;
    private UnsignedInt128 two;

    @Before
    public void setUp() throws Exception {
        this.zero = new UnsignedInt128(0L);
        this.one = new UnsignedInt128(1L);
        this.two = new UnsignedInt128(2L);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testHashCode() {
        this.assertNotEquals(this.one.hashCode(), this.two.hashCode());
        this.assertNotEquals(this.zero.hashCode(), this.one.hashCode());
        this.assertNotEquals(this.zero.hashCode(), this.two.hashCode());
        Assert.assertEquals((long)this.zero.hashCode(), (long)new UnsignedInt128(0L).hashCode());
        Assert.assertEquals((long)this.one.hashCode(), (long)new UnsignedInt128(1L).hashCode());
        Assert.assertEquals((long)this.two.hashCode(), (long)new UnsignedInt128(2L).hashCode());
    }

    private void assertNotEquals(int a, int b) {
        Assert.assertTrue((a != b ? 1 : 0) != 0);
    }

    private void assertNotEquals(long a, long b) {
        Assert.assertTrue((a != b ? 1 : 0) != 0);
    }

    private void assertNotEquals(UnsignedInt128 a, UnsignedInt128 b) {
        Assert.assertTrue((!a.equals(b) ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        this.assertNotEquals(this.one, this.two);
        this.assertNotEquals(this.zero, this.one);
        this.assertNotEquals(this.zero, this.two);
        Assert.assertEquals((Object)this.zero, (Object)new UnsignedInt128(0L));
        Assert.assertEquals((Object)this.one, (Object)new UnsignedInt128(1L));
        Assert.assertEquals((Object)this.two, (Object)new UnsignedInt128(2L));
    }

    @Test
    public void testCompareTo() {
        Assert.assertTrue((this.one.compareTo(this.two) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.two.compareTo(this.one) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.zero) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareTo(this.two) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToScaleTen() {
        Assert.assertTrue((this.zero.compareToScaleTen(new UnsignedInt128(0L), (short)3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareToScaleTen(new UnsignedInt128(0L), (short)-1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareToScaleTen(new UnsignedInt128(0L), (short)12) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareToScaleTen(this.zero, (short)0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareToScaleTen(this.zero, (short)3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareToScaleTen(this.zero, (short)-3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareToScaleTen(this.one, (short)3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareToScaleTen(this.one, (short)0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.zero.compareToScaleTen(this.one, (short)-1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(30L).compareToScaleTen(new UnsignedInt128(3L), (short)1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(30L).compareToScaleTen(new UnsignedInt128(3L), (short)2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(30L).compareToScaleTen(new UnsignedInt128(3L), (short)0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(680000000000L).compareToScaleTen(new UnsignedInt128(68L), (short)10) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(68L).compareToScaleTen(new UnsignedInt128(680000000000L), (short)-10) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(680000000000L).compareToScaleTen(new UnsignedInt128(0L), (short)60) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(680000000000L).compareToScaleTen(new UnsignedInt128(0L), (short)30) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(680000000000L).compareToScaleTen(new UnsignedInt128(0L), (short)10) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0L).compareToScaleTen(new UnsignedInt128(680000000000L), (short)-10) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0L).compareToScaleTen(new UnsignedInt128(680000000000L), (short)-11) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0L).compareToScaleTen(new UnsignedInt128(680000000000L), (short)-12) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0L).compareToScaleTen(new UnsignedInt128(680000000000L), (short)-13) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0L).compareToScaleTen(new UnsignedInt128(680000000000L), (short)-30) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(680000000000L).compareToScaleTen(new UnsignedInt128(680000000001L), (short)0) < 1 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(68000000000L).compareToScaleTen(new UnsignedInt128(680000000001L), (short)-1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(68000000000L).compareToScaleTen(new UnsignedInt128(680000000000L), (short)-1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(68000000000L).compareToScaleTen(new UnsignedInt128(679999999999L), (short)-1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0x10000000000000L).shiftLeftConstructive(32).compareToScaleTen(new UnsignedInt128(0xA0000000000000L).shiftLeftConstructive(32), (short)-1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0x10000000000000L).shiftLeftConstructive(32).compareToScaleTen(new UnsignedInt128(0xA0000000000000L).shiftLeftConstructive(32), (short)1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0x10000000000000L).shiftLeftConstructive(32).compareToScaleTen(new UnsignedInt128(0xA0000000000000L).shiftLeftConstructive(32), (short)0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new UnsignedInt128(0x10000000000000L).shiftLeftConstructive(32).compareToScaleTen(new UnsignedInt128(0xA0000000000000L).shiftLeftConstructive(32), (short)-2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToFormalString() {
        Assert.assertEquals((Object)"0", (Object)this.zero.toFormalString());
        Assert.assertEquals((Object)"1", (Object)this.one.toFormalString());
        Assert.assertEquals((Object)"30", (Object)new UnsignedInt128(30L).toFormalString());
        Assert.assertEquals((Object)"680000000000", (Object)new UnsignedInt128(680000000000L).toFormalString());
        Assert.assertEquals((Object)"6800000000000", (Object)new UnsignedInt128(6800000000000L).toFormalString());
        Assert.assertEquals((Object)"68", (Object)new UnsignedInt128(68L).toFormalString());
        Assert.assertEquals((Object)this.zero, (Object)new UnsignedInt128("0"));
        Assert.assertEquals((Object)this.one, (Object)new UnsignedInt128("1"));
        Assert.assertEquals((Object)new UnsignedInt128(30L), (Object)new UnsignedInt128("30"));
        Assert.assertEquals((Object)new UnsignedInt128(680000000000L), (Object)new UnsignedInt128("680000000000"));
        Assert.assertEquals((Object)new UnsignedInt128(6800000000000L), (Object)new UnsignedInt128("6800000000000"));
        Assert.assertEquals((Object)new UnsignedInt128(68L), (Object)new UnsignedInt128("68"));
    }

    @Test
    public void testUnsignedInt128() {
        Assert.assertEquals((long)0L, (long)new UnsignedInt128().asLong());
    }

    @Test
    public void testUnsignedInt128UnsignedInt128() {
        Assert.assertEquals((long)1L, (long)new UnsignedInt128(this.one).asLong());
        Assert.assertEquals((long)2L, (long)new UnsignedInt128(this.two).asLong());
    }

    @Test
    public void testUnsignedInt128IntIntIntInt() {
        Assert.assertEquals((long)47244640279L, (long)new UnsignedInt128(23, 11, 0, 0).asLong());
    }

    @Test
    public void testZeroClear() {
        Assert.assertFalse((boolean)this.one.isZero());
        Assert.assertFalse((boolean)this.two.isZero());
        this.assertNotEquals(0L, this.one.asLong());
        this.assertNotEquals(0L, this.two.asLong());
        this.two.zeroClear();
        this.assertNotEquals(0L, this.one.asLong());
        Assert.assertEquals((long)0L, (long)this.two.asLong());
        Assert.assertFalse((boolean)this.one.isZero());
        Assert.assertTrue((boolean)this.two.isZero());
        this.one.zeroClear();
        Assert.assertEquals((long)0L, (long)this.one.asLong());
        Assert.assertEquals((long)0L, (long)this.two.asLong());
        Assert.assertTrue((boolean)this.one.isZero());
        Assert.assertTrue((boolean)this.two.isZero());
    }

    @Test
    public void testAddDestructive() {
        this.one.addDestructive(this.two);
        Assert.assertEquals((long)3L, (long)this.one.asLong());
        Assert.assertEquals((long)2L, (long)this.two.asLong());
        UnsignedInt128 big = new UnsignedInt128(0x4000000000000003L);
        UnsignedInt128 tmp = new UnsignedInt128(0L);
        for (int i = 0; i < 54; ++i) {
            tmp.addDestructive(big);
        }
        Assert.assertEquals((long)162L, (long)tmp.getV0());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)tmp.getV1());
        Assert.assertEquals((long)13L, (long)tmp.getV2());
        Assert.assertEquals((long)0L, (long)tmp.getV3());
        Assert.assertEquals((long)0x4000000000000003L, (long)big.asLong());
        UnsignedInt128 huge = this.one.shiftLeftConstructive(127);
        UnsignedInt128 huge2 = this.one.shiftLeftConstructive(127);
        try {
            huge2.addDestructive(huge);
            Assert.fail();
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSubtractDestructive() {
        this.two.subtractDestructive(this.one);
        Assert.assertEquals((long)1L, (long)this.one.asLong());
        Assert.assertEquals((long)1L, (long)this.one.asLong());
        try {
            this.one.subtractDestructive(new UnsignedInt128(10L));
            Assert.fail();
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        UnsignedInt128 big = new UnsignedInt128(4611686069966995459L);
        big.shiftLeftDestructive(6);
        UnsignedInt128 tmp = new UnsignedInt128(0x2000000000000005L);
        tmp.shiftLeftDestructive(6);
        big.subtractDestructive(tmp);
        big.subtractDestructive(tmp);
        Assert.assertEquals((long)-448L, (long)big.getV0());
        Assert.assertEquals((long)767L, (long)big.getV1());
        Assert.assertEquals((long)0L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
    }

    @Test
    public void testMultiplyDestructiveInt() {
        this.two.multiplyDestructive(1);
        Assert.assertEquals((long)2L, (long)this.two.asLong());
        Assert.assertEquals((long)1L, (long)this.one.asLong());
        this.two.multiplyDestructive(2);
        Assert.assertEquals((long)4L, (long)this.two.asLong());
        UnsignedInt128 five = new UnsignedInt128(5L);
        five.multiplyDestructive(6432346);
        Assert.assertEquals((long)32161730L, (long)five.getV0());
        Assert.assertEquals((long)0L, (long)five.getV1());
        Assert.assertEquals((long)0L, (long)five.getV2());
        Assert.assertEquals((long)0L, (long)five.getV3());
        UnsignedInt128 big = new UnsignedInt128(4611686069966995459L);
        big.multiplyDestructive(96);
        Assert.assertEquals((long)288L, (long)big.getV0());
        Assert.assertEquals((long)1152L, (long)big.getV1());
        Assert.assertEquals((long)24L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        UnsignedInt128 tmp = new UnsignedInt128(1L);
        tmp.shiftLeftDestructive(126);
        tmp.multiplyDestructive(2);
        try {
            tmp.multiplyDestructive(2);
            Assert.fail();
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testShiftDestructive() {
        UnsignedInt128 big = new UnsignedInt128(4611686117211635801L);
        big.shiftLeftDestructive(2);
        Assert.assertEquals((long)356L, (long)big.getV0());
        Assert.assertEquals((long)92L, (long)big.getV1());
        Assert.assertEquals((long)1L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        big.shiftLeftDestructive(32);
        Assert.assertEquals((long)0L, (long)big.getV0());
        Assert.assertEquals((long)356L, (long)big.getV1());
        Assert.assertEquals((long)92L, (long)big.getV2());
        Assert.assertEquals((long)1L, (long)big.getV3());
        big.shiftRightDestructive(2, true);
        Assert.assertEquals((long)0L, (long)big.getV0());
        Assert.assertEquals((long)89L, (long)big.getV1());
        Assert.assertEquals((long)1073741847L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        big.shiftRightDestructive(32, true);
        Assert.assertEquals((long)89L, (long)big.getV0());
        Assert.assertEquals((long)1073741847L, (long)big.getV1());
        Assert.assertEquals((long)0L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        UnsignedInt128 tmp = new UnsignedInt128(17L);
        Assert.assertEquals((long)17L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)9L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, false);
        Assert.assertEquals((long)4L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)2L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)1L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, true);
        Assert.assertEquals((long)1L, (long)tmp.getV0());
        tmp.shiftRightDestructive(1, false);
        Assert.assertEquals((long)0L, (long)tmp.getV0());
    }

    @Test
    public void testMultiplyDestructiveUnsignedInt128() {
        this.two.multiplyDestructive(this.one);
        Assert.assertEquals((long)2L, (long)this.two.asLong());
        Assert.assertEquals((long)1L, (long)this.one.asLong());
        this.two.multiplyDestructive(this.two);
        Assert.assertEquals((long)4L, (long)this.two.asLong());
        UnsignedInt128 five = new UnsignedInt128(5L);
        five.multiplyDestructive(new UnsignedInt128(6432346L));
        Assert.assertEquals((long)32161730L, (long)five.getV0());
        Assert.assertEquals((long)0L, (long)five.getV1());
        Assert.assertEquals((long)0L, (long)five.getV2());
        Assert.assertEquals((long)0L, (long)five.getV3());
        UnsignedInt128 big = new UnsignedInt128(4611686069966995459L);
        big.multiplyDestructive(new UnsignedInt128(96L));
        Assert.assertEquals((long)288L, (long)big.getV0());
        Assert.assertEquals((long)1152L, (long)big.getV1());
        Assert.assertEquals((long)24L, (long)big.getV2());
        Assert.assertEquals((long)0L, (long)big.getV3());
        UnsignedInt128 tmp = new UnsignedInt128(1L);
        tmp.shiftLeftDestructive(126);
        tmp.multiplyDestructive(new UnsignedInt128(2L));
        try {
            tmp.multiplyDestructive(new UnsignedInt128(2L));
            Assert.fail();
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
        UnsignedInt128 complicated1 = new UnsignedInt128(-108449846, 1506871725, 87337804, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        UnsignedInt128 complicated2 = new UnsignedInt128(54234234, 9, 0, 0);
        BigInteger bigInteger2 = complicated2.toBigIntegerSlow();
        complicated1.multiplyDestructive(complicated2);
        BigInteger ans = bigInteger1.multiply(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
        try {
            UnsignedInt128 complicated3 = new UnsignedInt128(-108449846, 1506871725, 87337804, 0);
            complicated3.multiplyDestructive(new UnsignedInt128(54234234, 9845, 0, 0));
            Assert.fail();
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testMultiplyScaleDownTenDestructiveScaleTen() {
        for (int scale = 0; scale < 38; ++scale) {
            UnsignedInt128 right = new UnsignedInt128(1L);
            right.scaleUpTenDestructive((short)scale);
            UnsignedInt128 leftJust = new UnsignedInt128(1L);
            leftJust.scaleUpTenDestructive((short)15);
            UnsignedInt128 leftInc = leftJust.incrementConstructive();
            UnsignedInt128 leftDec = leftJust.decrementConstructive();
            if (scale + 10 <= 38) {
                leftJust.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)100000L, (long)leftJust.asLong());
                leftInc.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)100000L, (long)leftInc.asLong());
                leftDec.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)100000L, (long)leftDec.asLong());
            } else {
                leftJust.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)0L, (long)leftJust.asLong());
                leftInc.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)0L, (long)leftInc.asLong());
                leftDec.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)0L, (long)leftDec.asLong());
            }
            UnsignedInt128 leftHalfJust = new UnsignedInt128(1L);
            leftHalfJust.scaleUpTenDestructive((short)6);
            leftHalfJust.addDestructive(new UnsignedInt128(5L));
            leftHalfJust.scaleUpTenDestructive((short)9);
            UnsignedInt128 leftHalfInc = leftHalfJust.incrementConstructive();
            UnsignedInt128 leftHalfDec = leftHalfJust.decrementConstructive();
            if (scale + 10 <= 38) {
                leftHalfJust.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)100001L, (long)leftHalfJust.asLong());
                leftHalfInc.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)100001L, (long)leftHalfInc.asLong());
                leftHalfDec.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
                Assert.assertEquals((String)("scale=" + scale), (long)100000L, (long)leftHalfDec.asLong());
                continue;
            }
            leftHalfJust.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
            Assert.assertEquals((String)("scale=" + scale), (long)0L, (long)leftHalfJust.asLong());
            leftHalfInc.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
            Assert.assertEquals((String)("scale=" + scale), (long)0L, (long)leftHalfInc.asLong());
            leftHalfDec.multiplyScaleDownTenDestructive(right, (short)(scale + 10));
            Assert.assertEquals((String)("scale=" + scale), (long)0L, (long)leftHalfDec.asLong());
        }
    }

    @Test
    public void testDivideDestructiveInt() {
        this.two.divideDestructive(1);
        Assert.assertEquals((long)1L, (long)this.one.asLong());
        Assert.assertEquals((long)2L, (long)this.two.asLong());
        this.one.divideDestructive(2);
        Assert.assertEquals((long)0L, (long)this.one.asLong());
        Assert.assertEquals((long)2L, (long)this.two.asLong());
        UnsignedInt128 var1 = new UnsignedInt128(1234234662345L);
        var1.divideDestructive(642337);
        Assert.assertEquals((long)1921475L, (long)var1.asLong());
        UnsignedInt128 complicated1 = new UnsignedInt128(-108449846, 1506871725, 87337804, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        complicated1.divideDestructive(1534223465);
        BigInteger bigInteger2 = BigInteger.valueOf(1534223465L);
        BigInteger ans = bigInteger1.divide(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
        try {
            complicated1.divideDestructive(0);
            Assert.fail();
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testDivideDestructiveUnsignedInt128() {
        UnsignedInt128 remainder = new UnsignedInt128();
        this.two.divideDestructive(this.one, remainder);
        Assert.assertEquals((long)1L, (long)this.one.asLong());
        Assert.assertEquals((long)2L, (long)this.two.asLong());
        Assert.assertEquals((Object)this.zero, (Object)remainder);
        this.one.divideDestructive(this.two, remainder);
        Assert.assertEquals((long)0L, (long)this.one.asLong());
        Assert.assertEquals((long)2L, (long)this.two.asLong());
        Assert.assertEquals((Object)new UnsignedInt128(1L), (Object)remainder);
        UnsignedInt128 var1 = new UnsignedInt128(1234234662345L);
        var1.divideDestructive(new UnsignedInt128(642337L), remainder);
        Assert.assertEquals((long)1921475L, (long)var1.asLong());
        Assert.assertEquals((long)175270L, (long)remainder.asLong());
        UnsignedInt128 complicated1 = new UnsignedInt128(-108449846, 1506871725, 87337804, 1111055068);
        UnsignedInt128 complicated2 = new UnsignedInt128(-258096742, 4660, 0, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        BigInteger bigInteger2 = complicated2.toBigIntegerSlow();
        complicated1.divideDestructive(complicated2, remainder);
        BigInteger ans = bigInteger1.divide(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
        try {
            complicated1.divideDestructive(this.zero, remainder);
            Assert.fail();
        }
        catch (ArithmeticException ex) {
            // empty catch block
        }
    }

    @Test
    public void testDivideDestructiveUnsignedInt128Again() {
        UnsignedInt128 complicated1 = new UnsignedInt128(-108449846, 1506871725, 0, 0);
        UnsignedInt128 complicated2 = new UnsignedInt128(-258096742, 3, 0, 0);
        BigInteger bigInteger1 = complicated1.toBigIntegerSlow();
        BigInteger bigInteger2 = complicated2.toBigIntegerSlow();
        complicated1.divideDestructive(complicated2, new UnsignedInt128());
        BigInteger ans = bigInteger1.divide(bigInteger2);
        Assert.assertEquals((Object)ans, (Object)complicated1.toBigIntegerSlow());
    }

    @Test
    public void testBigIntConversion() {
        BigInteger bigInteger = BigInteger.valueOf(7526015090963542L);
        UnsignedInt128 uInt128 = new UnsignedInt128(bigInteger);
        Assert.assertEquals((Object)bigInteger, (Object)uInt128.toBigIntegerSlow());
    }
}

