/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import com.google.code.tempusfugit.concurrency.ConcurrentRule;
import com.google.code.tempusfugit.concurrency.RepeatingRule;
import com.google.code.tempusfugit.concurrency.annotations.Concurrent;
import com.google.code.tempusfugit.concurrency.annotations.Repeating;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestHiveDecimal {
    @Rule
    public ConcurrentRule concurrentRule = new ConcurrentRule();
    @Rule
    public RepeatingRule repeatingRule = new RepeatingRule();

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testPrecisionScaleEnforcement() {
        String decStr = "1786135888657847525803324040144343378.09799306448796128931113691624";
        HiveDecimal dec = HiveDecimal.create((String)decStr);
        Assert.assertEquals((Object)"1786135888657847525803324040144343378.1", (Object)dec.toString());
        Assert.assertTrue((String)"Decimal precision should not go above maximum", (dec.precision() <= 38 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Decimal scale should not go above maximum", (dec.scale() <= 38 ? 1 : 0) != 0);
        decStr = "57847525803324040144343378.09799306448796128931113691624";
        HiveDecimal bd = HiveDecimal.create((String)decStr);
        HiveDecimal bd1 = HiveDecimal.enforcePrecisionScale((HiveDecimal)bd, (int)20, (int)5);
        Assert.assertNull((Object)bd1);
        bd1 = HiveDecimal.enforcePrecisionScale((HiveDecimal)bd, (int)35, (int)5);
        Assert.assertEquals((Object)"57847525803324040144343378.09799", (Object)bd1.toString());
        bd1 = HiveDecimal.enforcePrecisionScale((HiveDecimal)bd, (int)45, (int)20);
        Assert.assertNull((Object)bd1);
        dec = HiveDecimal.create((BigDecimal)new BigDecimal(decStr), (boolean)false);
        Assert.assertNull((Object)dec);
        dec = HiveDecimal.create((String)"-1786135888657847525803324040144343378.09799306448796128931113691624");
        Assert.assertEquals((Object)"-1786135888657847525803324040144343378.1", (Object)dec.toString());
        dec = HiveDecimal.create((String)"005.34000");
        Assert.assertEquals((long)dec.precision(), (long)3L);
        Assert.assertEquals((long)dec.scale(), (long)2L);
        dec = HiveDecimal.create((String)"178613588865784752580332404014434337809799306448796128931113691624");
        Assert.assertNull((Object)dec);
        Assert.assertEquals((Object)"10", (Object)HiveDecimal.enforcePrecisionScale((HiveDecimal)HiveDecimal.create((String)"9.5"), (int)2, (int)0).toString());
        Assert.assertNull((Object)HiveDecimal.enforcePrecisionScale((HiveDecimal)HiveDecimal.create((String)"9.5"), (int)1, (int)0));
        Assert.assertEquals((Object)"9", (Object)HiveDecimal.enforcePrecisionScale((HiveDecimal)HiveDecimal.create((String)"9.4"), (int)1, (int)0).toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testTrailingZeroRemovalAfterEnforcement() {
        String decStr = "8.090000000000000000000000000000000000000123456";
        HiveDecimal dec = HiveDecimal.create((String)decStr);
        Assert.assertEquals((Object)"8.09", (Object)dec.toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testMultiply() {
        HiveDecimal dec1 = HiveDecimal.create((String)"0.00001786135888657847525803");
        HiveDecimal dec2 = HiveDecimal.create((String)"3.0000123456789");
        Assert.assertNull((Object)dec1.multiply(dec2));
        dec1 = HiveDecimal.create((String)"178613588865784752580323232232323444.4");
        dec2 = HiveDecimal.create((String)"178613588865784752580302323232.3");
        Assert.assertNull((Object)dec1.multiply(dec2));
        dec1 = HiveDecimal.create((String)"47.324");
        dec2 = HiveDecimal.create((String)"9232.309");
        Assert.assertEquals((Object)"436909.791116", (Object)dec1.multiply(dec2).toString());
        dec1 = HiveDecimal.create((String)"3.140");
        dec2 = HiveDecimal.create((String)"1.00");
        Assert.assertEquals((Object)"3.14", (Object)dec1.multiply(dec2).toString());
        dec1 = HiveDecimal.create((String)"43.010");
        dec2 = HiveDecimal.create((String)"2");
        Assert.assertEquals((Object)"86.02", (Object)dec1.multiply(dec2).toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testPow() {
        HiveDecimal dec = HiveDecimal.create((String)"3.00001415926");
        Assert.assertEquals((Object)dec.pow(2), (Object)dec.multiply(dec));
        HiveDecimal dec1 = HiveDecimal.create((String)"0.000017861358882");
        dec1 = dec1.pow(3);
        Assert.assertNull((Object)dec1);
        dec1 = HiveDecimal.create((String)"3.140");
        Assert.assertEquals((Object)"9.8596", (Object)dec1.pow(2).toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testDivide() {
        HiveDecimal dec1 = HiveDecimal.create((String)"3.14");
        HiveDecimal dec2 = HiveDecimal.create((String)"3");
        Assert.assertNotNull((Object)dec1.divide(dec2));
        dec1 = HiveDecimal.create((String)"15");
        dec2 = HiveDecimal.create((String)"5");
        Assert.assertEquals((Object)"3", (Object)dec1.divide(dec2).toString());
        dec1 = HiveDecimal.create((String)"3.140");
        dec2 = HiveDecimal.create((String)"1.00");
        Assert.assertEquals((Object)"3.14", (Object)dec1.divide(dec2).toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testPlus() {
        HiveDecimal dec1 = HiveDecimal.create((String)"99999999999999999999999999999999999");
        HiveDecimal dec2 = HiveDecimal.create((String)"1");
        Assert.assertNotNull((Object)dec1.add(dec2));
        dec1 = HiveDecimal.create((String)"3.140");
        dec2 = HiveDecimal.create((String)"1.00");
        Assert.assertEquals((Object)"4.14", (Object)dec1.add(dec2).toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testSubtract() {
        HiveDecimal dec1 = HiveDecimal.create((String)"3.140");
        HiveDecimal dec2 = HiveDecimal.create((String)"1.00");
        Assert.assertEquals((Object)"2.14", (Object)dec1.subtract(dec2).toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testPosMod() {
        HiveDecimal hd1 = HiveDecimal.create((String)"-100.91");
        HiveDecimal hd2 = HiveDecimal.create((String)"9.8");
        HiveDecimal dec = hd1.remainder(hd2).add(hd2).remainder(hd2);
        Assert.assertEquals((Object)"6.89", (Object)dec.toString());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testHashCode() {
        Assert.assertEquals((long)HiveDecimal.create((String)"9").hashCode(), (long)HiveDecimal.create((String)"9.00").hashCode());
        Assert.assertEquals((long)HiveDecimal.create((String)"0").hashCode(), (long)HiveDecimal.create((String)"0.00").hashCode());
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testException() {
        HiveDecimal dec = HiveDecimal.create((String)"3.1415.926");
        Assert.assertNull((Object)dec);
        dec = HiveDecimal.create((String)"3abc43");
        Assert.assertNull((Object)dec);
    }

    @Test
    @Concurrent(count=4)
    @Repeating(repetition=100)
    public void testBinaryConversion() {
        this.testBinaryConversion("0.00");
        this.testBinaryConversion("-12.25");
        this.testBinaryConversion("234.79");
    }

    private void testBinaryConversion(String num) {
        HiveDecimal dec = HiveDecimal.create((String)num);
        int scale = 2;
        byte[] d = dec.setScale(2).unscaledValue().toByteArray();
        Assert.assertEquals((Object)dec, (Object)HiveDecimal.create((BigInteger)new BigInteger(d), (int)scale));
        int prec = 5;
        int len = (int)Math.ceil((Math.log(Math.pow(10.0, prec) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        byte[] res = new byte[len];
        if (dec.signum() == -1) {
            int i = 0;
            while (i < len) {
                int n = i++;
                res[n] = (byte)(res[n] | 0xFF);
            }
        }
        System.arraycopy(d, 0, res, len - d.length, d.length);
        Assert.assertEquals((Object)dec, (Object)HiveDecimal.create((BigInteger)new BigInteger(res), (int)scale));
    }
}

