/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.hive.common.metrics.LegacyMetrics;
import org.apache.hadoop.hive.common.metrics.MetricsMBeanImpl;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLegacyMetrics {
    private static final String scopeName = "foo";
    private static final long periodMs = 50L;
    private static LegacyMetrics metrics;

    @Before
    public void before() throws Exception {
        MetricsFactory.close();
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_CLASS, LegacyMetrics.class.getCanonicalName());
        MetricsFactory.init((HiveConf)conf);
        metrics = (LegacyMetrics)MetricsFactory.getInstance();
    }

    @After
    public void after() throws Exception {
        MetricsFactory.close();
    }

    @Test
    public void testMetricsMBean() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName oname = new ObjectName("org.apache.hadoop.hive.common.metrics:type=MetricsMBean");
        MBeanInfo mBeanInfo = mbs.getMBeanInfo(oname);
        Assert.assertEquals((Object)MetricsMBeanImpl.class.getName(), (Object)mBeanInfo.getClassName());
        MBeanOperationInfo[] oops = mBeanInfo.getOperations();
        boolean resetFound = false;
        for (MBeanOperationInfo op : oops) {
            if (!"reset".equals(op.getName())) continue;
            resetFound = true;
            break;
        }
        Assert.assertTrue((boolean)resetFound);
        Attribute attr = new Attribute("fooMetric", -77L);
        mbs.setAttribute(oname, attr);
        mBeanInfo = mbs.getMBeanInfo(oname);
        MBeanAttributeInfo[] attrinuteInfos = mBeanInfo.getAttributes();
        Assert.assertEquals((long)1L, (long)attrinuteInfos.length);
        boolean attrFound = false;
        for (MBeanAttributeInfo info : attrinuteInfos) {
            if (!"fooMetric".equals(info.getName())) continue;
            Assert.assertEquals((Object)"java.lang.Long", (Object)info.getType());
            Assert.assertTrue((boolean)info.isReadable());
            Assert.assertTrue((boolean)info.isWritable());
            Assert.assertFalse((boolean)info.isIs());
            attrFound = true;
            break;
        }
        Assert.assertTrue((boolean)attrFound);
        Object v = mbs.getAttribute(oname, "fooMetric");
        Assert.assertEquals((Object)-77L, (Object)v);
        Object result = mbs.invoke(oname, "reset", new Object[0], new String[0]);
        Assert.assertNull((Object)result);
        v = mbs.getAttribute(oname, "fooMetric");
        Assert.assertEquals((Object)0L, (Object)v);
    }

    private <T> void expectIOE(Callable<T> c) throws Exception {
        try {
            T t = c.call();
            Assert.fail((String)("IOE expected but [" + t + "] was returned."));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testScopeSingleThread() throws Exception {
        metrics.startStoredScope(scopeName);
        final LegacyMetrics.LegacyMetricsScope fooScope = (LegacyMetrics.LegacyMetricsScope)metrics.getStoredScope(scopeName);
        this.expectIOE(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long num = fooScope.getNumCounter();
                return num;
            }
        });
        this.expectIOE(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long time = fooScope.getTimeCounter();
                return time;
            }
        });
        this.expectIOE(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                fooScope.open();
                return null;
            }
        });
        Assert.assertSame((Object)fooScope, (Object)metrics.getStoredScope(scopeName));
        Thread.sleep(51L);
        metrics.endStoredScope(scopeName);
        this.expectIOE(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                metrics.endStoredScope(TestLegacyMetrics.scopeName);
                return null;
            }
        });
        Assert.assertEquals((Object)1L, (Object)fooScope.getNumCounter());
        long t1 = fooScope.getTimeCounter();
        Assert.assertTrue((t1 > 50L ? 1 : 0) != 0);
        Assert.assertSame((Object)fooScope, (Object)metrics.getStoredScope(scopeName));
        metrics.startStoredScope(scopeName);
        this.expectIOE(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                metrics.startStoredScope(TestLegacyMetrics.scopeName);
                return null;
            }
        });
        Assert.assertEquals((Object)1L, (Object)fooScope.getNumCounter());
        Assert.assertEquals((long)t1, (long)fooScope.getTimeCounter());
        Assert.assertSame((Object)fooScope, (Object)metrics.getStoredScope(scopeName));
        Thread.sleep(51L);
        fooScope.reopen();
        Assert.assertEquals((Object)2L, (Object)fooScope.getNumCounter());
        Assert.assertTrue((fooScope.getTimeCounter() > 100L ? 1 : 0) != 0);
        Thread.sleep(51L);
        fooScope.close();
        Assert.assertEquals((Object)3L, (Object)fooScope.getNumCounter());
        Assert.assertTrue((fooScope.getTimeCounter() > 150L ? 1 : 0) != 0);
        Double avgT = (Double)metrics.get("foo.avg_t");
        Assert.assertTrue((avgT > 50.0 ? 1 : 0) != 0);
    }

    @Test
    public void testScopeConcurrency() throws Exception {
        metrics.startStoredScope(scopeName);
        LegacyMetrics.LegacyMetricsScope fooScope = (LegacyMetrics.LegacyMetricsScope)metrics.getStoredScope(scopeName);
        int threads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        int i = 0;
        while (i < 10) {
            final int n = i++;
            executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TestLegacyMetrics.this.testScopeImpl(n);
                    return null;
                }
            });
        }
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(1500L, TimeUnit.MILLISECONDS));
        fooScope = (LegacyMetrics.LegacyMetricsScope)metrics.getStoredScope(scopeName);
        Assert.assertEquals((Object)30L, (Object)fooScope.getNumCounter());
        Assert.assertTrue((fooScope.getTimeCounter() > 1500L ? 1 : 0) != 0);
        Double avgT = (Double)metrics.get("foo.avg_t");
        Assert.assertTrue((avgT > 50.0 ? 1 : 0) != 0);
        metrics.endStoredScope(scopeName);
    }

    void testScopeImpl(int n) throws Exception {
        metrics.startStoredScope(scopeName);
        final LegacyMetrics.LegacyMetricsScope fooScope = (LegacyMetrics.LegacyMetricsScope)metrics.getStoredScope(scopeName);
        this.expectIOE(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                fooScope.open();
                return null;
            }
        });
        Assert.assertSame((Object)fooScope, (Object)metrics.getStoredScope(scopeName));
        Thread.sleep(51L);
        metrics.endStoredScope(scopeName);
        Assert.assertTrue((fooScope.getNumCounter() >= 1L ? 1 : 0) != 0);
        long t1 = fooScope.getTimeCounter();
        Assert.assertTrue((t1 > 50L ? 1 : 0) != 0);
        this.expectIOE(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                metrics.endStoredScope(TestLegacyMetrics.scopeName);
                return null;
            }
        });
        Assert.assertSame((Object)fooScope, (Object)metrics.getStoredScope(scopeName));
        metrics.startStoredScope(scopeName);
        Assert.assertTrue((fooScope.getNumCounter() >= 1L ? 1 : 0) != 0);
        Assert.assertTrue((fooScope.getTimeCounter() >= t1 ? 1 : 0) != 0);
        this.expectIOE(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                metrics.startStoredScope(TestLegacyMetrics.scopeName);
                return null;
            }
        });
        Assert.assertSame((Object)fooScope, (Object)metrics.getStoredScope(scopeName));
        Thread.sleep(51L);
        fooScope.reopen();
        Assert.assertTrue((fooScope.getNumCounter() >= 2L ? 1 : 0) != 0);
        Assert.assertTrue((fooScope.getTimeCounter() > 100L ? 1 : 0) != 0);
        Thread.sleep(51L);
        fooScope.close();
        Assert.assertTrue((fooScope.getNumCounter() >= 3L ? 1 : 0) != 0);
        Assert.assertTrue((fooScope.getTimeCounter() > 150L ? 1 : 0) != 0);
        Double avgT = (Double)metrics.get("foo.avg_t");
        Assert.assertTrue((avgT > 50.0 ? 1 : 0) != 0);
    }
}

