/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.junit.Test;

public class TestValidReadTxnList {
    @Test
    public void noExceptions() throws Exception {
        ValidReadTxnList txnList = new ValidReadTxnList(new long[0], 1L);
        String str = txnList.writeToString();
        Assert.assertEquals((String)"1:", (String)str);
        ValidReadTxnList newList = new ValidReadTxnList();
        newList.readFromString(str);
        Assert.assertTrue((boolean)newList.isTxnValid(1L));
        Assert.assertFalse((boolean)newList.isTxnValid(2L));
    }

    @Test
    public void exceptions() throws Exception {
        ValidReadTxnList txnList = new ValidReadTxnList(new long[]{2L, 4L}, 5L);
        String str = txnList.writeToString();
        Assert.assertEquals((String)"5:2:4", (String)str);
        ValidReadTxnList newList = new ValidReadTxnList();
        newList.readFromString(str);
        Assert.assertTrue((boolean)newList.isTxnValid(1L));
        Assert.assertFalse((boolean)newList.isTxnValid(2L));
        Assert.assertTrue((boolean)newList.isTxnValid(3L));
        Assert.assertFalse((boolean)newList.isTxnValid(4L));
        Assert.assertTrue((boolean)newList.isTxnValid(5L));
        Assert.assertFalse((boolean)newList.isTxnValid(6L));
    }

    @Test
    public void longEnoughToCompress() throws Exception {
        int i;
        long[] exceptions = new long[1000];
        for (int i2 = 0; i2 < 1000; ++i2) {
            exceptions[i2] = i2 + 100;
        }
        ValidReadTxnList txnList = new ValidReadTxnList(exceptions, 2000L);
        String str = txnList.writeToString();
        ValidReadTxnList newList = new ValidReadTxnList();
        newList.readFromString(str);
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)newList.isTxnValid((long)i));
        }
        for (i = 100; i < 1100; ++i) {
            Assert.assertFalse((boolean)newList.isTxnValid((long)i));
        }
        for (i = 1100; i < 2001; ++i) {
            Assert.assertTrue((boolean)newList.isTxnValid((long)i));
        }
        Assert.assertFalse((boolean)newList.isTxnValid(2001L));
    }

    @Test
    public void readWriteConfig() throws Exception {
        long[] exceptions = new long[1000];
        for (int i = 0; i < 1000; ++i) {
            exceptions[i] = i + 100;
        }
        ValidReadTxnList txnList = new ValidReadTxnList(exceptions, 2000L);
        String str = txnList.writeToString();
        Configuration conf = new Configuration();
        conf.set("hive.txn.valid.txns", str);
        File tmpFile = File.createTempFile("TestValidTxnImpl", "readWriteConfig");
        DataOutputStream out = new DataOutputStream(new FileOutputStream(tmpFile));
        conf.write((DataOutput)out);
        out.close();
        DataInputStream in = new DataInputStream(new FileInputStream(tmpFile));
        Configuration newConf = new Configuration();
        newConf.readFields((DataInput)in);
        Assert.assertEquals((String)str, (String)newConf.get("hive.txn.valid.txns"));
    }
}

