/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.util.Random;
import org.apache.hive.common.util.BloomFilter;
import org.junit.Assert;
import org.junit.Test;

public class TestBloomFilter {
    private static final int COUNT = 100;
    Random rand = new Random(123L);

    @Test(expected=IllegalArgumentException.class)
    public void testBloomIllegalArg1() {
        BloomFilter bf = new BloomFilter(0L, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomIllegalArg2() {
        BloomFilter bf = new BloomFilter(0L, 0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomIllegalArg3() {
        BloomFilter bf = new BloomFilter(1L, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomIllegalArg4() {
        BloomFilter bf = new BloomFilter(1L, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomIllegalArg5() {
        BloomFilter bf = new BloomFilter(-1L, -1.0);
    }

    @Test
    public void testBloomNumBits() {
        Assert.assertEquals((long)0L, (long)BloomFilter.optimalNumOfBits((long)0L, (double)0.0));
        Assert.assertEquals((long)0L, (long)BloomFilter.optimalNumOfBits((long)0L, (double)1.0));
        Assert.assertEquals((long)0L, (long)BloomFilter.optimalNumOfBits((long)1L, (double)1.0));
        Assert.assertEquals((long)7L, (long)BloomFilter.optimalNumOfBits((long)1L, (double)0.03));
        Assert.assertEquals((long)72L, (long)BloomFilter.optimalNumOfBits((long)10L, (double)0.03));
        Assert.assertEquals((long)729L, (long)BloomFilter.optimalNumOfBits((long)100L, (double)0.03));
        Assert.assertEquals((long)7298L, (long)BloomFilter.optimalNumOfBits((long)1000L, (double)0.03));
        Assert.assertEquals((long)72984L, (long)BloomFilter.optimalNumOfBits((long)10000L, (double)0.03));
        Assert.assertEquals((long)729844L, (long)BloomFilter.optimalNumOfBits((long)100000L, (double)0.03));
        Assert.assertEquals((long)7298440L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.03));
        Assert.assertEquals((long)6235224L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.05));
    }

    @Test
    public void testBloomNumHashFunctions() {
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)-1L, (long)-1L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)0L, (long)0L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)0L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)10L));
        Assert.assertEquals((long)7L, (long)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)100L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)1000L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)10000L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)100000L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)1000000L, (long)100L));
    }

    @Test
    public void testBloomFilterBytes() {
        BloomFilter bf = new BloomFilter(10000L);
        byte[] val = new byte[]{1, 2, 3};
        byte[] val1 = new byte[]{1, 2, 3, 4};
        byte[] val2 = new byte[]{1, 2, 3, 4, 5};
        byte[] val3 = new byte[]{1, 2, 3, 4, 5, 6};
        Assert.assertEquals((Object)false, (Object)bf.test(val));
        Assert.assertEquals((Object)false, (Object)bf.test(val1));
        Assert.assertEquals((Object)false, (Object)bf.test(val2));
        Assert.assertEquals((Object)false, (Object)bf.test(val3));
        bf.add(val);
        Assert.assertEquals((Object)true, (Object)bf.test(val));
        Assert.assertEquals((Object)false, (Object)bf.test(val1));
        Assert.assertEquals((Object)false, (Object)bf.test(val2));
        Assert.assertEquals((Object)false, (Object)bf.test(val3));
        bf.add(val1);
        Assert.assertEquals((Object)true, (Object)bf.test(val));
        Assert.assertEquals((Object)true, (Object)bf.test(val1));
        Assert.assertEquals((Object)false, (Object)bf.test(val2));
        Assert.assertEquals((Object)false, (Object)bf.test(val3));
        bf.add(val2);
        Assert.assertEquals((Object)true, (Object)bf.test(val));
        Assert.assertEquals((Object)true, (Object)bf.test(val1));
        Assert.assertEquals((Object)true, (Object)bf.test(val2));
        Assert.assertEquals((Object)false, (Object)bf.test(val3));
        bf.add(val3);
        Assert.assertEquals((Object)true, (Object)bf.test(val));
        Assert.assertEquals((Object)true, (Object)bf.test(val1));
        Assert.assertEquals((Object)true, (Object)bf.test(val2));
        Assert.assertEquals((Object)true, (Object)bf.test(val3));
        byte[] randVal = new byte[100];
        for (int i = 0; i < 100; ++i) {
            this.rand.nextBytes(randVal);
            bf.add(randVal);
        }
        Assert.assertEquals((Object)true, (Object)bf.test(randVal));
        randVal[0] = 0;
        randVal[1] = 0;
        randVal[2] = 0;
        randVal[3] = 0;
        randVal[4] = 0;
        Assert.assertEquals((Object)false, (Object)bf.test(randVal));
        Assert.assertEquals((long)7800L, (long)bf.sizeInBytes());
    }

    @Test
    public void testBloomFilterByte() {
        BloomFilter bf = new BloomFilter(10000L);
        int val = -128;
        int val1 = 1;
        int val2 = 2;
        int val3 = 127;
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val1);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val2);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val3);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val3));
        int randVal = 0;
        for (int i = 0; i < 100; ++i) {
            randVal = (byte)this.rand.nextInt(127);
            bf.addLong((long)randVal);
        }
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)randVal));
        Assert.assertEquals((Object)false, (Object)bf.testLong(-120L));
        Assert.assertEquals((long)7800L, (long)bf.sizeInBytes());
    }

    @Test
    public void testBloomFilterInt() {
        BloomFilter bf = new BloomFilter(10000L);
        int val = Integer.MIN_VALUE;
        int val1 = 1;
        int val2 = 2;
        int val3 = Integer.MAX_VALUE;
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val1);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val2);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong((long)val3));
        bf.addLong((long)val3);
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val1));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val2));
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)val3));
        int randVal = 0;
        for (int i = 0; i < 100; ++i) {
            randVal = this.rand.nextInt();
            bf.addLong((long)randVal);
        }
        Assert.assertEquals((Object)true, (Object)bf.testLong((long)randVal));
        Assert.assertEquals((Object)false, (Object)bf.testLong(-120L));
        Assert.assertEquals((long)7800L, (long)bf.sizeInBytes());
    }

    @Test
    public void testBloomFilterLong() {
        BloomFilter bf = new BloomFilter(10000L);
        long val = Long.MIN_VALUE;
        long val1 = 1L;
        long val2 = 2L;
        long val3 = Long.MAX_VALUE;
        Assert.assertEquals((Object)false, (Object)bf.testLong(val));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val3));
        bf.addLong(val);
        Assert.assertEquals((Object)true, (Object)bf.testLong(val));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val3));
        bf.addLong(val1);
        Assert.assertEquals((Object)true, (Object)bf.testLong(val));
        Assert.assertEquals((Object)true, (Object)bf.testLong(val1));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val3));
        bf.addLong(val2);
        Assert.assertEquals((Object)true, (Object)bf.testLong(val));
        Assert.assertEquals((Object)true, (Object)bf.testLong(val1));
        Assert.assertEquals((Object)true, (Object)bf.testLong(val2));
        Assert.assertEquals((Object)false, (Object)bf.testLong(val3));
        bf.addLong(val3);
        Assert.assertEquals((Object)true, (Object)bf.testLong(val));
        Assert.assertEquals((Object)true, (Object)bf.testLong(val1));
        Assert.assertEquals((Object)true, (Object)bf.testLong(val2));
        Assert.assertEquals((Object)true, (Object)bf.testLong(val3));
        long randVal = 0L;
        for (int i = 0; i < 100; ++i) {
            randVal = this.rand.nextLong();
            bf.addLong(randVal);
        }
        Assert.assertEquals((Object)true, (Object)bf.testLong(randVal));
        Assert.assertEquals((Object)false, (Object)bf.testLong(-120L));
        Assert.assertEquals((long)7800L, (long)bf.sizeInBytes());
    }

    @Test
    public void testBloomFilterFloat() {
        BloomFilter bf = new BloomFilter(10000L);
        float val = Float.MIN_VALUE;
        float val1 = 1.1f;
        float val2 = 2.2f;
        float val3 = Float.MAX_VALUE;
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val1));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val3));
        bf.addDouble((double)val);
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val1));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val3));
        bf.addDouble((double)val1);
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val));
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val1));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val3));
        bf.addDouble((double)val2);
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val));
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val1));
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)val3));
        bf.addDouble((double)val3);
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val));
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val1));
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val2));
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)val3));
        float randVal = 0.0f;
        for (int i = 0; i < 100; ++i) {
            randVal = this.rand.nextFloat();
            bf.addDouble((double)randVal);
        }
        Assert.assertEquals((Object)true, (Object)bf.testDouble((double)randVal));
        Assert.assertEquals((Object)false, (Object)bf.testDouble((double)-120.2f));
        Assert.assertEquals((long)7800L, (long)bf.sizeInBytes());
    }

    @Test
    public void testBloomFilterDouble() {
        BloomFilter bf = new BloomFilter(10000L);
        double val = Double.MIN_VALUE;
        double val1 = 1.1;
        double val2 = 2.2;
        double val3 = Double.MAX_VALUE;
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val1));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val3));
        bf.addDouble(val);
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val1));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val3));
        bf.addDouble(val1);
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val));
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val1));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val3));
        bf.addDouble(val2);
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val));
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val1));
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val2));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(val3));
        bf.addDouble(val3);
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val));
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val1));
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val2));
        Assert.assertEquals((Object)true, (Object)bf.testDouble(val3));
        double randVal = 0.0;
        for (int i = 0; i < 100; ++i) {
            randVal = this.rand.nextDouble();
            bf.addDouble(randVal);
        }
        Assert.assertEquals((Object)true, (Object)bf.testDouble(randVal));
        Assert.assertEquals((Object)false, (Object)bf.testDouble(-120.2));
        Assert.assertEquals((long)7800L, (long)bf.sizeInBytes());
    }

    @Test
    public void testBloomFilterString() {
        BloomFilter bf = new BloomFilter(100000L);
        String val = "bloo";
        String val1 = "bloom fil";
        String val2 = "bloom filter";
        String val3 = "cuckoo filter";
        Assert.assertEquals((Object)false, (Object)bf.testString(val));
        Assert.assertEquals((Object)false, (Object)bf.testString(val1));
        Assert.assertEquals((Object)false, (Object)bf.testString(val2));
        Assert.assertEquals((Object)false, (Object)bf.testString(val3));
        bf.addString(val);
        Assert.assertEquals((Object)true, (Object)bf.testString(val));
        Assert.assertEquals((Object)false, (Object)bf.testString(val1));
        Assert.assertEquals((Object)false, (Object)bf.testString(val2));
        Assert.assertEquals((Object)false, (Object)bf.testString(val3));
        bf.addString(val1);
        Assert.assertEquals((Object)true, (Object)bf.testString(val));
        Assert.assertEquals((Object)true, (Object)bf.testString(val1));
        Assert.assertEquals((Object)false, (Object)bf.testString(val2));
        Assert.assertEquals((Object)false, (Object)bf.testString(val3));
        bf.addString(val2);
        Assert.assertEquals((Object)true, (Object)bf.testString(val));
        Assert.assertEquals((Object)true, (Object)bf.testString(val1));
        Assert.assertEquals((Object)true, (Object)bf.testString(val2));
        Assert.assertEquals((Object)false, (Object)bf.testString(val3));
        bf.addString(val3);
        Assert.assertEquals((Object)true, (Object)bf.testString(val));
        Assert.assertEquals((Object)true, (Object)bf.testString(val1));
        Assert.assertEquals((Object)true, (Object)bf.testString(val2));
        Assert.assertEquals((Object)true, (Object)bf.testString(val3));
        long randVal = 0L;
        for (int i = 0; i < 100; ++i) {
            randVal = this.rand.nextLong();
            bf.addString(Long.toString(randVal));
        }
        Assert.assertEquals((Object)true, (Object)bf.testString(Long.toString(randVal)));
        Assert.assertEquals((Object)false, (Object)bf.testString(Long.toString(-120L)));
        Assert.assertEquals((long)77944L, (long)bf.sizeInBytes());
    }

    @Test
    public void testMerge() {
        BloomFilter bf = new BloomFilter(10000L);
        String val = "bloo";
        String val1 = "bloom fil";
        String val2 = "bloom filter";
        String val3 = "cuckoo filter";
        bf.addString(val);
        bf.addString(val1);
        bf.addString(val2);
        bf.addString(val3);
        BloomFilter bf2 = new BloomFilter(10000L);
        String v = "2_bloo";
        String v1 = "2_bloom fil";
        String v2 = "2_bloom filter";
        String v3 = "2_cuckoo filter";
        bf2.addString(v);
        bf2.addString(v1);
        bf2.addString(v2);
        bf2.addString(v3);
        Assert.assertEquals((Object)true, (Object)bf.testString(val));
        Assert.assertEquals((Object)true, (Object)bf.testString(val1));
        Assert.assertEquals((Object)true, (Object)bf.testString(val2));
        Assert.assertEquals((Object)true, (Object)bf.testString(val3));
        Assert.assertEquals((Object)false, (Object)bf.testString(v));
        Assert.assertEquals((Object)false, (Object)bf.testString(v1));
        Assert.assertEquals((Object)false, (Object)bf.testString(v2));
        Assert.assertEquals((Object)false, (Object)bf.testString(v3));
        bf.merge(bf2);
        Assert.assertEquals((Object)true, (Object)bf.testString(val));
        Assert.assertEquals((Object)true, (Object)bf.testString(val1));
        Assert.assertEquals((Object)true, (Object)bf.testString(val2));
        Assert.assertEquals((Object)true, (Object)bf.testString(val3));
        Assert.assertEquals((Object)true, (Object)bf.testString(v));
        Assert.assertEquals((Object)true, (Object)bf.testString(v1));
        Assert.assertEquals((Object)true, (Object)bf.testString(v2));
        Assert.assertEquals((Object)true, (Object)bf.testString(v3));
    }
}

