/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.Assert;

public class MetricsTestUtils {
    public static final MetricsCategory COUNTER = new MetricsCategory("counters", "count");
    public static final MetricsCategory TIMER = new MetricsCategory("timers", "count");
    public static final MetricsCategory GAUGE = new MetricsCategory("gauges", "value");

    public static void verifyMetricFile(File jsonReportFile, MetricsCategory category, String metricsName, Object value) throws Exception {
        JsonNode jsonNode = MetricsTestUtils.getJsonNode(jsonReportFile, category, metricsName);
        Assert.assertEquals((Object)jsonNode.asText(), (Object)value.toString());
    }

    private static JsonNode getJsonNode(File jsonReportFile, MetricsCategory category, String metricsName) throws Exception {
        byte[] jsonData = Files.readAllBytes(Paths.get(jsonReportFile.getAbsolutePath(), new String[0]));
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(jsonData);
        JsonNode categoryNode = rootNode.path(category.category);
        JsonNode metricsNode = categoryNode.path(metricsName);
        return metricsNode.path(category.metricsHandle);
    }

    static class MetricsCategory {
        String category;
        String metricsHandle;

        MetricsCategory(String category, String metricsHandle) {
            this.category = category;
            this.metricsHandle = metricsHandle;
        }
    }
}

