/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hive.common.util.ShutdownHookManager;
import org.junit.Assert;
import org.junit.Test;

public class TestShutdownHookManager {
    @Test
    public void shutdownHookManager() {
        Assert.assertEquals((long)1L, (long)ShutdownHookManager.getShutdownHooksInOrder().size());
        Runnable hook1 = new Runnable(){

            @Override
            public void run() {
            }
        };
        Runnable hook2 = new Runnable(){

            @Override
            public void run() {
            }
        };
        ShutdownHookManager.addShutdownHook((Runnable)hook1, (int)0);
        Assert.assertTrue((boolean)ShutdownHookManager.hasShutdownHook((Runnable)hook1));
        Assert.assertEquals((long)2L, (long)ShutdownHookManager.getShutdownHooksInOrder().size());
        Assert.assertEquals((Object)hook1, ShutdownHookManager.getShutdownHooksInOrder().get(0));
        ShutdownHookManager.removeShutdownHook((Runnable)hook1);
        Assert.assertFalse((boolean)ShutdownHookManager.hasShutdownHook((Runnable)hook1));
        ShutdownHookManager.addShutdownHook((Runnable)hook1, (int)0);
        Assert.assertTrue((boolean)ShutdownHookManager.hasShutdownHook((Runnable)hook1));
        Assert.assertEquals((long)2L, (long)ShutdownHookManager.getShutdownHooksInOrder().size());
        Assert.assertTrue((boolean)ShutdownHookManager.hasShutdownHook((Runnable)hook1));
        Assert.assertEquals((long)2L, (long)ShutdownHookManager.getShutdownHooksInOrder().size());
        ShutdownHookManager.addShutdownHook((Runnable)hook2, (int)1);
        Assert.assertTrue((boolean)ShutdownHookManager.hasShutdownHook((Runnable)hook1));
        Assert.assertTrue((boolean)ShutdownHookManager.hasShutdownHook((Runnable)hook2));
        Assert.assertEquals((long)3L, (long)ShutdownHookManager.getShutdownHooksInOrder().size());
        Assert.assertEquals((Object)hook2, ShutdownHookManager.getShutdownHooksInOrder().get(0));
        Assert.assertEquals((Object)hook1, ShutdownHookManager.getShutdownHooksInOrder().get(1));
    }

    @Test
    public void deleteOnExit() throws IOException {
        File file = FileUtils.createTempFile(null, (String)"tmp", null);
        Assert.assertTrue((boolean)ShutdownHookManager.isRegisteredToDeleteOnExit((File)file));
        FileUtils.deleteTmpFile((File)file);
        Assert.assertFalse((boolean)ShutdownHookManager.isRegisteredToDeleteOnExit((File)file));
    }
}

