/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import org.apache.helix.EspressoStorageMockNode;
import org.apache.helix.MockNode;
import org.apache.log4j.Logger;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;

public class StopServiceResource
extends Resource {
    private static final Logger logger = Logger.getLogger(StopServiceResource.class);
    Context _context;

    public StopServiceResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this._context = context;
    }

    public boolean allowGet() {
        System.out.println("PutResource.allowGet()");
        return true;
    }

    public boolean allowPost() {
        System.out.println("PutResource.allowPost()");
        return false;
    }

    public boolean allowPut() {
        System.out.println("PutResource.allowPut()");
        return false;
    }

    public boolean allowDelete() {
        return false;
    }

    public Representation represent(Variant variant) {
        System.out.println("StopServiceResource.represent()");
        StringRepresentation presentation = null;
        try {
            logger.debug((Object)"in represent, stopping service");
            Component component = (Component)this._context.getAttributes().get("component");
            EspressoStorageMockNode mock = (EspressoStorageMockNode)this._context.getAttributes().get("mocknode");
            presentation = new StringRepresentation((CharSequence)"Stopping in 1 second", MediaType.APPLICATION_JSON);
            Thread stopper = new Thread(new StopThread(component, mock));
            stopper.start();
        }
        catch (Exception e) {
            String error = "Error shutting down";
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            e.printStackTrace();
        }
        return presentation;
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
    }

    class StopThread
    implements Runnable {
        Component _component;
        MockNode _mockNode;

        StopThread(Component c, MockNode m) {
            this._component = c;
            this._mockNode = m;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                this._component.stop();
                this._mockNode.disconnect();
                System.exit(0);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to stop service: " + e));
                e.printStackTrace();
            }
        }
    }
}

