/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.CMConnector;
import org.apache.helix.EspressoResource;
import org.apache.helix.EspressoStorageMockNode;
import org.apache.helix.MockNodeFactory;
import org.apache.helix.StopServiceResource;
import org.apache.log4j.Logger;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class MockEspressoService
extends Application {
    private static final Logger logger = Logger.getLogger(MockEspressoService.class);
    public static final String HELP = "help";
    public static final String CLUSTERNAME = "clusterName";
    public static final String INSTANCENAME = "instanceName";
    public static final String ZKSERVERADDRESS = "zkSvr";
    public static final String PORT = "port";
    public static final int DEFAULT_PORT = 8100;
    protected static final String NODE_TYPE = "EspressoStorage";
    public static final String DATABASENAME = "database";
    public static final String TABLENAME = "table";
    public static final String RESOURCENAME = "resource";
    public static final String SUBRESOURCENAME = "subresource";
    public static final String STOPSERVICECOMMAND = "stopservice";
    public static final String CONTEXT_MOCK_NODE_NAME = "mocknode";
    public static final String COMPONENT_NAME = "component";
    Context _applicationContext;
    static int _serverPort;
    static String _zkAddr;
    static String _instanceName;
    static String _clusterName;
    public CMConnector _connector = null;
    public EspressoStorageMockNode _mockNode;
    static Context _context;
    static Component _component;

    public MockEspressoService(Context context) {
        super(_context);
        try {
            this._connector = new CMConnector(_clusterName, _instanceName, _zkAddr);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to initialize CMConnector: " + e));
            e.printStackTrace();
            System.exit(-1);
        }
        this._mockNode = (EspressoStorageMockNode)MockNodeFactory.createMockNode(NODE_TYPE, this._connector);
        context.getAttributes().put(CONTEXT_MOCK_NODE_NAME, this._mockNode);
    }

    public Restlet createRoot() {
        Router router = new Router(_context);
        Restlet mainpage = new Restlet(){

            public void handle(Request request, Response response) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                stringBuilder.append("<head><title>Restlet Cluster Management page</title></head>");
                stringBuilder.append("<body bgcolor=white>");
                stringBuilder.append("<table border=\"0\">");
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>");
                stringBuilder.append("<h1>Rest cluster management interface V1</h1>");
                stringBuilder.append("</td>");
                stringBuilder.append("</tr>");
                stringBuilder.append("</table>");
                stringBuilder.append("</body>");
                stringBuilder.append("</html>");
                response.setEntity((Representation)new StringRepresentation((CharSequence)stringBuilder.toString(), MediaType.TEXT_HTML));
            }
        };
        if (this._mockNode == null) {
            logger.debug((Object)"_mockNode in createRoot is null");
        }
        router.attach("", mainpage);
        router.attach("/{database}/{table}/{resource}", EspressoResource.class);
        router.attach("/{database}/{table}/{resource}/{subresource}", EspressoResource.class);
        router.attach("/{stopservice}", StopServiceResource.class);
        return router;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + MockEspressoService.class.getName(), cliOptions);
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)HELP);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        helpOption.setArgs(0);
        helpOption.setRequired(false);
        helpOption.setArgName("print help message");
        OptionBuilder.withLongOpt((String)ZKSERVERADDRESS);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)CLUSTERNAME);
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        clusterOption.setArgs(1);
        clusterOption.setRequired(true);
        clusterOption.setArgName("Cluster name(Required)");
        OptionBuilder.withLongOpt((String)INSTANCENAME);
        OptionBuilder.withDescription((String)"Provide name for this instance");
        Option instanceOption = OptionBuilder.create();
        instanceOption.setArgs(1);
        instanceOption.setRequired(false);
        instanceOption.setArgName("Instance name(Optional, defaults to localhost)");
        OptionBuilder.withLongOpt((String)PORT);
        OptionBuilder.withDescription((String)"Provide web service port");
        Option portOption = OptionBuilder.create();
        portOption.setArgs(1);
        portOption.setRequired(false);
        portOption.setArgName("web service port, default: 8100");
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkServerOption);
        options.addOption(clusterOption);
        options.addOption(instanceOption);
        options.addOption(portOption);
        return options;
    }

    public static void processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = MockEspressoService.constructCommandLineOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("MockEspressoService: failed to parse command-line options: " + pe.toString());
            MockEspressoService.printUsage(cliOptions);
            System.exit(1);
        }
        _serverPort = 8100;
        if (cmd.hasOption(HELP)) {
            MockEspressoService.printUsage(cliOptions);
            return;
        }
        if (cmd.hasOption(PORT)) {
            _serverPort = Integer.parseInt(cmd.getOptionValue(PORT));
        }
        if (cmd.hasOption(ZKSERVERADDRESS)) {
            _zkAddr = cmd.getOptionValue(ZKSERVERADDRESS);
        }
        if (cmd.hasOption(CLUSTERNAME)) {
            _clusterName = cmd.getOptionValue(CLUSTERNAME);
            logger.debug((Object)("_clusterName: " + _clusterName));
        }
        if (cmd.hasOption(INSTANCENAME)) {
            _instanceName = cmd.getOptionValue(INSTANCENAME);
            _instanceName = _instanceName.replace(':', '_');
            logger.debug((Object)("_instanceName: " + _instanceName));
        }
    }

    public void run() throws Exception {
        logger.debug((Object)"Start of mock service run");
        if (this._mockNode == null) {
            logger.debug((Object)"_mockNode null");
        } else {
            logger.debug((Object)"_mockNode not null");
        }
        if (this._mockNode != null) {
            _component = new Component();
            _component.getServers().add(Protocol.HTTP, _serverPort);
            _component.getDefaultHost().attach((Restlet)this);
            _context.getAttributes().put(COMPONENT_NAME, _component);
            _component.start();
        } else {
            logger.error((Object)"Unknown MockNode type EspressoStorage");
            System.exit(-1);
        }
        logger.debug((Object)"mock service done");
    }

    public static void main(String[] args) throws Exception {
        MockEspressoService.processCommandLineArgs(args);
        _context = new Context();
        MockEspressoService service = new MockEspressoService(_context);
        service.run();
    }

    static {
        _zkAddr = "localhost:9999";
        _instanceName = "localhost";
        _clusterName = "";
    }
}

