/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.nio.ByteBuffer;
import org.apache.helix.HashFunction;

public class FnvHashFunction
implements HashFunction {
    private static final long FNV_BASIS = -2128831035L;
    private static final long FNV_PRIME = 16777619L;

    @Override
    public long hash(ByteBuffer buf) {
        int length = buf.position() + buf.remaining();
        return this.hash(buf, 0, length);
    }

    @Override
    public long hash(ByteBuffer buf, int off, int len) {
        long hash = -2128831035L;
        int last = Math.min(off + len, buf.position() + buf.remaining());
        for (int i = off; i < last; ++i) {
            hash ^= (long)(0xFF & buf.get(i));
            hash *= 16777619L;
        }
        return hash;
    }

    public long hash(byte[] key) {
        long hash = -2128831035L;
        for (int i = 0; i < key.length; ++i) {
            hash ^= (long)(0xFF & key[i]);
            hash *= 16777619L;
        }
        return hash;
    }

    @Override
    public long hash(byte[] key, int numBuckets) {
        return this.hash(key) % (long)numBuckets;
    }

    private long hash(long val) {
        long hashval = -2128831035L;
        for (int i = 0; i < 8; ++i) {
            long octet = val & 0xFFL;
            val >>= 8;
            hashval ^= octet;
            hashval *= 16777619L;
        }
        return (int)hashval;
    }

    @Override
    public long hash(long val, int numBuckets) {
        return this.hash(val) % (long)numBuckets;
    }
}

