/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;

public class EspressoStorageMockStateModelFactory
extends StateModelFactory<StateModel> {
    int _delay;

    public EspressoStorageMockStateModelFactory(int delay) {
        this._delay = delay;
    }

    public StateModel createNewStateModel(String stateUnitKey) {
        EspressoStorageMockStateModel stateModel = new EspressoStorageMockStateModel();
        stateModel.setDelay(this._delay);
        stateModel.setStateUnitKey(stateUnitKey);
        return stateModel;
    }

    public static class EspressoStorageMockStateModel
    extends StateModel {
        int _transDelay = 0;
        String stateUnitKey;

        public String getStateUnitKey() {
            return this.stateUnitKey;
        }

        public void setStateUnitKey(String stateUnitKey) {
            this.stateUnitKey = stateUnitKey;
        }

        public void setDelay(int delay) {
            this._transDelay = delay > 0 ? delay : 0;
        }

        public void onBecomeSlaveFromOffline(Message message, NotificationContext context) {
            System.out.println("EspressoStorageMockStateModel.onBecomeSlaveFromOffline() for " + this.stateUnitKey);
            this.sleep();
        }

        private void sleep() {
            try {
                Thread.sleep(this._transDelay);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onBecomeSlaveFromMaster(Message message, NotificationContext context) {
            System.out.println("EspressoStorageMockStateModel.onBecomeSlaveFromMaster() for " + this.stateUnitKey);
            this.sleep();
        }

        public void onBecomeMasterFromSlave(Message message, NotificationContext context) {
            System.out.println("EspressoStorageMockStateModel.onBecomeMasterFromSlave() for " + this.stateUnitKey);
            this.sleep();
        }

        public void onBecomeOfflineFromSlave(Message message, NotificationContext context) {
            System.out.println("EspressoStorageMockStateModel.onBecomeOfflineFromSlave() for " + this.stateUnitKey);
            this.sleep();
        }

        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            System.out.println("ObBecomeDroppedFromOffline() for " + this.stateUnitKey);
            this.sleep();
        }
    }
}

