/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.CMConnector;
import org.apache.helix.EspressoStorageMockStateModelFactory;
import org.apache.helix.FnvHashFunction;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.MockNode;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.healthcheck.HealthReportProvider;
import org.apache.helix.healthcheck.StatHealthReportProvider;
import org.apache.helix.model.IdealState;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.log4j.Logger;

public class EspressoStorageMockNode
extends MockNode {
    private static final Logger logger = Logger.getLogger(EspressoStorageMockNode.class);
    private final String GET_STAT_NAME = "get";
    private final String SET_STAT_NAME = "set";
    private final String COUNT_STAT_TYPE = "count";
    private final String REPORT_NAME = "ParticipantStats";
    StatHealthReportProvider _healthProvider;
    EspressoStorageMockStateModelFactory _stateModelFactory = new EspressoStorageMockStateModelFactory(0);
    HashSet<String> _partitions;
    ConcurrentHashMap<String, String> _keyValueMap;
    FnvHashFunction _hashFunction;
    int _numTotalEspressoPartitions = 0;

    public EspressoStorageMockNode(CMConnector cm) {
        super(cm);
        StateMachineEngine stateMach = this._cmConnector.getManager().getStateMachineEngine();
        stateMach.registerStateModelFactory("MasterSlave", (StateModelFactory)this._stateModelFactory);
        this._healthProvider = new StatHealthReportProvider();
        this._cmConnector.getManager().getHealthReportCollector().addHealthReportProvider((HealthReportProvider)this._healthProvider);
        this._partitions = new HashSet();
        this._keyValueMap = new ConcurrentHashMap();
        this._hashFunction = new FnvHashFunction();
    }

    public String formStatName(String dbName, String partitionName, String metricName) {
        String statName = "db" + dbName + ".partition" + partitionName + "." + metricName;
        return statName;
    }

    public String doGet(String dbId, String key) {
        String partition = this.getPartitionName(dbId, this.getKeyPartition(dbId, key));
        if (!this.isPartitionOwnedByNode(partition)) {
            logger.error((Object)("Key " + key + " hashed to partition " + partition + " but this node does not own it."));
            return null;
        }
        this._healthProvider.incrementStat(this.formStatName(dbId, partition, "getCount"), String.valueOf(System.currentTimeMillis()));
        return this._keyValueMap.get(key);
    }

    public void doPut(String dbId, String key, String value) {
        String partition = this.getPartitionName(dbId, this.getKeyPartition(dbId, key));
        if (!this.isPartitionOwnedByNode(partition)) {
            logger.error((Object)("Key " + key + " hashed to partition " + partition + " but this node does not own it."));
            return;
        }
        this._healthProvider.incrementStat(this.formStatName(dbId, partition, "putCount"), String.valueOf(System.currentTimeMillis()));
        this._keyValueMap.put(key, value);
    }

    private String getPartitionName(String databaseName, int partitionNum) {
        return databaseName + "_" + partitionNum;
    }

    private boolean isPartitionOwnedByNode(String partitionName) {
        Map stateModelMap = this._stateModelFactory.getStateModelMap();
        logger.debug((Object)("state model map size: " + stateModelMap.size()));
        return stateModelMap.keySet().contains(partitionName);
    }

    private int getKeyPartition(String dbName, String key) {
        int numPartitions = this.getNumPartitions(dbName);
        logger.debug((Object)("numPartitions: " + numPartitions));
        int part = Math.abs((int)this._hashFunction.hash(key.getBytes(), numPartitions));
        logger.debug((Object)("part: " + part));
        return part;
    }

    private int getNumPartitions(String dbName) {
        logger.debug((Object)("dbName: " + dbName));
        HelixDataAccessor helixDataAccessor = this._cmConnector.getManager().getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = helixDataAccessor.keyBuilder();
        ZNRecord rec = helixDataAccessor.getProperty(keyBuilder.idealStates(dbName)).getRecord();
        if (rec == null) {
            logger.debug((Object)"rec is null");
        }
        IdealState state = new IdealState(rec);
        return state.getNumPartitions();
    }

    @Override
    public void run() {
    }

    class PartitionGetterThread
    implements Runnable {
        PartitionGetterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                HashSet<String> hashSet = EspressoStorageMockNode.this._partitions;
                synchronized (hashSet) {
                    EspressoStorageMockNode.this._partitions.clear();
                    Map stateModelMap = EspressoStorageMockNode.this._stateModelFactory.getStateModelMap();
                    for (String s : stateModelMap.keySet()) {
                        logger.debug((Object)("adding key " + s));
                        EspressoStorageMockNode.this._partitions.add(s);
                    }
                }
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

