/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.helix.EspressoStorageMockNode;
import org.apache.log4j.Logger;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;

public class EspressoResource
extends Resource {
    private static final int POST_BODY_BUFFER_SIZE = 10240;
    private static final Logger logger = Logger.getLogger(EspressoResource.class);
    Context _context;

    public EspressoResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this._context = context;
    }

    public boolean allowGet() {
        System.out.println("PutResource.allowGet()");
        return true;
    }

    public boolean allowPost() {
        System.out.println("PutResource.allowPost()");
        return true;
    }

    public boolean allowPut() {
        System.out.println("PutResource.allowPut()");
        return true;
    }

    public boolean allowDelete() {
        return false;
    }

    public Representation represent(Variant variant) {
        StringRepresentation presentation = null;
        try {
            String databaseId = (String)this.getRequest().getAttributes().get("database");
            String tableId = (String)this.getRequest().getAttributes().get("table");
            String resourceId = (String)this.getRequest().getAttributes().get("resource");
            String subResourceId = (String)this.getRequest().getAttributes().get("subresource");
            logger.debug((Object)"Done getting request components");
            logger.debug((Object)("method: " + this.getRequest().getMethod()));
            String composedKey = databaseId + tableId + resourceId;
            EspressoStorageMockNode mock = (EspressoStorageMockNode)this._context.getAttributes().get("mocknode");
            if (this.getRequest().getMethod() == Method.PUT) {
                logger.debug((Object)"processing PUT");
                char[] postBody = new char[10240];
                Reader postBodyReader = this.getRequest().getEntity().getReader();
                postBodyReader.read(postBody);
                logger.debug((Object)("postBody: " + new String(postBody)));
                mock.doPut(databaseId, composedKey, new String(postBody));
                presentation = new StringRepresentation((CharSequence)"Put succeeded", MediaType.APPLICATION_JSON);
            } else if (this.getRequest().getMethod() == Method.GET) {
                logger.debug((Object)"processing GET");
                String result = mock.doGet(databaseId, composedKey);
                logger.debug((Object)("result: " + result));
                if (result == null) {
                    presentation = new StringRepresentation((CharSequence)"Record not found", MediaType.APPLICATION_JSON);
                    this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Record not found");
                } else {
                    this.getResponse().setStatus(Status.SUCCESS_OK, "Success");
                    presentation = new StringRepresentation((CharSequence)result, MediaType.APPLICATION_JSON);
                }
            }
        }
        catch (IOException e) {
            presentation = new StringRepresentation((CharSequence)e.getMessage(), MediaType.APPLICATION_JSON);
            e.printStackTrace();
        }
        catch (Exception e) {
            String error = "Error with op";
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            e.printStackTrace();
        }
        return presentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRepresentation(Representation entity) throws ResourceException {
        logger.debug((Object)"in storeRepresentation");
        StringRepresentation presentation = null;
        Form requestHeaders = (Form)this.getRequest().getAttributes().get("org.restlet.http.headers");
        Map headerMap = requestHeaders.getValuesMap();
        logger.debug((Object)"HEADERS MAP");
        for (String key : headerMap.keySet()) {
            logger.debug((Object)(key + " : " + (String)headerMap.get(key)));
        }
        try {
            logger.debug((Object)"in PutResource handle");
            String databaseId = (String)this.getRequest().getAttributes().get("database");
            String tableId = (String)this.getRequest().getAttributes().get("table");
            String resourceId = (String)this.getRequest().getAttributes().get("resource");
            String subResourceId = (String)this.getRequest().getAttributes().get("subresource");
            logger.debug((Object)"Done getting request components");
            logger.debug((Object)("method: " + this.getRequest().getMethod()));
            String composedKey = databaseId + tableId + resourceId;
            EspressoStorageMockNode mock = (EspressoStorageMockNode)this._context.getAttributes().get("mocknode");
            if (this.getRequest().getMethod() == Method.PUT) {
                logger.debug((Object)"processing PUT");
                char[] postBody = new char[10240];
                Reader postBodyReader = this.getRequest().getEntity().getReader();
                postBodyReader.read(postBody);
                logger.debug((Object)("postBody: " + new String(postBody)));
                mock.doPut(databaseId, composedKey, new String(postBody));
                presentation = new StringRepresentation((CharSequence)"Put succeeded", MediaType.APPLICATION_JSON);
            } else if (this.getRequest().getMethod() == Method.GET) {
                logger.debug((Object)"Processing GET");
                String result = mock.doGet(databaseId, composedKey);
                logger.debug((Object)("result: " + result));
                presentation = result == null ? new StringRepresentation((CharSequence)"Record not found", MediaType.APPLICATION_JSON) : new StringRepresentation((CharSequence)result, MediaType.APPLICATION_JSON);
            }
        }
        catch (IOException e) {
            presentation = new StringRepresentation((CharSequence)e.getMessage(), MediaType.APPLICATION_JSON);
            e.printStackTrace();
        }
        catch (Exception e) {
            String error = "Error with op";
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            e.printStackTrace();
        }
        finally {
            entity.release();
        }
    }
}

