/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.metric;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.MBeanRegistrar;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.apache.helix.monitoring.mbeans.exception.MetricException;
import org.apache.helix.zookeeper.zkclient.ZkEventThread;
import org.apache.helix.zookeeper.zkclient.metric.ZkClientPathMonitor;

public class ZkClientMonitor
extends DynamicMBeanProvider {
    public static final String MONITOR_TYPE = "Type";
    public static final String MONITOR_KEY = "Key";
    protected static final String MBEAN_DESCRIPTION = "Helix Zookeeper Client Monitor";
    private String _sensorName;
    private String _monitorType;
    private String _monitorKey;
    private String _monitorInstanceName;
    private boolean _monitorRootOnly;
    private SimpleDynamicMetric<Long> _stateChangeEventCounter;
    private SimpleDynamicMetric<Long> _dataChangeEventCounter;
    private SimpleDynamicMetric<Long> _outstandingRequestGauge;
    private ZkThreadMetric _zkEventThreadMetric;
    private Map<ZkClientPathMonitor.PredefinedPath, ZkClientPathMonitor> _zkClientPathMonitorMap = new ConcurrentHashMap<ZkClientPathMonitor.PredefinedPath, ZkClientPathMonitor>();

    public ZkClientMonitor(String monitorType, String monitorKey, String monitorInstanceName, boolean monitorRootOnly, ZkEventThread zkEventThread) {
        if (monitorKey == null || monitorKey.isEmpty() || monitorType == null || monitorType.isEmpty()) {
            throw new MetricException("Cannot create ZkClientMonitor without monitor key and type.");
        }
        this._sensorName = String.format("%s.%s.%s", MonitorDomainNames.HelixZkClient.name(), monitorType, monitorKey);
        this._monitorType = monitorType;
        this._monitorKey = monitorKey;
        this._monitorInstanceName = monitorInstanceName;
        this._monitorRootOnly = monitorRootOnly;
        this._stateChangeEventCounter = new SimpleDynamicMetric<Long>("StateChangeEventCounter", 0L);
        this._dataChangeEventCounter = new SimpleDynamicMetric<Long>("DataChangeEventCounter", 0L);
        this._outstandingRequestGauge = new SimpleDynamicMetric<Long>("OutstandingRequestGauge", 0L);
        if (zkEventThread != null) {
            this._zkEventThreadMetric = new ZkThreadMetric(zkEventThread);
        }
    }

    public static ObjectName getObjectName(String monitorType, String monitorKey, String monitorInstanceName) throws MalformedObjectNameException {
        return MBeanRegistrar.buildObjectName(MonitorDomainNames.HelixZkClient.name(), MONITOR_TYPE, monitorType, MONITOR_KEY, monitorKey + (monitorInstanceName == null ? "" : "." + monitorInstanceName));
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._dataChangeEventCounter);
        attributeList.add(this._outstandingRequestGauge);
        attributeList.add(this._stateChangeEventCounter);
        if (this._zkEventThreadMetric != null) {
            attributeList.add(this._zkEventThreadMetric);
        }
        this.doRegister(attributeList, MBEAN_DESCRIPTION, ZkClientMonitor.getObjectName(this._monitorType, this._monitorKey, this._monitorInstanceName));
        for (ZkClientPathMonitor.PredefinedPath path : ZkClientPathMonitor.PredefinedPath.values()) {
            if (this._monitorRootOnly && !path.equals((Object)ZkClientPathMonitor.PredefinedPath.Root)) continue;
            this._zkClientPathMonitorMap.put(path, new ZkClientPathMonitor(path, this._monitorType, this._monitorKey, this._monitorInstanceName).register());
        }
        return this;
    }

    @Override
    public void unregister() {
        super.unregister();
        for (ZkClientPathMonitor zkClientPathMonitor : this._zkClientPathMonitorMap.values()) {
            zkClientPathMonitor.unregister();
        }
    }

    @Override
    public String getSensorName() {
        return this._sensorName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseStateChangeEventCounter() {
        SimpleDynamicMetric<Long> simpleDynamicMetric = this._stateChangeEventCounter;
        synchronized (simpleDynamicMetric) {
            this._stateChangeEventCounter.updateValue(this._stateChangeEventCounter.getValue() + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseDataChangeEventCounter() {
        SimpleDynamicMetric<Long> simpleDynamicMetric = this._dataChangeEventCounter;
        synchronized (simpleDynamicMetric) {
            this._dataChangeEventCounter.updateValue(this._dataChangeEventCounter.getValue() + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseOutstandingRequestGauge() {
        SimpleDynamicMetric<Long> simpleDynamicMetric = this._outstandingRequestGauge;
        synchronized (simpleDynamicMetric) {
            this._outstandingRequestGauge.updateValue(this._outstandingRequestGauge.getValue() + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseOutstandingRequestGauge() {
        SimpleDynamicMetric<Long> simpleDynamicMetric = this._outstandingRequestGauge;
        synchronized (simpleDynamicMetric) {
            this._outstandingRequestGauge.updateValue(this._outstandingRequestGauge.getValue() - 1L);
        }
    }

    public void recordDataPropagationLatency(String path, long latencyMilliSec) {
        if (null == path) {
            return;
        }
        Arrays.stream(ZkClientPathMonitor.PredefinedPath.values()).filter(predefinedPath -> predefinedPath.match(path)).forEach(predefinedPath -> {
            ZkClientPathMonitor zkClientPathMonitor = this._zkClientPathMonitorMap.get(predefinedPath);
            if (zkClientPathMonitor != null) {
                zkClientPathMonitor.recordDataPropagationLatency(latencyMilliSec);
            }
        });
    }

    private void record(String path, int bytes, long latencyMilliSec, boolean isFailure, boolean isRead) {
        if (null == path) {
            return;
        }
        Arrays.stream(ZkClientPathMonitor.PredefinedPath.values()).filter(predefinedPath -> predefinedPath.match(path)).forEach(predefinedPath -> {
            ZkClientPathMonitor zkClientPathMonitor = this._zkClientPathMonitorMap.get(predefinedPath);
            if (zkClientPathMonitor != null) {
                zkClientPathMonitor.record(bytes, latencyMilliSec, isFailure, isRead);
            }
        });
    }

    public void record(String path, int dataSize, long startTimeMilliSec, AccessType accessType) {
        switch (accessType) {
            case READ: {
                this.record(path, dataSize, System.currentTimeMillis() - startTimeMilliSec, false, true);
                return;
            }
            case WRITE: {
                this.record(path, dataSize, System.currentTimeMillis() - startTimeMilliSec, false, false);
                return;
            }
        }
    }

    public void recordFailure(String path, AccessType accessType) {
        switch (accessType) {
            case READ: {
                this.record(path, 0, 0L, true, true);
                return;
            }
            case WRITE: {
                this.record(path, 0, 0L, true, false);
                return;
            }
        }
    }

    class ZkThreadMetric
    extends DynamicMetric<ZkEventThread, ZkEventThread> {
        public ZkThreadMetric(ZkEventThread eventThread) {
            super("ZkEventThead", eventThread);
        }

        @Override
        protected Set<MBeanAttributeInfo> generateAttributeInfos(String metricName, ZkEventThread eventThread) {
            HashSet<MBeanAttributeInfo> attributeInfoSet = new HashSet<MBeanAttributeInfo>();
            attributeInfoSet.add(new MBeanAttributeInfo("PendingCallbackGauge", Long.TYPE.getName(), "Attribute exposed for management", true, false, false));
            attributeInfoSet.add(new MBeanAttributeInfo("TotalCallbackCounter", Long.TYPE.getName(), "Attribute exposed for management", true, false, false));
            attributeInfoSet.add(new MBeanAttributeInfo("TotalCallbackHandledCounter", Long.TYPE.getName(), "Attribute exposed for management", true, false, false));
            return attributeInfoSet;
        }

        @Override
        public Object getAttributeValue(String attributeName) {
            switch (attributeName) {
                case "PendingCallbackGauge": {
                    return ((ZkEventThread)this.getMetricObject()).getPendingEventsCount();
                }
                case "TotalCallbackCounter": {
                    return ((ZkEventThread)this.getMetricObject()).getTotalEventCount();
                }
                case "TotalCallbackHandledCounter": {
                    return ((ZkEventThread)this.getMetricObject()).getTotalHandledEventCount();
                }
            }
            throw new MetricException("Unknown attribute name: " + attributeName);
        }

        @Override
        public void updateValue(ZkEventThread newEventThread) {
            this.setMetricObject(newEventThread);
        }
    }

    public static enum AccessType {
        READ,
        WRITE;

    }
}

