/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.callback;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.helix.zookeeper.zkclient.metric.ZkClientMonitor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkAsyncCallbacks {
    private static Logger LOG = LoggerFactory.getLogger(ZkAsyncCallbacks.class);

    public static class ZkAsyncCallContext {
        private long _startTimeMilliSec;
        private int _bytes;
        private ZkClientMonitor _monitor;
        private boolean _isRead;

        public ZkAsyncCallContext(ZkClientMonitor monitor, long startTimeMilliSec, int bytes, boolean isRead) {
            this._monitor = monitor;
            this._startTimeMilliSec = startTimeMilliSec;
            this._bytes = bytes;
            this._isRead = isRead;
        }
    }

    public static abstract class DefaultCallback {
        AtomicBoolean _lock = new AtomicBoolean(false);
        int _rc = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(int rc, String path, Object ctx) {
            ZkAsyncCallContext zkCtx;
            if (rc != 0 && LOG.isDebugEnabled()) {
                LOG.debug(this + ", rc:" + KeeperException.Code.get((int)rc) + ", path: " + path);
            }
            if (ctx != null && ctx instanceof ZkAsyncCallContext && (zkCtx = (ZkAsyncCallContext)ctx)._monitor != null) {
                if (zkCtx._isRead) {
                    zkCtx._monitor.record(path, zkCtx._bytes, zkCtx._startTimeMilliSec, ZkClientMonitor.AccessType.READ);
                } else {
                    zkCtx._monitor.record(path, zkCtx._bytes, zkCtx._startTimeMilliSec, ZkClientMonitor.AccessType.WRITE);
                }
            }
            this._rc = rc;
            this.handle();
            AtomicBoolean atomicBoolean = this._lock;
            synchronized (atomicBoolean) {
                this._lock.set(true);
                this._lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForSuccess() {
            try {
                AtomicBoolean atomicBoolean = this._lock;
                synchronized (atomicBoolean) {
                    while (!this._lock.get()) {
                        this._lock.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted waiting for success", (Throwable)e);
            }
            return true;
        }

        public int getRc() {
            return this._rc;
        }

        public abstract void handle();
    }

    public static class DeleteCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.VoidCallback {
        public void processResult(int rc, String path, Object ctx) {
            this.callback(rc, path, ctx);
        }

        @Override
        public void handle() {
        }
    }

    public static class CreateCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StringCallback {
        public void processResult(int rc, String path, Object ctx, String name) {
            this.callback(rc, path, ctx);
        }

        @Override
        public void handle() {
        }
    }

    public static class ExistsCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StatCallback {
        public Stat _stat;

        @Override
        public void handle() {
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc == 0) {
                this._stat = stat;
            }
            this.callback(rc, path, ctx);
        }
    }

    public static class SetDataCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StatCallback {
        Stat _stat;

        @Override
        public void handle() {
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc == 0) {
                this._stat = stat;
            }
            this.callback(rc, path, ctx);
        }

        public Stat getStat() {
            return this._stat;
        }
    }

    public static class GetDataCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.DataCallback {
        public byte[] _data;
        public Stat _stat;

        @Override
        public void handle() {
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            if (rc == 0) {
                this._data = data;
                this._stat = stat;
                if (this._data != null && ctx != null && ctx instanceof ZkAsyncCallContext) {
                    ZkAsyncCallContext zkCtx = (ZkAsyncCallContext)ctx;
                    zkCtx._bytes = this._data.length;
                }
            }
            this.callback(rc, path, ctx);
        }
    }
}

