/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.datamodel.TrieRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpRoutingDataReader {
    private static final String SYSTEM_MSDS_ENDPOINT = System.getProperty("metadataStoreDirectoryServerEndpoint");
    private static final int HTTP_TIMEOUT_IN_MS = 5000;
    private static volatile Map<String, Map<String, List<String>>> _rawRoutingDataMap = new ConcurrentHashMap<String, Map<String, List<String>>>();
    private static volatile Map<String, MetadataStoreRoutingData> _metadataStoreRoutingDataMap = new ConcurrentHashMap<String, MetadataStoreRoutingData>();

    private HttpRoutingDataReader() {
    }

    public static Map<String, List<String>> getRawRoutingData() throws IOException {
        if (SYSTEM_MSDS_ENDPOINT == null || SYSTEM_MSDS_ENDPOINT.isEmpty()) {
            throw new IllegalStateException("HttpRoutingDataReader was unable to find a valid MSDS endpoint String in System Properties!");
        }
        return HttpRoutingDataReader.getRawRoutingData(SYSTEM_MSDS_ENDPOINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, List<String>> getRawRoutingData(String msdsEndpoint) throws IOException {
        Map<String, List<String>> rawRoutingData = _rawRoutingDataMap.get(msdsEndpoint);
        if (rawRoutingData != null) return rawRoutingData;
        Class<HttpRoutingDataReader> clazz = HttpRoutingDataReader.class;
        synchronized (HttpRoutingDataReader.class) {
            rawRoutingData = _rawRoutingDataMap.get(msdsEndpoint);
            if (rawRoutingData != null) return rawRoutingData;
            String routingDataJson = HttpRoutingDataReader.getAllRoutingData(msdsEndpoint);
            rawRoutingData = HttpRoutingDataReader.parseRoutingData(routingDataJson);
            _rawRoutingDataMap.put(msdsEndpoint, rawRoutingData);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return rawRoutingData;
        }
    }

    public static MetadataStoreRoutingData getMetadataStoreRoutingData() throws IOException, InvalidRoutingDataException {
        if (SYSTEM_MSDS_ENDPOINT == null || SYSTEM_MSDS_ENDPOINT.isEmpty()) {
            throw new IllegalStateException("HttpRoutingDataReader was unable to find a valid MSDS endpoint String in System Properties!");
        }
        return HttpRoutingDataReader.getMetadataStoreRoutingData(SYSTEM_MSDS_ENDPOINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetadataStoreRoutingData getMetadataStoreRoutingData(String msdsEndpoint) throws IOException, InvalidRoutingDataException {
        MetadataStoreRoutingData metadataStoreRoutingData = _metadataStoreRoutingDataMap.get(msdsEndpoint);
        if (metadataStoreRoutingData != null) return metadataStoreRoutingData;
        Class<HttpRoutingDataReader> clazz = HttpRoutingDataReader.class;
        synchronized (HttpRoutingDataReader.class) {
            metadataStoreRoutingData = _metadataStoreRoutingDataMap.get(msdsEndpoint);
            if (metadataStoreRoutingData != null) return metadataStoreRoutingData;
            metadataStoreRoutingData = new TrieRoutingData(HttpRoutingDataReader.getRawRoutingData(msdsEndpoint));
            _metadataStoreRoutingDataMap.put(msdsEndpoint, metadataStoreRoutingData);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return metadataStoreRoutingData;
        }
    }

    public static void reset() {
        _rawRoutingDataMap.clear();
        _metadataStoreRoutingDataMap.clear();
    }

    private static String getAllRoutingData(String msdsEndpoint) throws IOException {
        HttpGet requestAllData = new HttpGet(msdsEndpoint + "/routing-data");
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionBackoffStrategy((ConnectionBackoffStrategy)new DefaultBackoffStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).build();){
            HttpEntity entity = httpClient.execute((HttpUriRequest)requestAllData).getEntity();
            if (entity == null) {
                throw new IOException("Response's entity is null!");
            }
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
    }

    private static Map<String, List<String>> parseRoutingData(String routingDataJson) throws IOException {
        if (routingDataJson != null) {
            Map resultMap = (Map)new ObjectMapper().readValue(routingDataJson, Map.class);
            List routingDataList = (List)resultMap.get("routingData");
            Map<String, List<String>> routingData = routingDataList.stream().collect(Collectors.toMap(realmKeyPair -> (String)realmKeyPair.get("realm"), mapEntry -> (List)mapEntry.get("shardingKeys")));
            return routingData;
        }
        return Collections.emptyMap();
    }
}

