/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.impl.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.util.HttpRoutingDataReader;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.ZkConnection;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallbacks;
import org.apache.helix.zookeeper.zkclient.serialize.BasicZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.PathBasedZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedZkClient
implements RealmAwareZkClient {
    private static final Logger LOG = LoggerFactory.getLogger(FederatedZkClient.class);
    private static final String FEDERATED_ZK_CLIENT = FederatedZkClient.class.getSimpleName();
    private static final String DEDICATED_ZK_CLIENT_FACTORY = DedicatedZkClientFactory.class.getSimpleName();
    private final MetadataStoreRoutingData _metadataStoreRoutingData;
    private final RealmAwareZkClient.RealmAwareZkConnectionConfig _connectionConfig;
    private final RealmAwareZkClient.RealmAwareZkClientConfig _clientConfig;
    private final Map<String, ZkClient> _zkRealmToZkClientMap;
    private volatile boolean _isClosed;
    private PathBasedZkSerializer _pathBasedZkSerializer;

    public FederatedZkClient(RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig) throws IOException, InvalidRoutingDataException {
        if (connectionConfig == null) {
            throw new IllegalArgumentException("RealmAwareZkConnectionConfig cannot be null!");
        }
        if (clientConfig == null) {
            throw new IllegalArgumentException("RealmAwareZkClientConfig cannot be null!");
        }
        String msdsEndpoint = connectionConfig.getMsdsEndpoint();
        this._metadataStoreRoutingData = msdsEndpoint == null || msdsEndpoint.isEmpty() ? HttpRoutingDataReader.getMetadataStoreRoutingData() : HttpRoutingDataReader.getMetadataStoreRoutingData(msdsEndpoint);
        this._isClosed = false;
        this._connectionConfig = connectionConfig;
        this._clientConfig = clientConfig;
        this._pathBasedZkSerializer = clientConfig.getZkSerializer();
        this._zkRealmToZkClientMap = new ConcurrentHashMap<String, ZkClient>();
    }

    @Override
    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        return this.getZkClient(path).subscribeChildChanges(path, listener);
    }

    @Override
    public void unsubscribeChildChanges(String path, IZkChildListener listener) {
        this.getZkClient(path).unsubscribeChildChanges(path, listener);
    }

    @Override
    public void subscribeDataChanges(String path, IZkDataListener listener) {
        this.getZkClient(path).subscribeDataChanges(path, listener);
    }

    @Override
    public void unsubscribeDataChanges(String path, IZkDataListener listener) {
        this.getZkClient(path).unsubscribeDataChanges(path, listener);
    }

    @Override
    public void subscribeStateChanges(IZkStateListener listener) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void unsubscribeStateChanges(IZkStateListener listener) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void subscribeStateChanges(org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener listener) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void unsubscribeStateChanges(org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener listener) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public void unsubscribeAll() {
        this._zkRealmToZkClientMap.values().forEach(org.apache.helix.zookeeper.zkclient.ZkClient::unsubscribeAll);
    }

    @Override
    public void createPersistent(String path) {
        this.createPersistent(path, false);
    }

    @Override
    public void createPersistent(String path, boolean createParents) {
        this.createPersistent(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    @Override
    public void createPersistent(String path, boolean createParents, List<ACL> acl) {
        this.getZkClient(path).createPersistent(path, createParents, acl);
    }

    @Override
    public void createPersistent(String path, Object data) {
        this.create(path, data, CreateMode.PERSISTENT);
    }

    @Override
    public void createPersistent(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.PERSISTENT);
    }

    @Override
    public String createPersistentSequential(String path, Object data) {
        return this.create(path, data, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    @Override
    public String createPersistentSequential(String path, Object data, List<ACL> acl) {
        return this.create(path, data, acl, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    @Override
    public void createEphemeral(String path) {
        this.create(path, null, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, String sessionId) {
        this.createEphemeral(path, null, sessionId);
    }

    @Override
    public void createEphemeral(String path, List<ACL> acl) {
        this.create(path, null, acl, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, List<ACL> acl, String sessionId) {
        this.create(path, null, acl, CreateMode.EPHEMERAL, sessionId);
    }

    @Override
    public String create(String path, Object data, CreateMode mode) {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    @Override
    public String create(String path, Object data, List<ACL> acl, CreateMode mode) {
        return this.create(path, data, acl, mode, null);
    }

    @Override
    public void createEphemeral(String path, Object data) {
        this.create(path, data, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, Object data, String sessionId) {
        this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, sessionId);
    }

    @Override
    public void createEphemeral(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.EPHEMERAL);
    }

    @Override
    public void createEphemeral(String path, Object data, List<ACL> acl, String sessionId) {
        this.create(path, data, acl, CreateMode.EPHEMERAL, sessionId);
    }

    @Override
    public String createEphemeralSequential(String path, Object data) {
        return this.create(path, data, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    @Override
    public String createEphemeralSequential(String path, Object data, List<ACL> acl) {
        return this.create(path, data, acl, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    @Override
    public String createEphemeralSequential(String path, Object data, String sessionId) {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, sessionId);
    }

    @Override
    public String createEphemeralSequential(String path, Object data, List<ACL> acl, String sessionId) {
        return this.create(path, data, acl, CreateMode.EPHEMERAL_SEQUENTIAL, sessionId);
    }

    @Override
    public List<String> getChildren(String path) {
        return this.getZkClient(path).getChildren(path);
    }

    @Override
    public int countChildren(String path) {
        return this.getZkClient(path).countChildren(path);
    }

    @Override
    public boolean exists(String path) {
        return this.getZkClient(path).exists(path);
    }

    @Override
    public Stat getStat(String path) {
        return this.getZkClient(path).getStat(path);
    }

    @Override
    public boolean waitUntilExists(String path, TimeUnit timeUnit, long time) {
        return this.getZkClient(path).waitUntilExists(path, timeUnit, time);
    }

    @Override
    public void deleteRecursively(String path) {
        this.getZkClient(path).deleteRecursively(path);
    }

    @Override
    public boolean delete(String path) {
        return this.getZkClient(path).delete(path);
    }

    @Override
    public <T> T readData(String path) {
        return this.readData(path, false);
    }

    @Override
    public <T> T readData(String path, boolean returnNullIfPathNotExists) {
        return this.getZkClient(path).readData(path, returnNullIfPathNotExists);
    }

    @Override
    public <T> T readData(String path, Stat stat) {
        return this.getZkClient(path).readData(path, stat);
    }

    @Override
    public <T> T readData(String path, Stat stat, boolean watch) {
        return this.getZkClient(path).readData(path, stat, watch);
    }

    @Override
    public <T> T readDataAndStat(String path, Stat stat, boolean returnNullIfPathNotExists) {
        return this.getZkClient(path).readData(path, stat, returnNullIfPathNotExists);
    }

    @Override
    public void writeData(String path, Object object) {
        this.writeData(path, object, -1);
    }

    @Override
    public <T> void updateDataSerialized(String path, DataUpdater<T> updater) {
        this.getZkClient(path).updateDataSerialized(path, updater);
    }

    @Override
    public void writeData(String path, Object data, int expectedVersion) {
        this.writeDataReturnStat(path, data, expectedVersion);
    }

    @Override
    public Stat writeDataReturnStat(String path, Object data, int expectedVersion) {
        return this.getZkClient(path).writeDataReturnStat(path, data, expectedVersion);
    }

    @Override
    public Stat writeDataGetStat(String path, Object data, int expectedVersion) {
        return this.writeDataReturnStat(path, data, expectedVersion);
    }

    @Override
    public void asyncCreate(String path, Object data, CreateMode mode, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        this.getZkClient(path).asyncCreate(path, data, mode, cb);
    }

    @Override
    public void asyncSetData(String path, Object data, int version, ZkAsyncCallbacks.SetDataCallbackHandler cb) {
        this.getZkClient(path).asyncSetData(path, data, version, cb);
    }

    @Override
    public void asyncGetData(String path, ZkAsyncCallbacks.GetDataCallbackHandler cb) {
        this.getZkClient(path).asyncGetData(path, cb);
    }

    @Override
    public void asyncExists(String path, ZkAsyncCallbacks.ExistsCallbackHandler cb) {
        this.getZkClient(path).asyncExists(path, cb);
    }

    @Override
    public void asyncDelete(String path, ZkAsyncCallbacks.DeleteCallbackHandler cb) {
        this.getZkClient(path).asyncDelete(path, cb);
    }

    @Override
    public void watchForData(String path) {
        this.getZkClient(path).watchForData(path);
    }

    @Override
    public List<String> watchForChilds(String path) {
        return this.getZkClient(path).watchForChilds(path);
    }

    @Override
    public long getCreationTime(String path) {
        return this.getZkClient(path).getCreationTime(path);
    }

    @Override
    public List<OpResult> multi(Iterable<Op> ops) {
        this.throwUnsupportedOperationException();
        return null;
    }

    @Override
    public boolean waitUntilConnected(long time, TimeUnit timeUnit) {
        this.throwUnsupportedOperationException();
        return false;
    }

    @Override
    public String getServers() {
        this.throwUnsupportedOperationException();
        return null;
    }

    @Override
    public long getSessionId() {
        this.throwUnsupportedOperationException();
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this._isClosed = true;
        Map<String, ZkClient> map = this._zkRealmToZkClientMap;
        synchronized (map) {
            Iterator<Map.Entry<String, ZkClient>> iterator = this._zkRealmToZkClientMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ZkClient> entry = iterator.next();
                String zkRealm = entry.getKey();
                ZkClient zkClient = entry.getValue();
                try {
                    zkClient.close();
                }
                catch (Exception e) {
                    LOG.error("Exception thrown when closing ZkClient for ZkRealm: {}!", (Object)zkRealm, (Object)e);
                }
                iterator.remove();
            }
        }
        LOG.info("{} is successfully closed.", (Object)FEDERATED_ZK_CLIENT);
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public byte[] serialize(Object data, String path) {
        return this.getZkClient(path).serialize(data, path);
    }

    @Override
    public <T> T deserialize(byte[] data, String path) {
        return this.getZkClient(path).deserialize(data, path);
    }

    @Override
    public void setZkSerializer(ZkSerializer zkSerializer) {
        this._pathBasedZkSerializer = new BasicZkSerializer(zkSerializer);
        this._zkRealmToZkClientMap.values().forEach(zkClient -> zkClient.setZkSerializer(this._pathBasedZkSerializer));
    }

    @Override
    public void setZkSerializer(PathBasedZkSerializer zkSerializer) {
        this._pathBasedZkSerializer = zkSerializer;
        this._zkRealmToZkClientMap.values().forEach(zkClient -> zkClient.setZkSerializer(zkSerializer));
    }

    @Override
    public PathBasedZkSerializer getZkSerializer() {
        return this._pathBasedZkSerializer;
    }

    @Override
    public RealmAwareZkClient.RealmAwareZkConnectionConfig getRealmAwareZkConnectionConfig() {
        return this._connectionConfig;
    }

    @Override
    public RealmAwareZkClient.RealmAwareZkClientConfig getRealmAwareZkClientConfig() {
        return this._clientConfig;
    }

    private String create(String path, Object dataObject, List<ACL> acl, CreateMode mode, String expectedSessionId) {
        if (mode.isEphemeral()) {
            this.throwUnsupportedOperationException();
        }
        return this.getZkClient(path).create(path, dataObject, acl, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZkClient getZkClient(String path) {
        this.checkClosedState();
        String zkRealm = this.getZkRealm(path);
        ZkClient zkClient = this._zkRealmToZkClientMap.get(zkRealm);
        if (zkClient == null) {
            Map<String, ZkClient> map = this._zkRealmToZkClientMap;
            synchronized (map) {
                this.checkClosedState();
                if (!this._zkRealmToZkClientMap.containsKey(zkRealm)) {
                    zkClient = this.createZkClient(zkRealm);
                    this._zkRealmToZkClientMap.put(zkRealm, zkClient);
                } else {
                    zkClient = this._zkRealmToZkClientMap.get(zkRealm);
                }
            }
        }
        return zkClient;
    }

    private String getZkRealm(String path) {
        String zkRealm;
        try {
            zkRealm = this._metadataStoreRoutingData.getMetadataStoreRealm(path);
        }
        catch (NoSuchElementException ex) {
            throw new NoSuchElementException("Cannot find ZK realm for the path: " + path);
        }
        if (zkRealm == null || zkRealm.isEmpty()) {
            throw new NoSuchElementException("Cannot find ZK realm for the path: " + path);
        }
        return zkRealm;
    }

    private ZkClient createZkClient(String zkAddress) {
        LOG.debug("Creating ZkClient for realm: {}.", (Object)zkAddress);
        return new ZkClient(new ZkConnection(zkAddress), (int)this._clientConfig.getConnectInitTimeout(), this._clientConfig.getOperationRetryTimeout(), this._pathBasedZkSerializer, this._clientConfig.getMonitorType(), this._clientConfig.getMonitorKey(), this._clientConfig.getMonitorInstanceName(), this._clientConfig.isMonitorRootPathOnly());
    }

    private void checkClosedState() {
        if (this.isClosed()) {
            throw new IllegalStateException(FEDERATED_ZK_CLIENT + " is closed!");
        }
    }

    private void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException("Session-aware operation is not supported by " + FEDERATED_ZK_CLIENT + ". Instead, please use " + DEDICATED_ZK_CLIENT_FACTORY + " to create a dedicated RealmAwareZkClient for this operation.");
    }
}

