/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans.dynamicMBeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.helix.monitoring.SensorNameProvider;
import org.apache.helix.monitoring.mbeans.MBeanRegistrar;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicMBeanProvider
implements DynamicMBean,
SensorNameProvider {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    protected static final long DEFAULT_RESET_INTERVAL_MS = 3600000L;
    private static final String HELIX_MONITOR_TIME_WINDOW_LENGTH_MS = "helix.monitor.slidingTimeWindow.ms";
    private static String SENSOR_NAME_TAG = "SensorName";
    private static String DEFAULT_DESCRIPTION = "Information on the management interface of the MBean";
    private final Map<String, DynamicMetric> _attributeMap = new HashMap<String, DynamicMetric>();
    private ObjectName _objectName = null;
    private MBeanInfo _mBeanInfo;

    protected synchronized boolean doRegister(Collection<DynamicMetric<?, ?>> dynamicMetrics, String description, String domain, String ... keyValuePairs) throws JMException {
        return this.doRegister(dynamicMetrics, description, MBeanRegistrar.buildObjectName(domain, keyValuePairs));
    }

    protected synchronized boolean doRegister(Collection<DynamicMetric<?, ?>> dynamicMetrics, String description, ObjectName objectName) throws JMException {
        if (this._objectName != null) {
            this._logger.debug("Mbean {} has already been registered. Ignore register request.", (Object)objectName.getCanonicalName());
            return false;
        }
        this.updateAttributtInfos(dynamicMetrics, description);
        this._objectName = MBeanRegistrar.register(this, objectName);
        return true;
    }

    protected synchronized boolean doRegister(Collection<DynamicMetric<?, ?>> dynamicMetrics, ObjectName objectName) throws JMException {
        return this.doRegister(dynamicMetrics, null, objectName);
    }

    private void updateAttributtInfos(Collection<DynamicMetric<?, ?>> dynamicMetrics, String description) {
        this._attributeMap.clear();
        ArrayList<MBeanAttributeInfo> attributeInfoList = new ArrayList<MBeanAttributeInfo>();
        if (dynamicMetrics != null) {
            for (DynamicMetric<?, ?> dynamicMetric : dynamicMetrics) {
                for (MBeanAttributeInfo attributeInfo : dynamicMetric.getAttributeInfos()) {
                    attributeInfoList.add(attributeInfo);
                    this._attributeMap.put(attributeInfo.getName(), dynamicMetric);
                }
            }
        }
        attributeInfoList.add(new MBeanAttributeInfo(SENSOR_NAME_TAG, String.class.getName(), "The name of the metric sensor", true, false, false));
        MBeanConstructorInfo constructorInfo = new MBeanConstructorInfo(String.format("Default %s Constructor", this.getClass().getSimpleName()), this.getClass().getConstructors()[0]);
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[attributeInfoList.size()];
        attributeInfos = attributeInfoList.toArray(attributeInfos);
        if (description == null) {
            description = DEFAULT_DESCRIPTION;
        }
        this._mBeanInfo = new MBeanInfo(this.getClass().getName(), description, attributeInfos, new MBeanConstructorInfo[]{constructorInfo}, new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
    }

    public abstract DynamicMBeanProvider register() throws JMException;

    public synchronized void unregister() {
        MBeanRegistrar.unregister(this._objectName);
        this._objectName = null;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (SENSOR_NAME_TAG.equals(attribute)) {
            return this.getSensorName();
        }
        if (!this._attributeMap.containsKey(attribute)) {
            return null;
        }
        return this._attributeMap.get(attribute).getAttributeValue(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        for (String attributeName : attributes) {
            try {
                Object value = this.getAttribute(attributeName);
                attributeList.add(new Attribute(attributeName, value));
            }
            catch (AttributeNotFoundException | MBeanException | ReflectionException ex) {
                this._logger.error("Failed to get attribute: " + attributeName, (Throwable)ex);
            }
        }
        return attributeList;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    protected void incrementSimpleDynamicMetric(SimpleDynamicMetric<Long> metric) {
        this.incrementSimpleDynamicMetric(metric, 1L);
    }

    protected void incrementSimpleDynamicMetric(SimpleDynamicMetric<Long> metric, long value) {
        metric.updateValue(metric.getValue() + value);
    }

    protected Long getResetIntervalInMs() {
        return this.getSystemPropertyAsLong(HELIX_MONITOR_TIME_WINDOW_LENGTH_MS, 3600000L);
    }

    private long getSystemPropertyAsLong(String propertyKey, long propertyDefaultValue) {
        String valueString = System.getProperty(propertyKey, "" + propertyDefaultValue);
        try {
            long value = Long.parseLong(valueString);
            if (value > 0L) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            this._logger.warn("Exception while parsing property: " + propertyKey + ", string: " + valueString + ", using default value: " + propertyDefaultValue);
        }
        return propertyDefaultValue;
    }
}

