/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.restlet;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.controller.restlet.ZKPropertyTransferServer;
import org.apache.helix.controller.restlet.ZNRecordUpdate;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;

public class ZNRecordUpdateResource
extends ServerResource {
    public static final String UPDATEKEY = "ZNRecordUpdate";
    private static Logger LOG = Logger.getLogger(ZNRecordUpdateResource.class);

    public ZNRecordUpdateResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation put(Representation entity) {
        try {
            ZKPropertyTransferServer server = ZKPropertyTransferServer.getInstance();
            Form form = new Form(entity);
            String jsonPayload = form.getFirstValue(UPDATEKEY, true);
            StringReader sr = new StringReader(jsonPayload);
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<TreeMap<String, ZNRecordUpdate>> typeRef = new TypeReference<TreeMap<String, ZNRecordUpdate>>(){};
            Map holderMap = (Map)mapper.readValue((Reader)sr, (TypeReference)typeRef);
            for (ZNRecordUpdate holder : holderMap.values()) {
                server.enqueueData(holder);
                LOG.info((Object)("Received " + holder.getPath() + " from " + this.getRequest().getClientInfo().getAddress()));
            }
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        }
        return null;
    }
}

