/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.ConstraintBasedAssignment;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.ResourceAssignment;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class SemiAutoRebalancer
implements Rebalancer,
MappingCalculator {
    private static final Logger LOG = Logger.getLogger(SemiAutoRebalancer.class);

    @Override
    public void init(HelixManager manager) {
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        return currentIdealState;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing resource:" + resource.getResourceName()));
        }
        ResourceAssignment partitionMapping = new ResourceAssignment();
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(partition.toString());
            List<String> preferenceList = ConstraintBasedAssignment.getPreferenceList(cache, partition, idealState, stateModelDef);
            Map<String, String> bestStateForPartition = ConstraintBasedAssignment.computeAutoBestStateForPartition(cache, stateModelDef, preferenceList, currentStateMap, disabledInstancesForPartition);
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        return partitionMapping;
    }
}

