/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class ExternalCommand {
    public static final String MODULE = ExternalCommand.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final ProcessBuilder _processBuilder;
    private Process _process;
    private InputReader _out;
    private InputReader _err;

    public ExternalCommand(ProcessBuilder processBuilder) {
        this._processBuilder = processBuilder;
    }

    public void start() throws IOException {
        this._process = this._processBuilder.start();
        this._out = new InputReader(new BufferedInputStream(this._process.getInputStream()));
        this._err = new InputReader(new BufferedInputStream(this._process.getErrorStream()));
        this._out.start();
        this._err.start();
    }

    public Map<String, String> getEnvironment() {
        return this._processBuilder.environment();
    }

    public File getWorkingDirectory() {
        return this._processBuilder.directory();
    }

    public void setWorkingDirectory(File directory) {
        this._processBuilder.directory(directory);
    }

    public boolean getRedirectErrorStream() {
        return this._processBuilder.redirectErrorStream();
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this._processBuilder.redirectErrorStream(redirectErrorStream);
    }

    public byte[] getOutput() throws InterruptedException {
        this.waitFor();
        return this._out.getOutput();
    }

    public byte[] getError() throws InterruptedException {
        this.waitFor();
        return this._err.getOutput();
    }

    public String getStringOutput(String encoding) throws InterruptedException, UnsupportedEncodingException {
        return new String(this.getOutput(), encoding);
    }

    public String getStringOutput() throws InterruptedException {
        try {
            return this.getStringOutput("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getStringError(String encoding) throws InterruptedException, UnsupportedEncodingException {
        return new String(this.getError(), encoding);
    }

    public String getStringError() throws InterruptedException {
        try {
            return this.getStringError("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int waitFor() throws InterruptedException {
        if (this._process == null) {
            throw new IllegalStateException("you must call start first");
        }
        this._out.join();
        this._err.join();
        return this._process.waitFor();
    }

    public int waitFor(long timeout) throws InterruptedException, TimeoutException {
        if (this._process == null) {
            throw new IllegalStateException("you must call start first");
        }
        this._out.join(timeout);
        if (timeout <= 0L) {
            throw new TimeoutException("Wait timed out");
        }
        this._err.join(timeout);
        if (timeout <= 0L) {
            throw new TimeoutException("Wait timed out");
        }
        return this._process.waitFor();
    }

    public int exitValue() {
        if (this._process == null) {
            throw new IllegalStateException("you must call start first");
        }
        return this._process.exitValue();
    }

    public void destroy() {
        if (this._process == null) {
            throw new IllegalStateException("you must call start first");
        }
        this._process.destroy();
    }

    public static ExternalCommand create(String ... commands) {
        ExternalCommand ec = new ExternalCommand(new ProcessBuilder(commands));
        return ec;
    }

    public static ExternalCommand create(List<String> commands) {
        ExternalCommand ec = new ExternalCommand(new ProcessBuilder(commands));
        return ec;
    }

    public static ExternalCommand start(String ... commands) throws IOException {
        ExternalCommand ec = new ExternalCommand(new ProcessBuilder(commands));
        ec.start();
        return ec;
    }

    public static ExternalCommand execute(File workingDirectory, String command, String ... args) throws IOException, InterruptedException {
        try {
            return ExternalCommand.executeWithTimeout(workingDirectory, command, 0L, args);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(MODULE + ".execute: Unexpected timeout occurred!");
        }
    }

    public static ExternalCommand executeWithTimeout(File workingDirectory, String command, long timeout, String ... args) throws IOException, InterruptedException, TimeoutException {
        ArrayList<String> arguments = new ArrayList<String>(args.length + 1);
        arguments.add(new File(workingDirectory, command).getAbsolutePath());
        arguments.addAll(Arrays.asList(args));
        ExternalCommand cmd = ExternalCommand.create(arguments);
        cmd.setWorkingDirectory(workingDirectory);
        cmd.setRedirectErrorStream(true);
        cmd.start();
        if (timeout <= 0L) {
            cmd.waitFor();
        } else {
            cmd.waitFor(timeout);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)cmd.getStringOutput());
        }
        return cmd;
    }

    private static class InputReader
    extends Thread {
        private static final int BUFFER_SIZE = 2048;
        private final InputStream _in;
        private final ByteArrayOutputStream _out;
        private boolean _running = false;

        InputReader(InputStream in) {
            this._in = in;
            this._out = new ByteArrayOutputStream();
        }

        @Override
        public void run() {
            this._running = true;
            byte[] buf = new byte[2048];
            int n = 0;
            try {
                while ((n = this._in.read(buf)) != -1) {
                    this._out.write(buf, 0, n);
                }
            }
            catch (IOException e) {
                LOG.error((Object)"error while reading external command", (Throwable)e);
            }
            this._running = false;
        }

        public byte[] getOutput() {
            if (this._running) {
                throw new IllegalStateException("wait for process to be completed");
            }
            return this._out.toByteArray();
        }
    }
}

