/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.spi.Required;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="from")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FromDefinition
extends OptionalIdentifiedDefinition<FromDefinition> {
    @XmlAttribute
    private String uri;
    @XmlAttribute
    private String ref;
    @XmlTransient
    private Endpoint endpoint;

    public FromDefinition() {
    }

    public FromDefinition(String uri) {
        this.setUri(uri);
    }

    public FromDefinition(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    public String toString() {
        return "From[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "from";
    }

    @Override
    public String getLabel() {
        return FromDefinition.description(this.getUri(), this.getRef(), this.getEndpoint());
    }

    public Endpoint resolveEndpoint(RouteContext context) {
        if (this.endpoint == null) {
            return context.resolveEndpoint(this.getUri(), this.getRef());
        }
        return this.endpoint;
    }

    public String getUri() {
        if (this.uri != null) {
            return this.uri;
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        return null;
    }

    @Required
    public void setUri(String uri) {
        this.clear();
        this.uri = uri;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.clear();
        this.ref = ref;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.uri = null;
        if (endpoint != null) {
            this.uri = endpoint.getEndpointUri();
        }
    }

    public Object getUriOrRef() {
        if (ObjectHelper.isNotEmpty(this.uri)) {
            return this.uri;
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        return this.ref;
    }

    protected static String description(String uri, String ref, Endpoint endpoint) {
        if (ref != null) {
            return "ref:" + ref;
        }
        if (endpoint != null) {
            return endpoint.getEndpointUri();
        }
        if (uri != null) {
            return uri;
        }
        return "no uri or ref supplied!";
    }

    protected void clear() {
        this.endpoint = null;
        this.ref = null;
        this.uri = null;
    }
}

