/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.thrift2.ThriftServer;
import org.apache.hadoop.hbase.thrift2.client.ThriftConnection;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RestTests.class, MediumTests.class})
public class TestThriftConnection {
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftConnection.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftConnection.class);
    private static final byte[] FAMILYA = Bytes.toBytes((String)"fa");
    private static final byte[] FAMILYB = Bytes.toBytes((String)"fb");
    private static final byte[] FAMILYC = Bytes.toBytes((String)"fc");
    private static final byte[] FAMILYD = Bytes.toBytes((String)"fd");
    private static final byte[] ROW_1 = Bytes.toBytes((String)"testrow1");
    private static final byte[] ROW_2 = Bytes.toBytes((String)"testrow2");
    private static final byte[] ROW_3 = Bytes.toBytes((String)"testrow3");
    private static final byte[] ROW_4 = Bytes.toBytes((String)"testrow4");
    private static final byte[] QUALIFIER_1 = Bytes.toBytes((String)"1");
    private static final byte[] QUALIFIER_2 = Bytes.toBytes((String)"2");
    private static final byte[] VALUE_1 = Bytes.toBytes((String)"testvalue1");
    private static final byte[] VALUE_2 = Bytes.toBytes((String)"testvalue2");
    private static final long ONE_HOUR = 3600000L;
    private static final long TS_2 = EnvironmentEdgeManager.currentTime();
    private static final long TS_1 = TS_2 - 3600000L;
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static ThriftServer thriftServer;
    protected static ThriftServer thriftHttpServer;
    protected static int thriftPort;
    protected static int httpPort;
    protected static Connection thriftConnection;
    protected static Connection thriftHttpConnection;
    private static Admin thriftAdmin;

    private static ThriftServer startThriftServer(int port, boolean useHttp) {
        Configuration thriftServerConf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        thriftServerConf.setInt("hbase.regionserver.thrift.port", port);
        if (useHttp) {
            thriftServerConf.setBoolean("hbase.regionserver.thrift.http", true);
        }
        ThriftServer server = new ThriftServer(thriftServerConf);
        Thread thriftServerThread = new Thread(() -> {
            try {
                server.run();
            }
            catch (Exception t) {
                LOG.error("Thrift Server failed", (Throwable)t);
            }
        });
        thriftServerThread.setDaemon(true);
        thriftServerThread.start();
        if (useHttp) {
            TEST_UTIL.waitFor(10000L, () -> server.getHttpServer() != null);
        } else {
            TEST_UTIL.waitFor(10000L, () -> server.getTserver() != null);
        }
        return server;
    }

    private static Connection createConnection(int port, boolean useHttp) throws IOException {
        Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf.set("hbase.client.connection.impl", ThriftConnection.class.getName());
        if (useHttp) {
            conf.set("hbase.thrift.client.builder.class", ThriftConnection.HTTPThriftClientBuilder.class.getName());
        }
        String host = "localhost";
        if (useHttp) {
            host = "http://" + host;
        }
        conf.set("hbase.thrift.server.name", host);
        conf.setInt("hbase.thrift.server.port", port);
        return ConnectionFactory.createConnection((Configuration)conf);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.thrift.info.port", -1);
        TEST_UTIL.startMiniCluster();
        thriftPort = HBaseTestingUtility.randomFreePort();
        httpPort = HBaseTestingUtility.randomFreePort();
        thriftServer = TestThriftConnection.startThriftServer(thriftPort, false);
        thriftHttpServer = TestThriftConnection.startThriftServer(httpPort, true);
        thriftConnection = TestThriftConnection.createConnection(thriftPort, false);
        thriftHttpConnection = TestThriftConnection.createConnection(httpPort, true);
        thriftAdmin = thriftConnection.getAdmin();
        LOG.info("TS_1=" + TS_1);
        LOG.info("TS_2=" + TS_1);
    }

    @AfterClass
    public static void shutdown() throws Exception {
        if (thriftAdmin != null) {
            thriftAdmin.close();
        }
        if (thriftHttpConnection != null) {
            thriftHttpConnection.close();
        }
        if (thriftConnection != null) {
            thriftConnection.close();
        }
        if (thriftHttpServer != null) {
            thriftHttpServer.stop();
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetClusterId() {
        String actualClusterId = TEST_UTIL.getMiniHBaseCluster().getMaster().getClusterId();
        for (Connection conn : new Connection[]{thriftConnection, thriftHttpConnection}) {
            String thriftClusterId = conn.getClusterId();
            Assert.assertEquals((Object)actualClusterId, (Object)thriftClusterId);
        }
    }

    @Test
    public void testThriftAdmin() throws Exception {
        this.testThriftAdmin(thriftConnection, "testThriftAdminNamespace", "testThriftAdminTable");
        this.testThriftAdmin(thriftHttpConnection, "testThriftHttpAdminNamespace", "testThriftHttpAdminTable");
    }

    @Test
    public void testGet() throws Exception {
        this.testGet(thriftConnection, "testGetTable");
        this.testGet(thriftHttpConnection, "testGetHttpTable");
    }

    private void testGet(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            Get get = new Get(ROW_1);
            Result result = table.get(get);
            byte[] value1 = result.getValue(FAMILYA, QUALIFIER_1);
            byte[] value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNull((Object)value2);
            get = new Get(ROW_1);
            get.addFamily(FAMILYC);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNull((Object)value1);
            Assert.assertNull((Object)value2);
            get = new Get(ROW_1);
            get.addColumn(FAMILYA, QUALIFIER_1);
            get.addColumn(FAMILYB, QUALIFIER_2);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNull((Object)value2);
            get = new Get(ROW_2);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
            Assert.assertNotNull((Object)value2);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
            get = new Get(ROW_2);
            get.addFamily(FAMILYA);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
            Assert.assertNull((Object)value2);
            get = new Get(ROW_2);
            get.addColumn(FAMILYA, QUALIFIER_1);
            get.addColumn(FAMILYB, QUALIFIER_2);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
            Assert.assertNotNull((Object)value2);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
            get = new Get(ROW_2);
            get.addFamily(FAMILYA);
            get.addFamily(FAMILYB);
            get.setTimestamp(TS_1);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNull((Object)value2);
            get = new Get(ROW_2);
            get.addFamily(FAMILYA);
            get.addFamily(FAMILYB);
            get.setTimeRange(0L, TS_1 + 1L);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNull((Object)value2);
            get = new Get(ROW_2);
            get.addFamily(FAMILYA);
            get.setMaxVersions(2);
            result = table.get(get);
            int count = 0;
            for (Cell kv : result.listCells()) {
                if (CellUtil.matchingFamily((Cell)kv, (byte[])FAMILYA) && TS_1 == kv.getTimestamp()) {
                    Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (byte[])VALUE_1));
                    ++count;
                }
                if (!CellUtil.matchingFamily((Cell)kv, (byte[])FAMILYA) || TS_2 != kv.getTimestamp()) continue;
                Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (byte[])VALUE_2));
                ++count;
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testHBASE22011() throws Exception {
        this.testHBASE22011(thriftConnection, "testHBASE22011Table");
        this.testHBASE22011(thriftHttpConnection, "testHBASE22011HttpTable");
    }

    public void testHBASE22011(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            Get get = new Get(ROW_2);
            Result result = table.get(get);
            Assert.assertEquals((long)2L, (long)result.listCells().size());
            ColumnCountGetFilter filter = new ColumnCountGetFilter(1);
            get.setFilter((Filter)filter);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.listCells().size());
        }
    }

    @Test
    public void testMultiGet() throws Exception {
        this.testMultiGet(thriftConnection, "testMultiGetTable");
        this.testMultiGet(thriftHttpConnection, "testMultiGetHttpTable");
    }

    public void testMultiGet(Connection connection, String tableName) throws Exception {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            ArrayList<Get> gets = new ArrayList<Get>(2);
            gets.add(new Get(ROW_1));
            gets.add(new Get(ROW_2));
            Result[] results = table.get(gets);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)2L, (long)results.length);
            Assert.assertEquals((long)1L, (long)results[0].size());
            Assert.assertEquals((long)2L, (long)results[1].size());
            gets = new ArrayList(2);
            Get g = new Get(ROW_1);
            g.setMaxVersions(3);
            gets.add(g);
            Get get2 = new Get(ROW_2);
            get2.setMaxVersions(3);
            gets.add(get2);
            results = table.get(gets);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)2L, (long)results.length);
            Assert.assertEquals((long)1L, (long)results[0].size());
            Assert.assertEquals((long)3L, (long)results[1].size());
            gets = new ArrayList(1);
            gets.add(new Get(Bytes.toBytes((String)"RESALLYREALLYNOTTHERE")));
            results = table.get(gets);
            Assert.assertNotNull((Object)results);
            Assert.assertTrue((boolean)results[0].isEmpty());
            gets = new ArrayList(3);
            gets.add(new Get(Bytes.toBytes((String)"RESALLYREALLYNOTTHERE")));
            gets.add(new Get(ROW_1));
            gets.add(new Get(ROW_2));
            results = table.get(gets);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)3L, (long)results.length);
            Assert.assertTrue((boolean)results[0].isEmpty());
        }
    }

    @Test
    public void testPut() throws Exception {
        this.testPut(thriftConnection, "testPutTable");
        this.testPut(thriftHttpConnection, "testPutHttpTable");
    }

    public void testPut(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            Put put = new Put(ROW_3);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            table.put(put);
            Get get = new Get(ROW_3);
            get.addFamily(FAMILYA);
            Result result = table.get(get);
            byte[] value = result.getValue(FAMILYA, QUALIFIER_1);
            Assert.assertNotNull((Object)value);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value));
            ArrayList<Put> puts = new ArrayList<Put>(3);
            put = new Put(ROW_3);
            put.addColumn(FAMILYB, QUALIFIER_2, VALUE_2);
            puts.add(put);
            put = new Put(ROW_4);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_4);
            put.addColumn(FAMILYB, QUALIFIER_2, VALUE_2);
            puts.add(put);
            table.put(puts);
            get = new Get(ROW_3);
            get.addFamily(FAMILYB);
            result = table.get(get);
            value = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value));
            get = new Get(ROW_4);
            result = table.get(get);
            value = result.getValue(FAMILYA, QUALIFIER_1);
            Assert.assertNotNull((Object)value);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value));
            value = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value));
        }
    }

    @Test
    public void testDelete() throws Exception {
        this.testDelete(thriftConnection, "testDeleteTable");
        this.testDelete(thriftHttpConnection, "testDeleteHttpTable");
    }

    public void testDelete(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            Put put = new Put(ROW_3);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            put.addColumn(FAMILYB, QUALIFIER_2, VALUE_2);
            put.addColumn(FAMILYC, QUALIFIER_1, VALUE_1);
            put.addColumn(FAMILYC, QUALIFIER_2, VALUE_2);
            table.put(put);
            Get get = new Get(ROW_3);
            get.addFamily(FAMILYA);
            get.addFamily(FAMILYB);
            get.addFamily(FAMILYC);
            Result result = table.get(get);
            byte[] value1 = result.getValue(FAMILYA, QUALIFIER_1);
            byte[] value2 = result.getValue(FAMILYB, QUALIFIER_2);
            byte[] value3 = result.getValue(FAMILYC, QUALIFIER_1);
            byte[] value4 = result.getValue(FAMILYC, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNotNull((Object)value2);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
            Assert.assertNotNull((Object)value3);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value3));
            Assert.assertNotNull((Object)value4);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value4));
            Delete delete = new Delete(ROW_3);
            delete.addColumn(FAMILYB, QUALIFIER_2);
            table.delete(delete);
            get = new Get(ROW_3);
            get.addFamily(FAMILYA);
            get.addFamily(FAMILYB);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNull((Object)value2);
            delete = new Delete(ROW_3);
            delete.setTimestamp(1L);
            table.delete(delete);
            get = new Get(ROW_3);
            get.addFamily(FAMILYA);
            get.addFamily(FAMILYB);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNull((Object)value2);
            delete = new Delete(ROW_3);
            delete.addFamily(FAMILYC);
            table.delete(delete);
            get = new Get(ROW_3);
            get.addFamily(FAMILYC);
            result = table.get(get);
            value3 = result.getValue(FAMILYC, QUALIFIER_1);
            value4 = result.getValue(FAMILYC, QUALIFIER_2);
            Assert.assertNull((Object)value3);
            Assert.assertNull((Object)value4);
            delete = new Delete(ROW_3);
            table.delete(delete);
            get = new Get(ROW_3);
            get.addFamily(FAMILYA);
            get.addFamily(FAMILYB);
            result = table.get(get);
            value1 = result.getValue(FAMILYA, QUALIFIER_1);
            value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNull((Object)value1);
            Assert.assertNull((Object)value2);
        }
    }

    @Test
    public void testScanner() throws Exception {
        this.testScanner(thriftConnection, "testScannerTable");
        this.testScanner(thriftHttpConnection, "testScannerHttpTable");
    }

    public void testScanner(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            ArrayList<Put> puts = new ArrayList<Put>(4);
            Put put = new Put(ROW_1);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_2);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_3);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_4);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            table.put(puts);
            ResultScanner scanner = table.getScanner(new Scan());
            Result[] results = scanner.next(1);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)1L, (long)results.length);
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
            Result result = scanner.next();
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])result.getRow()));
            results = scanner.next(2);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)2L, (long)results.length);
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[0].getRow()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[1].getRow()));
            results = scanner.next(1);
            Assert.assertTrue((results == null || results.length == 0 ? 1 : 0) != 0);
            scanner.close();
            scanner = table.getScanner(FAMILYA);
            results = scanner.next(4);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)4L, (long)results.length);
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])results[1].getRow()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[2].getRow()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[3].getRow()));
            scanner.close();
            scanner = table.getScanner(FAMILYA, QUALIFIER_1);
            results = scanner.next(4);
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((long)4L, (long)results.length);
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])results[1].getRow()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[2].getRow()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[3].getRow()));
            scanner.close();
        }
    }

    @Test
    public void testCheckAndDelete() throws Exception {
        this.testCheckAndDelete(thriftConnection, "testCheckAndDeleteTable");
        this.testCheckAndDelete(thriftHttpConnection, "testCheckAndDeleteHttpTable");
    }

    public void testCheckAndDelete(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            Get get = new Get(ROW_1);
            Result result = table.get(get);
            byte[] value1 = result.getValue(FAMILYA, QUALIFIER_1);
            byte[] value2 = result.getValue(FAMILYB, QUALIFIER_2);
            Assert.assertNotNull((Object)value1);
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
            Assert.assertNull((Object)value2);
            Assert.assertTrue((boolean)table.exists(get));
            Assert.assertEquals((long)1L, (long)table.existsAll(Collections.singletonList(get)).length);
            Delete delete = new Delete(ROW_1);
            table.checkAndMutate(ROW_1, FAMILYA).qualifier(QUALIFIER_1).ifEquals(VALUE_1).thenDelete(delete);
            Assert.assertFalse((boolean)table.exists(get));
            Put put = new Put(ROW_1);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            table.put(put);
            Assert.assertTrue((boolean)table.checkAndMutate(ROW_1, FAMILYA).qualifier(QUALIFIER_1).ifEquals(VALUE_1).thenPut(put));
            Assert.assertFalse((boolean)table.checkAndMutate(ROW_1, FAMILYA).qualifier(QUALIFIER_1).ifEquals(VALUE_2).thenPut(put));
        }
    }

    @Test
    public void testIteratorScaner() throws Exception {
        this.testIteratorScanner(thriftConnection, "testIteratorScanerTable");
        this.testIteratorScanner(thriftHttpConnection, "testIteratorScanerHttpTable");
    }

    public void testIteratorScanner(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            ArrayList<Put> puts = new ArrayList<Put>(4);
            Put put = new Put(ROW_1);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_2);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_3);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_4);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            table.put(puts);
            Scan scan = new Scan();
            scan.setCaching(1);
            ResultScanner scanner = table.getScanner(scan);
            Iterator iterator = scanner.iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            int counter = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++counter;
            }
            Assert.assertEquals((long)4L, (long)counter);
        }
    }

    @Test
    public void testReverseScan() throws Exception {
        this.testReverseScan(thriftConnection, "testReverseScanTable");
        this.testReverseScan(thriftHttpConnection, "testReverseScanHttpTable");
    }

    public void testReverseScan(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            ArrayList<Put> puts = new ArrayList<Put>(4);
            Put put = new Put(ROW_1);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_2);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_3);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            put = new Put(ROW_4);
            put.addColumn(FAMILYA, QUALIFIER_1, VALUE_1);
            puts.add(put);
            table.put(puts);
            Scan scan = new Scan();
            scan.setReversed(true);
            scan.setCaching(1);
            ResultScanner scanner = table.getScanner(scan);
            Iterator iterator = scanner.iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            int counter = 0;
            Result lastResult = null;
            while (iterator.hasNext()) {
                Result current = (Result)iterator.next();
                if (lastResult != null) {
                    Assert.assertTrue((Bytes.compareTo((byte[])lastResult.getRow(), (byte[])current.getRow()) > 0 ? 1 : 0) != 0);
                }
                lastResult = current;
                ++counter;
            }
            Assert.assertEquals((long)4L, (long)counter);
        }
    }

    @Test
    public void testScanWithFilters() throws Exception {
        this.testScanWithFilters(thriftConnection, "testScanWithFiltersTable");
        this.testScanWithFilters(thriftHttpConnection, "testScanWithFiltersHttpTable");
    }

    private void testScanWithFilters(Connection connection, String tableName) throws IOException {
        this.createTable(thriftAdmin, tableName);
        try (Table table = connection.getTable(TableName.valueOf((String)tableName));){
            FilterList filterList = new FilterList(new Filter[0]);
            PrefixFilter prefixFilter = new PrefixFilter(Bytes.toBytes((String)"testrow"));
            ColumnValueFilter columnValueFilter = new ColumnValueFilter(FAMILYA, QUALIFIER_1, CompareOperator.EQUAL, VALUE_1);
            filterList.addFilter((Filter)prefixFilter);
            filterList.addFilter((Filter)columnValueFilter);
            Scan scan = new Scan();
            scan.setMaxVersions(2);
            scan.setFilter((Filter)filterList);
            ResultScanner scanner = table.getScanner(scan);
            Iterator iterator = scanner.iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            int counter = 0;
            while (iterator.hasNext()) {
                Result result = (Result)iterator.next();
                counter += result.size();
            }
            Assert.assertEquals((long)2L, (long)counter);
        }
    }

    private TableDescriptor createTable(Admin admin, String tableName) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName));
        ColumnFamilyDescriptorBuilder familyABuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA);
        familyABuilder.setMaxVersions(3);
        ColumnFamilyDescriptorBuilder familyBBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYB);
        familyBBuilder.setMaxVersions(3);
        ColumnFamilyDescriptorBuilder familyCBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYC);
        familyCBuilder.setMaxVersions(3);
        builder.setColumnFamily(familyABuilder.build());
        builder.setColumnFamily(familyBBuilder.build());
        builder.setColumnFamily(familyCBuilder.build());
        TableDescriptor tableDescriptor = builder.build();
        admin.createTable(tableDescriptor);
        try (Table table = TEST_UTIL.getConnection().getTable(TableName.valueOf((String)tableName));){
            Put put = new Put(ROW_1);
            put.addColumn(FAMILYA, QUALIFIER_1, TS_2, VALUE_1);
            table.put(put);
            put = new Put(ROW_2);
            put.addColumn(FAMILYA, QUALIFIER_1, TS_1, VALUE_1);
            put.addColumn(FAMILYA, QUALIFIER_1, TS_2, VALUE_2);
            put.addColumn(FAMILYB, QUALIFIER_2, TS_2, VALUE_2);
            table.put(put);
        }
        return tableDescriptor;
    }

    private void testThriftAdmin(Connection connection, String namespace, String table) throws Exception {
        try (Admin admin = connection.getAdmin();){
            NamespaceDescriptor namespaceDescriptor = NamespaceDescriptor.create((String)namespace).build();
            namespaceDescriptor.setConfiguration("key1", "value1");
            namespaceDescriptor.setConfiguration("key2", "value2");
            admin.createNamespace(namespaceDescriptor);
            NamespaceDescriptor[] namespaceDescriptors = admin.listNamespaceDescriptors();
            boolean found = false;
            for (NamespaceDescriptor nd : namespaceDescriptors) {
                if (!nd.getName().equals(namespace)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
            namespaceDescriptor.setConfiguration("kye3", "value3");
            admin.modifyNamespace(namespaceDescriptor);
            NamespaceDescriptor namespaceDescriptorReturned = admin.getNamespaceDescriptor(namespace);
            Assert.assertTrue((namespaceDescriptorReturned.getConfiguration().size() == 3 ? 1 : 0) != 0);
            TableDescriptor tableDescriptor = this.createTable(admin, table);
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor);
            builder.setDurability(Durability.ASYNC_WAL);
            admin.modifyTable(builder.build());
            ColumnFamilyDescriptor familyA = tableDescriptor.getColumnFamily(FAMILYA);
            ColumnFamilyDescriptorBuilder familyABuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)familyA);
            familyABuilder.setInMemory(true);
            admin.modifyColumnFamily(tableDescriptor.getTableName(), familyABuilder.build());
            ColumnFamilyDescriptorBuilder familyDBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYD);
            familyDBuilder.setDataBlockEncoding(DataBlockEncoding.PREFIX);
            admin.addColumnFamily(tableDescriptor.getTableName(), familyDBuilder.build());
            TableDescriptor tableDescriptorReturned = admin.getDescriptor(tableDescriptor.getTableName());
            Assert.assertTrue((tableDescriptorReturned.getColumnFamilies().length == 4 ? 1 : 0) != 0);
            Assert.assertTrue((tableDescriptorReturned.getDurability() == Durability.ASYNC_WAL ? 1 : 0) != 0);
            ColumnFamilyDescriptor columnFamilyADescriptor1Returned = tableDescriptorReturned.getColumnFamily(FAMILYA);
            Assert.assertTrue((columnFamilyADescriptor1Returned.isInMemory() ? 1 : 0) != 0);
            admin.deleteColumnFamily(tableDescriptor.getTableName(), FAMILYA);
            tableDescriptorReturned = admin.getDescriptor(tableDescriptor.getTableName());
            Assert.assertTrue((tableDescriptorReturned.getColumnFamilies().length == 3 ? 1 : 0) != 0);
            admin.disableTable(tableDescriptor.getTableName());
            Assert.assertTrue((boolean)admin.isTableDisabled(tableDescriptor.getTableName()));
            admin.enableTable(tableDescriptor.getTableName());
            Assert.assertTrue((boolean)admin.isTableEnabled(tableDescriptor.getTableName()));
            Assert.assertTrue((boolean)admin.isTableAvailable(tableDescriptor.getTableName()));
            admin.disableTable(tableDescriptor.getTableName());
            admin.truncateTable(tableDescriptor.getTableName(), true);
            Assert.assertTrue((boolean)admin.isTableAvailable(tableDescriptor.getTableName()));
            admin.disableTable(tableDescriptor.getTableName());
            admin.deleteTable(tableDescriptor.getTableName());
            Assert.assertFalse((boolean)admin.tableExists(tableDescriptor.getTableName()));
            admin.deleteNamespace(namespace);
            namespaceDescriptors = admin.listNamespaceDescriptors();
            found = false;
            for (NamespaceDescriptor nd : namespaceDescriptors) {
                if (!nd.getName().equals(namespace)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((!found ? 1 : 0) != 0);
        }
    }
}

