/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.thrift.ImplType;
import org.apache.hadoop.hbase.thrift.TestThriftServerCmdLine;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift2.generated.TColumnFamilyDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TTableDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TTableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestThrift2ServerCmdLine
extends TestThriftServerCmdLine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThrift2ServerCmdLine.class);
    private static final String TABLENAME = "TestThrift2ServerCmdLineTable";

    public TestThrift2ServerCmdLine(ImplType implType, boolean specifyFramed, boolean specifyBindIP, boolean specifyCompact) {
        super(implType, specifyFramed, specifyBindIP, specifyCompact);
    }

    @Override
    protected Supplier<ThriftServer> getThriftServerSupplier() {
        return () -> new org.apache.hadoop.hbase.thrift2.ThriftServer(TEST_UTIL.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void talkToThriftServer(int port) throws Exception {
        TSocket sock;
        TSocket transport = sock = new TSocket(InetAddress.getLoopbackAddress().getHostName(), port);
        if (this.specifyFramed || this.implType.isAlwaysFramed()) {
            transport = new TFramedTransport((TTransport)transport);
        }
        sock.open();
        try {
            Object tProtocol = this.specifyCompact ? new TCompactProtocol((TTransport)transport) : new TBinaryProtocol((TTransport)transport);
            THBaseService.Client client = new THBaseService.Client((TProtocol)tProtocol);
            TTableName tTableName = new TTableName();
            tTableName.setNs(Bytes.toBytes((String)""));
            tTableName.setQualifier(Bytes.toBytes((String)TABLENAME));
            if (!tableCreated) {
                Assert.assertTrue((!client.tableExists(tTableName) ? 1 : 0) != 0);
                TTableDescriptor tTableDescriptor = new TTableDescriptor();
                tTableDescriptor.setTableName(tTableName);
                TColumnFamilyDescriptor columnFamilyDescriptor = new TColumnFamilyDescriptor();
                columnFamilyDescriptor.setName(Bytes.toBytes((String)TABLENAME));
                tTableDescriptor.addToColumns(columnFamilyDescriptor);
                client.createTable(tTableDescriptor, new ArrayList());
                tableCreated = true;
            }
            Assert.assertTrue((String)("tableCreated " + tableCreated), (boolean)client.tableExists(tTableName));
        }
        finally {
            sock.close();
        }
    }
}

