/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThriftServerRunner
extends Thread
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftServerRunner.class);
    Exception exception = null;
    private final ThriftServer thriftServer;
    private final String[] args;

    ThriftServerRunner(ThriftServer thriftServer, String[] args) {
        this.thriftServer = thriftServer;
        this.args = args;
        LOG.info("thriftServer={}, args={}", (Object)this.getThriftServer(), (Object)args);
    }

    ThriftServer getThriftServer() {
        return this.thriftServer;
    }

    Exception getRunException() {
        return this.exception;
    }

    @Override
    public void run() {
        try {
            this.thriftServer.run(this.args);
        }
        catch (Exception e) {
            LOG.error("Run threw an exception", (Throwable)e);
            this.exception = e;
        }
    }

    @Override
    public void close() throws IOException {
        LOG.info("Stopping {}", (Object)this);
        this.thriftServer.stop();
    }
}

