/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.File;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TestThriftHttpServer;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleKdcServerUtil;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kerby.kerberos.kerb.client.JaasKrbUtil;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestThriftSpnegoHttpServer
extends TestThriftHttpServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftSpnegoHttpServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftSpnegoHttpServer.class);
    private static SimpleKdcServer kdc;
    private static File serverKeytab;
    private static File spnegoServerKeytab;
    private static File clientKeytab;
    private static String clientPrincipal;
    private static String serverPrincipal;
    private static String spnegoServerPrincipal;

    private static void addSecurityConfigurations(Configuration conf) {
        KerberosName.setRules((String)"DEFAULT");
        HBaseKerberosUtils.setKeytabFileForTesting((String)serverKeytab.getAbsolutePath());
        conf.setBoolean("hbase.thrift.support.proxyuser", true);
        conf.setBoolean("hbase.regionserver.thrift.http", true);
        conf.set("hbase.thrift.kerberos.principal", serverPrincipal);
        conf.set("hbase.thrift.keytab.file", serverKeytab.getAbsolutePath());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf, (String)serverPrincipal, (String)spnegoServerPrincipal);
        conf.set("hadoop.proxyuser.hbase.hosts", "*");
        conf.set("hadoop.proxyuser.hbase.groups", "*");
        conf.set("hbase.thrift.spnego.principal", spnegoServerPrincipal);
        conf.set("hbase.thrift.spnego.keytab.file", spnegoServerKeytab.getAbsolutePath());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        kdc = SimpleKdcServerUtil.getRunningSimpleKdcServer((File)new File(TEST_UTIL.getDataTestDir().toString()), HBaseTestingUtility::randomFreePort);
        File keytabDir = Paths.get(TEST_UTIL.getRandomDir().toString(), new String[0]).toAbsolutePath().toFile();
        Assert.assertTrue((boolean)keytabDir.mkdirs());
        clientPrincipal = "client@" + kdc.getKdcConfig().getKdcRealm();
        clientKeytab = new File(keytabDir, clientPrincipal + ".keytab");
        kdc.createAndExportPrincipals(clientKeytab, new String[]{clientPrincipal});
        String hostname = InetAddress.getLoopbackAddress().getHostName();
        serverPrincipal = "hbase/" + hostname + "@" + kdc.getKdcConfig().getKdcRealm();
        serverKeytab = new File(keytabDir, serverPrincipal.replace('/', '_') + ".keytab");
        spnegoServerPrincipal = "HTTP/" + hostname + "@" + kdc.getKdcConfig().getKdcRealm();
        spnegoServerKeytab = new File(keytabDir, spnegoServerPrincipal.replace('/', '_') + ".keytab");
        kdc.createAndExportPrincipals(spnegoServerKeytab, new String[]{spnegoServerPrincipal});
        kdc.createAndExportPrincipals(serverKeytab, new String[]{serverPrincipal});
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.http", true);
        TestThriftSpnegoHttpServer.addSecurityConfigurations(TEST_UTIL.getConfiguration());
        TestThriftHttpServer.setUpBeforeClass();
    }

    @Override
    protected Supplier<ThriftServer> getThriftServerSupplier() {
        return () -> new ThriftServer(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestThriftHttpServer.tearDownAfterClass();
        try {
            if (null != kdc) {
                kdc.stop();
                kdc = null;
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop mini KDC", (Throwable)e);
        }
    }

    @Override
    @Ignore
    @Test
    public void testRunThriftServerWithHeaderBufferLength() throws Exception {
        super.testRunThriftServerWithHeaderBufferLength();
    }

    @Override
    protected void talkToThriftServer(String url, int customHeaderSize) throws Exception {
        try (CloseableHttpClient httpClient = this.createHttpClient();
             THttpClient tHttpClient = new THttpClient(url, (HttpClient)httpClient);){
            tHttpClient.open();
            if (customHeaderSize > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < customHeaderSize; ++i) {
                    sb.append("a");
                }
                tHttpClient.setCustomHeader("User-Agent", sb.toString());
            }
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)tHttpClient);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            List bbs = client.getTableNames();
            LOG.info("PRE-EXISTING {}", (Object)bbs.stream().map(b -> Bytes.toString((byte[])b.array())).collect(Collectors.joining(",")));
            if (!bbs.isEmpty()) {
                for (ByteBuffer bb : bbs) {
                    client.disableTable(bb);
                    client.deleteTable(bb);
                }
            }
            TestThriftServer.createTestTables((Hbase.Iface)client);
            TestThriftServer.checkTableList((Hbase.Iface)client);
            TestThriftServer.dropTestTables((Hbase.Iface)client);
        }
    }

    private CloseableHttpClient createHttpClient() throws Exception {
        Subject clientSubject = JaasKrbUtil.loginUsingKeytab((String)clientPrincipal, (File)clientKeytab);
        Set<Principal> clientPrincipals = clientSubject.getPrincipals();
        Assert.assertFalse((String)"Found no client principals in the clientSubject.", (boolean)clientPrincipals.isEmpty());
        Set<KerberosTicket> privateCredentials = clientSubject.getPrivateCredentials(KerberosTicket.class);
        Assert.assertFalse((String)"Found no private credentials in the clientSubject.", (boolean)privateCredentials.isEmpty());
        KerberosTicket tgt = privateCredentials.iterator().next();
        Assert.assertNotNull((String)"No kerberos ticket found.", (Object)tgt);
        String clientPrincipalName = clientPrincipals.iterator().next().getName();
        return Subject.doAs(clientSubject, () -> {
            GSSManager gssManager = GSSManager.getInstance();
            Oid oid = new Oid("1.2.840.113554.1.2.2");
            GSSName gssClient = gssManager.createName(clientPrincipalName, GSSName.NT_USER_NAME);
            GSSCredential credential = gssManager.createCredential(gssClient, 0, oid, 1);
            Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(credential));
            return HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        });
    }
}

