/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.net.BoundSocketMaker;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.ImplType;
import org.apache.hadoop.hbase.thrift.TBoundedThreadPoolServer;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestThriftServerCmdLine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftServerCmdLine.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftServerCmdLine.class);
    protected final ImplType implType;
    protected boolean specifyFramed;
    protected boolean specifyBindIP;
    protected boolean specifyCompact;
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static volatile boolean tableCreated = false;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (ImplType implType : ImplType.values()) {
            for (boolean specifyFramed : new boolean[]{false, true}) {
                for (boolean specifyBindIP : new boolean[]{false, true}) {
                    if (specifyBindIP && !implType.canSpecifyBindIP) continue;
                    for (boolean specifyCompact : new boolean[]{false, true}) {
                        parameters.add(new Object[]{implType, specifyFramed, specifyBindIP, specifyCompact});
                    }
                }
            }
        }
        return parameters;
    }

    public TestThriftServerCmdLine(ImplType implType, boolean specifyFramed, boolean specifyBindIP, boolean specifyCompact) {
        this.implType = implType;
        this.specifyFramed = specifyFramed;
        this.specifyBindIP = specifyBindIP;
        this.specifyCompact = specifyCompact;
        LOG.debug(this.getParametersString());
    }

    private String getParametersString() {
        return "implType=" + this.implType + ", specifyFramed=" + this.specifyFramed + ", specifyBindIP=" + this.specifyBindIP + ", specifyCompact=" + this.specifyCompact;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    static ThriftServerRunner startCmdLineThread(Supplier<ThriftServer> supplier, String[] args) {
        LOG.info("Starting HBase Thrift server with command line: " + Joiner.on((String)" ").join((Object[])args));
        ThriftServerRunner tsr = new ThriftServerRunner(supplier.get(), args);
        tsr.setName(ThriftServer.class.getSimpleName() + "-cmdline");
        tsr.start();
        return tsr;
    }

    static int getRandomPort() {
        return HBaseTestingUtility.randomFreePort();
    }

    protected Supplier<ThriftServer> getThriftServerSupplier() {
        return () -> new ThriftServer(TEST_UTIL.getConfiguration());
    }

    static ThriftServerRunner createBoundServer(Supplier<ThriftServer> thriftServerSupplier) throws Exception {
        return TestThriftServerCmdLine.createBoundServer(thriftServerSupplier, false, false);
    }

    static ThriftServerRunner createBoundServer(Supplier<ThriftServer> thriftServerSupplier, boolean protocolPortClash, boolean infoPortClash) throws Exception {
        return TestThriftServerCmdLine.createBoundServer(thriftServerSupplier, null, false, false, false, protocolPortClash, infoPortClash);
    }

    static ThriftServerRunner createBoundServer(Supplier<ThriftServer> thriftServerSupplier, ImplType implType, boolean specifyFramed, boolean specifyCompact, boolean specifyBindIP) throws Exception {
        return TestThriftServerCmdLine.createBoundServer(thriftServerSupplier, implType, specifyFramed, specifyCompact, specifyBindIP, false, false);
    }

    static ThriftServerRunner createBoundServer(Supplier<ThriftServer> thriftServerSupplier, ImplType implType, boolean specifyFramed, boolean specifyCompact, boolean specifyBindIP, boolean protocolPortClash, boolean infoPortClash) throws Exception {
        if (protocolPortClash && infoPortClash) {
            throw new RuntimeException("Can't set both at same time");
        }
        boolean testClashOfFirstProtocolPort = protocolPortClash;
        boolean testClashOfFirstInfoPort = infoPortClash;
        ArrayList<String> args = new ArrayList<String>();
        BoundSocketMaker bsm = null;
        int port = -1;
        ThriftServerRunner tsr = null;
        for (int i = 0; i < 100; ++i) {
            int infoPort;
            args.clear();
            if (implType != null) {
                String serverTypeOption = implType.toString();
                Assert.assertTrue((boolean)serverTypeOption.startsWith("-"));
                args.add(serverTypeOption);
            }
            if (testClashOfFirstProtocolPort) {
                bsm = new BoundSocketMaker(() -> TestThriftServerCmdLine.getRandomPort());
                port = bsm.getPort();
                testClashOfFirstProtocolPort = false;
            } else {
                port = TestThriftServerCmdLine.getRandomPort();
            }
            args.add("-port");
            args.add(String.valueOf(port));
            args.add("-infoport");
            if (testClashOfFirstInfoPort) {
                bsm = new BoundSocketMaker(() -> TestThriftServerCmdLine.getRandomPort());
                infoPort = bsm.getPort();
                testClashOfFirstInfoPort = false;
            } else {
                infoPort = TestThriftServerCmdLine.getRandomPort();
            }
            args.add(String.valueOf(infoPort));
            if (specifyFramed) {
                args.add("-framed");
            }
            if (specifyBindIP) {
                args.add("-bind");
                args.add(InetAddress.getLoopbackAddress().getHostName());
            }
            if (specifyCompact) {
                args.add("-compact");
            }
            args.add("start");
            tsr = TestThriftServerCmdLine.startCmdLineThread(thriftServerSupplier, args.toArray(new String[args.size()]));
            for (int ii = 0; ii < 100 && tsr.getThriftServer().tserver == null && tsr.getRunException() == null; ++ii) {
                Threads.sleep((long)100L);
            }
            if (!TestThriftServerCmdLine.isBindException(tsr.getRunException())) break;
            LOG.info("BindException; trying new port", (Throwable)tsr.getRunException());
            try {
                tsr.close();
                tsr.join();
                continue;
            }
            catch (IOException | InterruptedException ioe) {
                LOG.warn("Exception closing", (Throwable)ioe);
            }
        }
        if (bsm != null) {
            try {
                bsm.close();
            }
            catch (IOException ioe) {
                LOG.warn("Failed close", (Throwable)ioe);
            }
        }
        if (tsr.getRunException() != null) {
            throw tsr.getRunException();
        }
        if (tsr.getThriftServer().tserver != null) {
            Class expectedClass = implType != null ? implType.serverClass : TBoundedThreadPoolServer.class;
            Assert.assertEquals((Object)expectedClass, tsr.getThriftServer().tserver.getClass());
        }
        return tsr;
    }

    private static boolean isBindException(Exception cmdLineException) {
        if (cmdLineException == null) {
            return false;
        }
        if (cmdLineException instanceof BindException) {
            return true;
        }
        return cmdLineException.getCause() != null && cmdLineException.getCause() instanceof BindException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunThriftServer() throws Exception {
        Exception clientSideException = null;
        for (int i = 0; i < 10; ++i) {
            clientSideException = null;
            ThriftServerRunner thriftServerRunner = TestThriftServerCmdLine.createBoundServer(this.getThriftServerSupplier(), this.implType, this.specifyFramed, this.specifyCompact, this.specifyBindIP);
            try {
                this.talkToThriftServer(thriftServerRunner.getThriftServer().listenPort);
                break;
            }
            catch (Exception ex) {
                clientSideException = ex;
                LOG.info("Exception", (Throwable)ex);
            }
            finally {
                LOG.debug("Stopping " + this.implType.simpleClassName() + " Thrift server");
                thriftServerRunner.close();
                thriftServerRunner.join();
                if (thriftServerRunner.getRunException() == null) continue;
                LOG.error("Command-line invocation of HBase Thrift server threw exception", (Throwable)thriftServerRunner.getRunException());
                throw thriftServerRunner.getRunException();
            }
        }
        if (clientSideException != null) {
            LOG.error("Thrift Client; parameters={}", (Object)this.getParametersString(), clientSideException);
            throw new Exception(clientSideException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void talkToThriftServer(int port) throws Exception {
        TSocket sock;
        LOG.info("Talking to port={}", (Object)port);
        TSocket transport = sock = new TSocket(InetAddress.getLoopbackAddress().getHostName(), port);
        if (this.specifyFramed || this.implType.isAlwaysFramed) {
            transport = new TFramedTransport((TTransport)transport);
        }
        sock.open();
        try {
            Object prot = this.specifyCompact ? new TCompactProtocol((TTransport)transport) : new TBinaryProtocol((TTransport)transport);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
        finally {
            sock.close();
        }
    }
}

